/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue myMainQueue;
    @NotNull
    private final MergingUpdateQueue myResultsUpdaterQueue;
    @NotNull
    private final AtomicBoolean myRunning;
    @NotNull
    private final EventDispatcher<AvailableUpdatesListener> myEventDispatcher;

    public PsLibraryUpdateCheckerDaemon(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "<init>"));
        }
        super(context);
        this.myRunning = new AtomicBoolean(true);
        this.myEventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        this.myMainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.myResultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
    }

    public void queueAutomaticUpdateCheck() {
        long elapsed;
        long daysPastSinceLastUpdate;
        long searchTimeMillis = this.getAvailableUpdates().lastSearchTimeMillis;
        if (searchTimeMillis > 0L && (daysPastSinceLastUpdate = TimeUnit.MILLISECONDS.toDays(elapsed = System.currentTimeMillis() - searchTimeMillis)) < 3L) {
            this.myResultsUpdaterQueue.queue((Update)new UpdatesAvailable());
            return;
        }
        this.queueUpdateCheck();
    }

    public void queueUpdateCheck() {
        this.myMainQueue.queue((Update)new SearchForAvailableUpdates());
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myMainQueue;
        if (mergingUpdateQueue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "getMainQueue"));
        }
        return mergingUpdateQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        MergingUpdateQueue mergingUpdateQueue = this.myResultsUpdaterQueue;
        if (mergingUpdateQueue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "getResultsUpdaterQueue"));
        }
        return mergingUpdateQueue;
    }

    @NotNull
    public AvailableLibraryUpdateStorage.AvailableLibraryUpdates getAvailableUpdates() {
        Project project = this.getContext().getProject().getResolvedModel();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates availableLibraryUpdates = AvailableLibraryUpdateStorage.getInstance(project).getState();
        if (availableLibraryUpdates == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "getAvailableUpdates"));
        }
        return availableLibraryUpdates;
    }

    public void add(@NotNull AvailableUpdatesListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "add"));
        }
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.myRunning.get();
    }

    private void search(@NotNull Collection<ArtifactRepository> repositories, @NotNull Collection<LibraryUpdateId> ids) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "search"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "search"));
        }
        this.myRunning.set(true);
        this.getAvailableUpdates().clear();
        int resultCount = repositories.size() * ids.size();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)resultCount);
        HashSet requests = Sets.newHashSet();
        ids.forEach(id -> {
            SearchRequest request = new SearchRequest(id.getName(), id.getGroupId(), 1, 0);
            requests.add(request);
        });
        HashSet results = Sets.newHashSet();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            List<FoundArtifact> artifacts;
            if (repositories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon", "lambda$search$2"));
            }
            for (ArtifactRepository repository : repositories) {
                for (SearchRequest request : requests) {
                    jobs.add(application.executeOnPooledThread(() -> repository.search(request)));
                }
            }
            for (Future job : jobs) {
                try {
                    FoundArtifact artifact;
                    SearchResult result = (SearchResult)Futures.get((Future)job, Exception.class);
                    artifacts = result.getArtifacts();
                    if (artifacts.size() != 1 || (artifact = artifacts.get(0)).getVersions().isEmpty()) continue;
                    results.add(result);
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            AvailableLibraryUpdateStorage.AvailableLibraryUpdates updates = this.getAvailableUpdates();
            for (SearchResult result : results) {
                artifacts = result.getArtifacts();
                updates.add(artifacts.get(0));
            }
            updates.lastSearchTimeMillis = System.currentTimeMillis();
            this.myResultsUpdaterQueue.queue((Update)new UpdatesAvailable());
        });
    }

    public static interface AvailableUpdatesListener
    extends EventListener {
        public void availableUpdates();
    }

    private class UpdatesAvailable
    extends Update {
        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }

        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.myEventDispatcher.getMulticaster()).availableUpdates();
            PsLibraryUpdateCheckerDaemon.this.myRunning.set(false);
        }
    }

    private class SearchForAvailableUpdates
    extends Update {
        public SearchForAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }

        public void run() {
            HashSet repositories = Sets.newHashSet();
            HashSet ids = Sets.newHashSet();
            PsLibraryUpdateCheckerDaemon.this.getContext().getProject().forEachModule(module -> {
                repositories.addAll(module.getArtifactRepositories());
                if (module instanceof PsAndroidModule) {
                    PsAndroidModule androidModule = (PsAndroidModule)module;
                    androidModule.forEachDeclaredDependency(dependency -> {
                        GradleVersion version;
                        PsLibraryDependency libraryDependency;
                        PsArtifactDependencySpec spec;
                        if (dependency instanceof PsLibraryDependency && (spec = (libraryDependency = (PsLibraryDependency)((Object)dependency)).getDeclaredSpec()) != null && StringUtil.isNotEmpty((String)spec.version) && (version = GradleVersion.tryParse((String)spec.version)) != null) {
                            ids.add(new LibraryUpdateId(spec.name, spec.group));
                        }
                    });
                }
            });
            if (repositories.size() > 0 && ids.size() > 0) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, ids);
            }
        }
    }
}

