/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsParsedDependencies;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.JCenterRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.MavenCentralRepository;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsModule
extends PsChildModel {
    @Nullable
    private String myGradlePath;
    @Nullable
    private final Module myResolvedModel;
    private GradleBuildModel myParsedModel;
    private String myModuleName;
    private PsParsedDependencies myParsedDependencies;
    private final EventDispatcher<DependenciesChangeListener> myDependenciesChangeEventDispatcher;

    protected PsModule(@NotNull PsProject parent, @NotNull Module resolvedModel, @NotNull String gradlePath) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/PsModule", "<init>"));
        }
        if (resolvedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedModel", "com/android/tools/idea/gradle/structure/model/PsModule", "<init>"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/structure/model/PsModule", "<init>"));
        }
        super(parent);
        this.myDependenciesChangeEventDispatcher = EventDispatcher.create(DependenciesChangeListener.class);
        this.myResolvedModel = resolvedModel;
        this.myGradlePath = gradlePath;
        this.myModuleName = resolvedModel.getName();
        this.myParsedModel = GradleBuildModel.get(this.myResolvedModel);
    }

    protected PsModule(@NotNull PsProject parent, @NotNull String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/PsModule", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/model/PsModule", "<init>"));
        }
        super(parent);
        this.myDependenciesChangeEventDispatcher = EventDispatcher.create(DependenciesChangeListener.class);
        this.myResolvedModel = null;
        this.myModuleName = name;
    }

    @Override
    @NotNull
    public PsProject getParent() {
        PsProject psProject = (PsProject)super.getParent();
        if (psProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule", "getParent"));
        }
        return psProject;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule", "getName"));
        }
        return string;
    }

    @Override
    public boolean isDeclared() {
        return this.myParsedModel != null;
    }

    @NotNull
    public PsParsedDependencies getParsedDependencies() {
        PsParsedDependencies psParsedDependencies = this.myParsedDependencies == null ? (this.myParsedDependencies = new PsParsedDependencies(this.getParsedModel())) : this.myParsedDependencies;
        if (psParsedDependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule", "getParsedDependencies"));
        }
        return psParsedDependencies;
    }

    @Nullable
    public GradleBuildModel getParsedModel() {
        return this.myParsedModel;
    }

    protected void addLibraryDependencyToParsedModel(@NotNull List<String> configurationNames, @NotNull String compactNotation) {
        if (configurationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationNames", "com/android/tools/idea/gradle/structure/model/PsModule", "addLibraryDependencyToParsedModel"));
        }
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/structure/model/PsModule", "addLibraryDependencyToParsedModel"));
        }
        GradleBuildModel parsedModel = this.getParsedModel();
        if (parsedModel != null) {
            DependenciesModel dependencies = parsedModel.dependencies();
            configurationNames.forEach(configurationName -> {
                if (compactNotation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/structure/model/PsModule", "lambda$addLibraryDependencyToParsedModel$0"));
                }
                dependencies.addArtifact((String)configurationName, compactNotation);
            });
            this.getParsedDependencies().reset(this.getParsedModel());
        }
    }

    public void add(@NotNull DependenciesChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/model/PsModule", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/model/PsModule", "add"));
        }
        this.myDependenciesChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    protected void fireLibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/PsModule", "fireLibraryDependencyAddedEvent"));
        }
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new LibraryDependencyAddedEvent(spec));
    }

    public void fireDependencyModifiedEvent(@NotNull PsDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/model/PsModule", "fireDependencyModifiedEvent"));
        }
        ((DependenciesChangeListener)this.myDependenciesChangeEventDispatcher.getMulticaster()).dependencyChanged(new DependencyModifiedEvent(dependency));
    }

    @Nullable
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @Nullable
    public Module getResolvedModel() {
        return this.myResolvedModel;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Module;
    }

    @NotNull
    public List<ArtifactRepository> getArtifactRepositories() {
        ArrayList repositories = Lists.newArrayList();
        this.populateRepositories(repositories);
        ArrayList arrayList = repositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule", "getArtifactRepositories"));
        }
        return arrayList;
    }

    protected final void populateRepositories(@NotNull List<ArtifactRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/android/tools/idea/gradle/structure/model/PsModule", "populateRepositories"));
        }
        GradleBuildModel parsedModel = this.getParsedModel();
        if (parsedModel != null) {
            for (RepositoryModel repositoryModel : parsedModel.repositories().repositories()) {
                if (repositoryModel instanceof JCenterDefaultRepositoryModel) {
                    repositories.add(new JCenterRepository());
                    continue;
                }
                if (!(repositoryModel instanceof MavenCentralRepositoryModel)) continue;
                repositories.add(new MavenCentralRepository());
            }
        }
    }

    public boolean canDependOn(@NotNull PsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/model/PsModule", "canDependOn"));
        }
        return false;
    }

    public static class DependencyModifiedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsDependency myDependency;

        DependencyModifiedEvent(@NotNull PsDependency dependency) {
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/model/PsModule$DependencyModifiedEvent", "<init>"));
            }
            this.myDependency = dependency;
        }

        @NotNull
        public PsDependency getDependency() {
            PsDependency psDependency = this.myDependency;
            if (psDependency == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule$DependencyModifiedEvent", "getDependency"));
            }
            return psDependency;
        }
    }

    public static class LibraryDependencyAddedEvent
    implements DependencyChangedEvent {
        @NotNull
        private final PsArtifactDependencySpec mySpec;

        LibraryDependencyAddedEvent(@NotNull PsArtifactDependencySpec spec) {
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/PsModule$LibraryDependencyAddedEvent", "<init>"));
            }
            this.mySpec = spec;
        }

        @NotNull
        public PsArtifactDependencySpec getSpec() {
            PsArtifactDependencySpec psArtifactDependencySpec = this.mySpec;
            if (psArtifactDependencySpec == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsModule$LibraryDependencyAddedEvent", "getSpec"));
            }
            return psArtifactDependencySpec;
        }
    }

    public static interface DependencyChangedEvent {
    }

    public static interface DependenciesChangeListener
    extends EventListener {
        public void dependencyChanged(@NotNull DependencyChangedEvent var1);
    }
}

