/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.base.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsDependencyContainer {
    @NotNull
    private final String myVariant;
    @NotNull
    private final String myArtifact;
    @NotNull
    private final String myName;

    PsDependencyContainer(@NotNull PsAndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "<init>"));
        }
        PsVariant variant = artifact.getParent();
        this.myVariant = variant.getName();
        this.myArtifact = artifact.getResolvedName();
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    public PsDependencyContainer(@NotNull String variant, @NotNull String artifact) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "<init>"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "<init>"));
        }
        this.myVariant = variant;
        this.myArtifact = artifact;
        this.myName = PsDependencyContainer.createName(this.myVariant, this.myArtifact);
    }

    @NotNull
    private static String createName(@NotNull String variant, @NotNull String artifact) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "createName"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "createName"));
        }
        String string = variant + " " + artifact;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "createName"));
        }
        return string;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public PsAndroidArtifact findArtifact(@NotNull PsAndroidModule module, boolean mustExist) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "findArtifact"));
        }
        PsVariant variant = module.findVariant(this.myVariant);
        if (variant == null && !mustExist) {
            return null;
        }
        assert (variant != null);
        PsAndroidArtifact artifact = variant.findArtifact(this.myArtifact);
        if (artifact == null && !mustExist) {
            return null;
        }
        assert (artifact != null);
        return artifact;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "getName"));
        }
        return string;
    }

    @NotNull
    public String getVariant() {
        String string = this.myVariant;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "getVariant"));
        }
        return string;
    }

    @NotNull
    public String getArtifact() {
        String string = this.myArtifact;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsDependencyContainer", "getArtifact"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsDependencyContainer container = (PsDependencyContainer)o;
        return Objects.equal((Object)this.myVariant, (Object)container.myVariant) && Objects.equal((Object)this.myArtifact, (Object)container.myArtifact);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myVariant, this.myArtifact});
    }

    public String toString() {
        return this.getName();
    }
}

