/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class ArtifactRepositorySearch {
    @NotNull
    private final List<ArtifactRepository> myRepositories;

    public ArtifactRepositorySearch(@NotNull List<ArtifactRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch", "<init>"));
        }
        this.myRepositories = repositories;
    }

    @NotNull
    public Callback start(@NotNull SearchRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch", "start"));
        }
        Callback callback = new Callback();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)this.myRepositories.size());
        ArrayList results = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch", "lambda$start$1"));
            }
            for (ArtifactRepository repository : this.myRepositories) {
                jobs.add(application.executeOnPooledThread(() -> {
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch", "lambda$null$0"));
                    }
                    return repository.search(request);
                }));
            }
            for (Future job : jobs) {
                try {
                    results.add(Futures.get((Future)job, Exception.class));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            callback.setDone(results, errors);
        });
        Callback callback2 = callback;
        if (callback2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch", "start"));
        }
        return callback2;
    }

    public static class Callback
    extends ActionCallback {
        @NotNull
        private final List<SearchResult> mySearchResults = Lists.newArrayList();
        @NotNull
        private final List<Exception> myErrors = Lists.newArrayList();

        void setDone(@NotNull List<SearchResult> searchResults, @NotNull List<Exception> errors) {
            if (searchResults == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResults", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback", "setDone"));
            }
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback", "setDone"));
            }
            searchResults.forEach(searchResult -> {
                Exception error = searchResult.getError();
                if (error != null) {
                    this.myErrors.add(error);
                    return;
                }
                this.mySearchResults.add((SearchResult)searchResult);
            });
            this.myErrors.addAll(errors);
            this.setDone();
        }

        @NotNull
        public List<SearchResult> getSearchResults() {
            this.checkIsDone();
            List<SearchResult> list = this.mySearchResults;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback", "getSearchResults"));
            }
            return list;
        }

        @NotNull
        public List<Exception> getErrors() {
            this.checkIsDone();
            List<Exception> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback", "getErrors"));
            }
            return list;
        }

        private void checkIsDone() {
            if (!this.isDone()) {
                throw new IllegalStateException("Repository search has not finished yet");
            }
        }
    }
}

