/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util.ui;

import com.android.tools.idea.gradle.util.ui.Header;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class ToolWindowAlikePanel
extends JPanel {
    private final Header myHeader;

    @NotNull
    public static ToolWindowAlikePanel createTreePanel(@NotNull String title, @NotNull JTree tree) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "createTreePanel"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "createTreePanel"));
        }
        ToolWindowAlikePanel panel = new ToolWindowAlikePanel(title, ScrollPaneFactory.createScrollPane((Component)tree));
        Object root = tree.getModel().getRoot();
        if (root instanceof TreeNode && ((TreeNode)root).getChildCount() > 0) {
            DefaultTreeExpander expander = new DefaultTreeExpander(tree);
            CommonActionsManager actions = CommonActionsManager.getInstance();
            AnAction expandAllAction = actions.createExpandAllAction((TreeExpander)expander, (JComponent)tree);
            expandAllAction.getTemplatePresentation().setIcon(AllIcons.General.ExpandAll);
            AnAction collapseAllAction = actions.createCollapseAllAction((TreeExpander)expander, (JComponent)tree);
            collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
            panel.setAdditionalTitleActions(expandAllAction, collapseAllAction);
        }
        ToolWindowAlikePanel toolWindowAlikePanel = panel;
        if (toolWindowAlikePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "createTreePanel"));
        }
        return toolWindowAlikePanel;
    }

    public ToolWindowAlikePanel(@NotNull String title, @NotNull JComponent contents) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "<init>"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myHeader = new Header(title);
        this.add((Component)this.myHeader, "North");
        this.add((Component)contents, "Center");
    }

    public void setAdditionalTitleActions(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/gradle/util/ui/ToolWindowAlikePanel", "setAdditionalTitleActions"));
        }
        this.myHeader.setAdditionalActions(actions);
    }
}

