/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackTraceExpander {
    private static final Pattern EXCEPTION_LINE_PATTERN = Pattern.compile("^\\s*(at .*\\(.*\\))$");
    private static final Pattern ELIDED_LINE_PATTERN = Pattern.compile("^\\s*... (\\d+) more$");
    private static final Pattern CAUSED_BY_LINE_PATTERN = Pattern.compile("^\\s*(Caused by:.*)$");
    private static final String EXPANDED_STACK_TRACE_MARKER = "\u00a0";
    @NotNull
    private final String myStackTracePrefix;
    @NotNull
    private final String myCauseLinePrefix;
    private List<String> myProcessedLines;
    private List<String> myCurrentStack;
    private List<String> myPreviousStack;
    private boolean myIsInTrace;

    public StackTraceExpander(@NotNull String stackTraceLinePrefix, @NotNull String stackTraceCauseLinePrefix) {
        if (stackTraceLinePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTraceLinePrefix", "com/android/tools/idea/logcat/StackTraceExpander", "<init>"));
        }
        if (stackTraceCauseLinePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTraceCauseLinePrefix", "com/android/tools/idea/logcat/StackTraceExpander", "<init>"));
        }
        this.myProcessedLines = new ArrayList<String>();
        this.myCurrentStack = new ArrayList<String>();
        this.myPreviousStack = new ArrayList<String>();
        this.myStackTracePrefix = stackTraceLinePrefix;
        this.myCauseLinePrefix = stackTraceCauseLinePrefix;
        this.reset();
    }

    public void reset() {
        this.myIsInTrace = false;
        this.myProcessedLines.clear();
        this.myCurrentStack.clear();
        this.myPreviousStack.clear();
    }

    public static boolean wasLineExpanded(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "wasLineExpanded"));
        }
        return line.endsWith(EXPANDED_STACK_TRACE_MARKER) && line.contains(" at ");
    }

    @NotNull
    public List<String> process(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
        }
        this.myProcessedLines.clear();
        String stackLine = StackTraceExpander.getStackLine(line);
        if (stackLine != null) {
            this.handleStackTraceLine(stackLine);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
            }
            return list;
        }
        if (!this.myIsInTrace) {
            this.handleNormalLine(line);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
            }
            return list;
        }
        String causeLine = StackTraceExpander.getCauseLine(line);
        if (causeLine != null) {
            this.handleCausedByLine(causeLine);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
            }
            return list;
        }
        int elidedCount = StackTraceExpander.getElidedFrameCount(line);
        if (elidedCount > 0) {
            this.handleElidedLine(line, elidedCount);
            List<String> list = this.myProcessedLines;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
            }
            return list;
        }
        this.handleNormalLine(line);
        List<String> list = this.myProcessedLines;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/StackTraceExpander", "process"));
        }
        return list;
    }

    @Nullable
    static String getStackLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "getStackLine"));
        }
        Matcher matcher = EXCEPTION_LINE_PATTERN.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Nullable
    static String getCauseLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "getCauseLine"));
        }
        Matcher matcher = CAUSED_BY_LINE_PATTERN.matcher(line);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static int getElidedFrameCount(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "getElidedFrameCount"));
        }
        Matcher matcher = ELIDED_LINE_PATTERN.matcher(line);
        return matcher.matches() ? StringUtil.parseInt((String)matcher.group(1), (int)-1) : -1;
    }

    private void handleNormalLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "handleNormalLine"));
        }
        if (this.myIsInTrace) {
            this.myIsInTrace = false;
            this.myCurrentStack.clear();
            this.myPreviousStack.clear();
        }
        this.myProcessedLines.add(line);
    }

    private void handleStackTraceLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "handleStackTraceLine"));
        }
        if (!this.myIsInTrace) {
            this.myIsInTrace = true;
        }
        this.myCurrentStack.add(line);
        this.myProcessedLines.add(this.myStackTracePrefix + line);
    }

    private void handleCausedByLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "handleCausedByLine"));
        }
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        List<String> temp = this.myPreviousStack;
        this.myPreviousStack = this.myCurrentStack;
        this.myCurrentStack = temp;
        this.myCurrentStack.clear();
        this.myProcessedLines.add(this.myCauseLinePrefix + line);
    }

    private void handleElidedLine(@NotNull String line, int elidedCount) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/StackTraceExpander", "handleElidedLine"));
        }
        assert (this.myIsInTrace) : String.format("Unexpected line while parsing stack trace: %s", line);
        assert (elidedCount > 0);
        int startIndex = this.myPreviousStack.size() - elidedCount;
        if (startIndex >= 0) {
            for (int i = 0; i < elidedCount; ++i) {
                String frame = this.myPreviousStack.get(startIndex + i);
                this.myProcessedLines.add(this.myStackTracePrefix + frame + EXPANDED_STACK_TRACE_MARKER);
                this.myCurrentStack.add(frame);
            }
        } else {
            this.myProcessedLines.add(this.myStackTracePrefix + line);
        }
    }
}

