/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.npw.ChooseTemplateStep;
import com.android.tools.idea.npw.ImportSourceLocationStep;
import com.android.tools.idea.npw.NewModuleWizardState;
import com.android.tools.idea.npw.WizardPath;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.collect.Lists;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSourceModulePath
implements WizardPath {
    @NotNull
    private final NewModuleWizardState myWizardState;
    @NotNull
    private final WizardContext myContext;
    private Collection<ModuleWizardStep> mySteps;

    public ImportSourceModulePath(@NotNull NewModuleWizardState wizardState, @NotNull WizardContext context, @Nullable Icon sidePanelIcon, @Nullable TemplateWizardStep.UpdateListener listener) {
        if (wizardState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardState", "com/android/tools/idea/npw/ImportSourceModulePath", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/npw/ImportSourceModulePath", "<init>"));
        }
        this.myWizardState = wizardState;
        this.myContext = context;
        LinkedList steps = Lists.newLinkedList();
        ImportSourceLocationStep locationStep = new ImportSourceLocationStep(context, wizardState, sidePanelIcon, listener);
        steps.add(locationStep);
        for (ModuleImporter importer : ModuleImporter.getAllImporters(this.myContext)) {
            steps.addAll(importer.createWizardSteps());
        }
        this.mySteps = steps;
    }

    @NotNull
    protected static ChooseTemplateStep.MetadataListItem createImportTemplateWithCustomName(final @NotNull String importTemplateName, final @Nullable String description) {
        if (importTemplateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTemplateName", "com/android/tools/idea/npw/ImportSourceModulePath", "createImportTemplateWithCustomName"));
        }
        File moduleTemplate = new File(TemplateManager.getTemplateRootFolder(), FileUtil.join((String[])new String[]{"gradle-projects", "ImportExistingProject"}));
        TemplateManager manager = TemplateManager.getInstance();
        TemplateMetadata metadata = manager.getTemplateMetadata(moduleTemplate);
        assert (metadata != null);
        ChooseTemplateStep.MetadataListItem metadataListItem = new ChooseTemplateStep.MetadataListItem(moduleTemplate, metadata){

            @Override
            public String toString() {
                return importTemplateName;
            }

            @Override
            @Nullable
            public String getDescription() {
                return description == null ? super.getDescription() : description;
            }
        };
        if (metadataListItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ImportSourceModulePath", "createImportTemplateWithCustomName"));
        }
        return metadataListItem;
    }

    @Override
    public Collection<ModuleWizardStep> getSteps() {
        return this.mySteps;
    }

    @Override
    public void update() {
        for (ModuleWizardStep step : this.mySteps) {
            step.updateStep();
        }
    }

    @Override
    public void createModule() {
        Map<String, VirtualFile> modulesToImport = this.myWizardState.getModulesToImport();
        ModuleImporter.getImporter(this.myContext).importProjects(modulesToImport);
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/android/tools/idea/npw/ImportSourceModulePath", "isStepVisible"));
        }
        if (!this.mySteps.contains(step)) {
            return false;
        }
        if (step instanceof ImportSourceLocationStep || ModuleImporter.getImporter(this.myContext).isStepVisible(step)) {
            return step.isStepVisible();
        }
        return false;
    }

    @Override
    public Collection<String> getExcludedTemplates() {
        return Collections.singleton("Import Existing Project");
    }

    @Override
    public Collection<ChooseTemplateStep.MetadataListItem> getBuiltInTemplates() {
        return Collections.singleton(ImportSourceModulePath.createImportTemplateWithCustomName("Import Existing Project", null));
    }

    @Override
    public boolean supportsGlobalWizard() {
        return false;
    }
}

