/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.intellij.openapi.module.Module;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeHelper {
    private static final String DEFAULT_THEME_NAME = "AppTheme";
    private static final String ALTERNATE_THEME_NAME = "Theme.App";
    private static final String APP_COMPAT = "Theme.AppCompat.";
    private Module myModule;
    private LocalResourceRepository myRepository;

    public ThemeHelper(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/npw/ThemeHelper", "<init>"));
        }
        this.myModule = module;
        this.myRepository = ModuleResourceRepository.getModuleResources(module, true);
    }

    @Nullable
    public String getAppThemeName() {
        String manifestTheme = MergedManifest.get(this.myModule).getManifestTheme();
        if (manifestTheme != null) {
            if (manifestTheme.startsWith("@style/")) {
                manifestTheme = manifestTheme.substring("@style/".length());
            }
            return manifestTheme;
        }
        if (this.getLocalStyleResource(DEFAULT_THEME_NAME) != null) {
            return DEFAULT_THEME_NAME;
        }
        if (this.getLocalStyleResource(ALTERNATE_THEME_NAME) != null) {
            return ALTERNATE_THEME_NAME;
        }
        return null;
    }

    public boolean isAppCompatTheme(@NotNull String themeName) {
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "isAppCompatTheme"));
        }
        StyleResourceValue theme = this.getLocalStyleResource(themeName);
        return this.isAppCompatTheme(themeName, theme);
    }

    public static boolean themeExists(@NotNull Configuration configuration, @NotNull String themeName) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/npw/ThemeHelper", "themeExists"));
        }
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "themeExists"));
        }
        return ThemeHelper.getStyleResource(configuration, themeName) != null;
    }

    public boolean isLocalTheme(@NotNull String themeName) {
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "isLocalTheme"));
        }
        return this.getLocalStyleResource(themeName) != null;
    }

    public static Boolean hasActionBar(@NotNull Configuration configuration, @NotNull String themeName) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/npw/ThemeHelper", "hasActionBar"));
        }
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "hasActionBar"));
        }
        StyleResourceValue theme = ThemeHelper.getStyleResource(configuration, themeName);
        if (theme == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ItemResourceValue value = resolver.findItemInStyle(theme, "windowActionBar", theme.isFramework());
        if (value == null || value.getValue() == null) {
            return true;
        }
        return "true".equals(value.getValue());
    }

    @Nullable
    private static StyleResourceValue getStyleResource(@NotNull Configuration configuration, @NotNull String themeName) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/npw/ThemeHelper", "getStyleResource"));
        }
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "getStyleResource"));
        }
        configuration.setTheme(themeName);
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        boolean isFramework = themeName.startsWith("android:");
        if (isFramework) {
            themeName = themeName.substring("android:".length());
        }
        return resolver.getStyle(themeName, isFramework);
    }

    @Nullable
    private StyleResourceValue getLocalStyleResource(@Nullable String theme) {
        if (theme == null) {
            return null;
        }
        List items = this.myRepository.getResourceItem(ResourceType.STYLE, theme);
        if (items == null || items.isEmpty()) {
            return null;
        }
        return (StyleResourceValue)((ResourceItem)items.get(0)).getResourceValue(false);
    }

    private boolean isAppCompatTheme(@NotNull String themeName, @Nullable StyleResourceValue localTheme) {
        if (themeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeName", "com/android/tools/idea/npw/ThemeHelper", "isAppCompatTheme"));
        }
        while (localTheme != null) {
            String parentThemeName = localTheme.getParentStyle();
            if (parentThemeName == null) {
                if (themeName.lastIndexOf(46) > 0) {
                    parentThemeName = themeName.substring(0, themeName.lastIndexOf(46));
                } else {
                    return false;
                }
            }
            themeName = parentThemeName;
            localTheme = this.getLocalStyleResource(themeName);
        }
        return themeName.startsWith(APP_COMPAT);
    }
}

