/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayeredImageConverter {
    private DecimalFormat myFormat;
    private final DecimalFormat myMiterFormat = new DecimalFormat("#.####");
    private final DecimalFormat myOpacityFormat = new DecimalFormat("#.##");

    LayeredImageConverter() {
    }

    @NotNull
    String toVectorDrawableXml(@NotNull File path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toVectorDrawableXml"));
        }
        FileInputStream in = new FileInputStream(path);
        Image image = PixelProbe.probe((InputStream)in, (Decoder.Options)new Decoder.Options().decodeLayerImageData(false).decodeLayerTextData(false).decodeLayerAdjustmentData(false).decodeGuides(false));
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
        this.myFormat = LayeredImageConverter.createDecimalFormat((float)bounds.getWidth(), (float)bounds.getHeight());
        Element vector = new Element("vector");
        this.extractPathLayers(vector, image.getLayers());
        vector.attribute("width", String.valueOf((int)bounds.getWidth()) + "dp").attribute("height", String.valueOf((int)bounds.getHeight()) + "dp").attribute("viewportWidth", String.valueOf((int)bounds.getWidth())).attribute("viewportHeight", String.valueOf((int)bounds.getHeight()));
        String xml = LayeredImageConverter.toVectorDrawable(vector);
        in.close();
        String string = xml;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toVectorDrawableXml"));
        }
        return string;
    }

    private void extractPathLayers(@NotNull Element root, @NotNull List<Layer> layers) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractPathLayers"));
        }
        if (layers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layers", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractPathLayers"));
        }
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = layers.get(i);
            if (!layer.isVisible()) continue;
            Layer.Type type = layer.getType();
            if (type == Layer.Type.SHAPE) {
                Shape path;
                if (layer.getShapeInfo().getStyle() == ShapeInfo.Style.NONE || (path = LayeredImageConverter.getTransformedPath(layer)).getBounds2D().isEmpty()) continue;
                Area clipPath = null;
                float opacityModifier = 1.0f;
                boolean fullyClipped = false;
                if (!layer.isClipBase()) {
                    for (int j = i + 1; j < layers.size(); ++j) {
                        Layer clipBase = layers.get(j);
                        if (!clipBase.isClipBase()) continue;
                        if (!clipBase.isVisible()) {
                            fullyClipped = true;
                            break;
                        }
                        if (clipBase.getType() != Layer.Type.SHAPE) break;
                        opacityModifier = clipBase.getOpacity();
                        Area source = new Area(path);
                        clipPath = new Area(LayeredImageConverter.getTransformedPath(clipBase));
                        source.intersect(clipPath);
                        path = source;
                        break;
                    }
                }
                if (fullyClipped) continue;
                Element element = new Element("path");
                boolean hasFillOrStroke = this.extractFill(layer, element, opacityModifier);
                if (!(hasFillOrStroke |= this.extractStroke(layer, path, clipPath, root, element, opacityModifier))) continue;
                element.attribute("name", StringUtil.escapeXml((String)layer.getName()));
                element.attribute("pathData", LayeredImageConverter.toPathData(path, this.myFormat));
                root.childAtFront(element);
                continue;
            }
            if (type != Layer.Type.GROUP) continue;
            this.extractPathLayers(root, layer.getChildren());
        }
    }

    @NotNull
    private static Shape getTransformedPath(Layer layer) {
        Area area;
        List paths = layer.getShapeInfo().getPaths();
        if (paths.isEmpty()) {
            Path2D.Float float_ = new Path2D.Float();
            if (float_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getTransformedPath"));
            }
            return float_;
        }
        Rectangle2D layerBounds = layer.getBounds();
        AffineTransform transform = AffineTransform.getTranslateInstance(layerBounds.getX(), layerBounds.getY());
        ShapeInfo.Path shapePath = (ShapeInfo.Path)paths.get(0);
        if (shapePath.getOp() == ShapeInfo.PathOp.SUBTRACT) {
            area = new Area(new Rectangle2D.Double(0.0, 0.0, layerBounds.getWidth(), layerBounds.getHeight()));
            area.subtract(new Area(shapePath.getPath()));
        } else {
            Path2D path = shapePath.getPath();
            if (paths.size() == 1) {
                path.transform(transform);
                Path2D path2D = path;
                if (path2D == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getTransformedPath"));
                }
                return path2D;
            }
            area = new Area(path);
        }
        block6: for (int i = 1; i < paths.size(); ++i) {
            shapePath = (ShapeInfo.Path)paths.get(i);
            switch (shapePath.getOp()) {
                case ADD: {
                    area.add(new Area(shapePath.getPath()));
                    continue block6;
                }
                case SUBTRACT: {
                    area.subtract(new Area(shapePath.getPath()));
                    continue block6;
                }
                case INTERSECT: {
                    area.intersect(new Area(shapePath.getPath()));
                    continue block6;
                }
                case EXCLUSIVE_OR: {
                    area.exclusiveOr(new Area(shapePath.getPath()));
                }
            }
        }
        area.transform(transform);
        Area area2 = area;
        if (area2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getTransformedPath"));
        }
        return area2;
    }

    private boolean extractStroke(@NotNull Layer layer, @NotNull Shape path, @Nullable Area clipPath, @NotNull Element root, @NotNull Element element, float opacityModifier) {
        if (layer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStroke"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStroke"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStroke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStroke"));
        }
        ShapeInfo shapeInfo = layer.getShapeInfo();
        if (shapeInfo.getStyle() != ShapeInfo.Style.FILL) {
            BasicStroke stroke;
            boolean isBasicStroke = shapeInfo.getStroke() instanceof BasicStroke;
            if (isBasicStroke && ((stroke = (BasicStroke)shapeInfo.getStroke()).getDashArray() != null || clipPath != null || shapeInfo.getStrokeAlignment() != ShapeInfo.Alignment.CENTER)) {
                this.extractStrokeAsPath(layer, path, clipPath, root, opacityModifier);
                return false;
            }
            Paint strokePaint = shapeInfo.getStrokePaint();
            Color color = Color.BLACK;
            if (strokePaint instanceof Color) {
                color = (Color)strokePaint;
            }
            float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
            element.attribute("strokeColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (strokeAlpha < 1.0f) {
                element.attribute("strokeAlpha", this.myOpacityFormat.format(strokeAlpha));
            }
            if (isBasicStroke) {
                BasicStroke stroke2 = (BasicStroke)shapeInfo.getStroke();
                element.attribute("strokeWidth", this.myFormat.format(stroke2.getLineWidth()));
                if (stroke2.getLineJoin() != 0) {
                    element.attribute("strokeLineJoin", LayeredImageConverter.getJoinValue(stroke2.getLineJoin()));
                } else {
                    element.attribute("strokeMiterLimit", this.myMiterFormat.format(stroke2.getMiterLimit()));
                }
                if (stroke2.getEndCap() != 0) {
                    element.attribute("strokeLineCap", LayeredImageConverter.getCapValue(stroke2.getEndCap()));
                }
            } else {
                element.attribute("strokeWidth", String.valueOf(0.0f));
            }
            return true;
        }
        return false;
    }

    private void extractStrokeAsPath(@NotNull Layer layer, @NotNull Shape path, @Nullable Area clipPath, @NotNull Element root, float opacityModifier) {
        if (layer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStrokeAsPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStrokeAsPath"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractStrokeAsPath"));
        }
        ShapeInfo shapeInfo = layer.getShapeInfo();
        BasicStroke stroke = (BasicStroke)shapeInfo.getStroke();
        Shape strokedPath = null;
        switch (shapeInfo.getStrokeAlignment()) {
            case INSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).intersect(new Area(path));
                break;
            }
            case CENTER: {
                strokedPath = stroke.createStrokedShape(path);
                if (clipPath == null) break;
                strokedPath = new Area(strokedPath);
                break;
            }
            case OUTSIDE: {
                strokedPath = LayeredImageConverter.copyStroke(stroke, 2.0f).createStrokedShape(path);
                strokedPath = new Area(strokedPath);
                ((Area)strokedPath).subtract(new Area(path));
            }
        }
        if (clipPath != null) {
            ((Area)strokedPath).intersect(new Area(clipPath));
        }
        Paint strokePaint = shapeInfo.getStrokePaint();
        Color color = Color.BLACK;
        if (strokePaint instanceof Color) {
            color = (Color)strokePaint;
        }
        float strokeAlpha = layer.getOpacity() * shapeInfo.getStrokeOpacity() * opacityModifier;
        Element element = new Element("path").attribute("name", StringUtil.escapeXml((String)layer.getName())).attribute("pathData", LayeredImageConverter.toPathData(strokedPath, this.myFormat)).attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
        if (strokeAlpha < 1.0f) {
            element.attribute("fillAlpha", this.myOpacityFormat.format(strokeAlpha));
        }
        root.childAtFront(element);
    }

    private static String optimizedHex(Color color) {
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            char r = Integer.toHexString(color.getRed()).charAt(0);
            return new String(new char[]{r, r, r});
        }
        return ColorUtil.toHex((Color)color);
    }

    @NotNull
    private static BasicStroke copyStroke(@NotNull BasicStroke stroke, float widthScale) {
        if (stroke == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stroke", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "copyStroke"));
        }
        BasicStroke basicStroke = new BasicStroke(stroke.getLineWidth() * widthScale, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
        if (basicStroke == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "copyStroke"));
        }
        return basicStroke;
    }

    private boolean extractFill(@NotNull Layer layer, @NotNull Element element, float opacityModifier) {
        if (layer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layer", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractFill"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "extractFill"));
        }
        ShapeInfo shapeInfo = layer.getShapeInfo();
        if (shapeInfo.getStyle() != ShapeInfo.Style.STROKE) {
            Paint fillPaint = shapeInfo.getFillPaint();
            Color color = Color.BLACK;
            if (fillPaint instanceof Color) {
                color = (Color)fillPaint;
            }
            float fillAlpha = layer.getOpacity() * shapeInfo.getFillOpacity() * opacityModifier;
            element.attribute("fillColor", "#" + LayeredImageConverter.optimizedHex(color));
            if (fillAlpha < 1.0f) {
                element.attribute("fillAlpha", this.myOpacityFormat.format(fillAlpha));
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static String getCapValue(int endCap) {
        switch (endCap) {
            case 0: {
                if ("butt" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getCapValue"));
                }
                return "butt";
            }
            case 1: {
                if ("round" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getCapValue"));
                }
                return "round";
            }
            case 2: {
                if ("square" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getCapValue"));
                }
                return "square";
            }
        }
        if ("inherit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getCapValue"));
        }
        return "inherit";
    }

    @NotNull
    private static String getJoinValue(int lineJoin) {
        switch (lineJoin) {
            case 2: {
                if ("bevel" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getJoinValue"));
                }
                return "bevel";
            }
            case 1: {
                if ("round" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getJoinValue"));
                }
                return "round";
            }
            case 0: {
                if ("miter" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getJoinValue"));
                }
                return "miter";
            }
        }
        if ("inherit" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "getJoinValue"));
        }
        return "inherit";
    }

    @NotNull
    private static String toPathData(@NotNull Shape path, @NotNull DecimalFormat format) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toPathData"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toPathData"));
        }
        StringBuilder buffer = new StringBuilder(1024);
        float[] coords = new float[6];
        PathIterator iterator = path.getPathIterator(null);
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstX = 0.0f;
        float firstY = 0.0f;
        boolean implicitLineTo = false;
        while (!iterator.isDone()) {
            int segment = iterator.currentSegment(coords);
            switch (segment) {
                case 0: {
                    buffer.append('m');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    firstX = lastX = coords[0];
                    firstY = lastY = coords[1];
                    implicitLineTo = true;
                    break;
                }
                case 1: {
                    if (coords[0] == lastX) {
                        if (coords[1] != lastY) {
                            buffer.append('v');
                            buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                            implicitLineTo = false;
                        }
                    } else if (coords[1] == lastY) {
                        if (coords[0] != lastX) {
                            buffer.append('h');
                            buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                            implicitLineTo = false;
                        }
                    } else if (coords[0] != lastX && coords[1] != lastY) {
                        buffer.append(implicitLineTo ? (char)' ' : 'l');
                        buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                        buffer.append(' ');
                        buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    }
                    lastX = coords[0];
                    lastY = coords[1];
                    break;
                }
                case 3: {
                    buffer.append('c');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[4] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[5] - lastY, format));
                    implicitLineTo = false;
                    lastX = coords[4];
                    lastY = coords[5];
                    break;
                }
                case 2: {
                    buffer.append('q');
                    buffer.append(LayeredImageConverter.cleanup(coords[0] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[1] - lastY, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[2] - lastX, format));
                    buffer.append(' ');
                    buffer.append(LayeredImageConverter.cleanup(coords[3] - lastY, format));
                    implicitLineTo = false;
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 4: {
                    buffer.append('z');
                    lastX = firstX;
                    lastY = firstY;
                }
            }
            iterator.next();
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toPathData"));
        }
        return string;
    }

    @NotNull
    private static DecimalFormat createDecimalFormat(float viewportWidth, float viewportHeight) {
        float minSize = Math.min(viewportHeight, viewportWidth);
        float exponent = Math.round(Math.log10(minSize));
        int decimalPlace = (int)Math.floor(exponent - 4.0f);
        String decimalFormatString = "#";
        if (decimalPlace < 0) {
            if (decimalPlace < -6) {
                decimalPlace = -6;
            }
            decimalFormatString = decimalFormatString + ".";
            for (int i = 0; i < -decimalPlace; ++i) {
                decimalFormatString = decimalFormatString + "#";
            }
        }
        DecimalFormatSymbols fractionSeparator = new DecimalFormatSymbols();
        fractionSeparator.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(decimalFormatString, fractionSeparator);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        DecimalFormat decimalFormat2 = decimalFormat;
        if (decimalFormat2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "createDecimalFormat"));
        }
        return decimalFormat2;
    }

    @NotNull
    private static String cleanup(float value, @NotNull DecimalFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "cleanup"));
        }
        if (value == (float)((long)value)) {
            String string = String.valueOf((long)value);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "cleanup"));
            }
            return string;
        }
        String string = format.format(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "cleanup"));
        }
        return string;
    }

    @NotNull
    private static String toVectorDrawable(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toVectorDrawable"));
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        LayeredImageConverter.outputElement(element, out, true, 0);
        out.flush();
        String string = stringWriter.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "toVectorDrawable"));
        }
        return string;
    }

    private static void outputElement(@NotNull Element element, @NotNull PrintWriter out, boolean isRoot, int indent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputElement"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputElement"));
        }
        LayeredImageConverter.indent(out, indent);
        out.write("<");
        out.write(element.name);
        if (isRoot) {
            out.write(" xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        }
        out.write("\n");
        boolean hasChildren = element.children.size() > 0;
        LayeredImageConverter.outputAttributes(element, out, ++indent);
        if (hasChildren) {
            out.write(">\n");
            LayeredImageConverter.outputChildren(element, out, indent);
        } else {
            out.write(" />");
        }
        --indent;
        if (hasChildren) {
            LayeredImageConverter.indent(out, indent);
            out.write("</");
            out.write(element.name);
            out.write(">");
        }
        out.write("\n");
    }

    private static void outputChildren(@NotNull Element element, @NotNull PrintWriter out, int indent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputChildren"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputChildren"));
        }
        for (Element child : element.children) {
            LayeredImageConverter.outputElement(child, out, false, indent);
        }
    }

    private static void outputAttributes(@NotNull Element element, @NotNull PrintWriter out, int indent) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputAttributes"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "outputAttributes"));
        }
        List<Attribute> attributes = element.attributes;
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = attributes.get(i);
            LayeredImageConverter.indent(out, indent);
            out.write("android:");
            out.write(attribute.name);
            out.write("=\"");
            out.write(attribute.value);
            out.write("\"");
            if (i == size - 1) continue;
            out.write("\n");
        }
    }

    private static void indent(@NotNull PrintWriter out, int indent) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter", "indent"));
        }
        for (int i = 0; i < indent; ++i) {
            out.write("    ");
        }
    }

    private static class Element {
        final String name;
        final List<Element> children;
        final List<Attribute> attributes;

        Element(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Element", "<init>"));
            }
            this.children = new ArrayList<Element>();
            this.attributes = new ArrayList<Attribute>();
            this.name = name;
        }

        Element attribute(@NotNull String name, @NotNull String value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Element", "attribute"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Element", "attribute"));
            }
            this.attributes.add(new Attribute(name, value));
            return this;
        }

        Element childAtFront(@NotNull Element child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Element", "childAtFront"));
            }
            this.children.add(0, child);
            return this;
        }
    }

    private static class Attribute {
        final String name;
        final String value;

        Attribute(@NotNull String name, @NotNull String value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Attribute", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/assetstudio/assets/LayeredImageConverter$Attribute", "<init>"));
            }
            this.name = name;
            this.value = value;
        }
    }
}

