/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.tools.idea.npw.CreateModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.NewModuleWizardDynamic;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.deprecated.NewFormFactorModulePath;
import com.android.tools.idea.ui.LabelWithEditLink;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidModuleStepDynamic
extends DynamicWizardStepWithHeaderAndDescription {
    private static final Logger LOG = Logger.getInstance(ConfigureAndroidModuleStepDynamic.class);
    private static final String TITLE = "Configure your new module";
    private CreateModuleTemplate myModuleType;
    private FormFactorApiComboBox mySdkControls;
    private JTextField myModuleName;
    private JPanel myPanel;
    private JTextField myAppName;
    private LabelWithEditLink myPackageName;
    @Nullable
    private final FormFactor myFormFactor;
    private final ScopedDataBinder.ValueDeriver<String> ourModuleNameDeriver;

    public ConfigureAndroidModuleStepDynamic(@Nullable Disposable parentDisposable, @Nullable FormFactor formFactor) {
        super(TITLE, null, parentDisposable);
        this.$$$setupUI$$$();
        this.ourModuleNameDeriver = new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 1.makeSetOf(WizardConstants.APPLICATION_NAME_KEY);
            }

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/deprecated/ConfigureAndroidModuleStepDynamic$1", "deriveValue"));
                }
                String appName = state.get(WizardConstants.APPLICATION_NAME_KEY);
                if (appName == null) {
                    appName = ConfigureAndroidModuleStepDynamic.this.myModuleType.getFormFactor().toString();
                }
                return WizardUtils.computeModuleName(appName, ConfigureAndroidModuleStepDynamic.this.getProject());
            }
        };
        this.setBodyComponent(this.myPanel);
        this.myFormFactor = formFactor;
    }

    @Override
    public void init() {
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        super.init();
        this.myState.put(WizardConstants.PROJECT_LOCATION_KEY, projectLocation);
        CreateModuleTemplate template = this.getFormfactorModuleTemplate();
        assert (template != null);
        this.register(FormFactorUtils.getModuleNameKey(template.getFormFactor()), this.myModuleName);
        this.myModuleName.setName("ModuleName");
        this.mySdkControls.init(template.getFormFactor(), template.getMetadata().getMinSdk(), null, null, null);
        this.mySdkControls.registerWith(this);
        this.register(WizardConstants.APPLICATION_NAME_KEY, this.myAppName);
        this.register(WizardConstants.PACKAGE_NAME_KEY, this.myPackageName);
        this.registerValueDeriver(WizardConstants.PACKAGE_NAME_KEY, ConfigureAndroidProjectStep.PACKAGE_NAME_DERIVER);
        if (StringUtil.isEmptyOrSpaces((String)this.myState.get(WizardConstants.APPLICATION_NAME_KEY))) {
            String name = this.myState.getNotNull(WizardConstants.IS_LIBRARY_KEY, false) != false ? "My Library" : "My Application";
            this.myState.put(WizardConstants.APPLICATION_NAME_KEY, name);
            String savedCompanyDomain = PropertiesComponent.getInstance().getValue("SAVED_COMPANY_DOMAIN");
            this.myState.put(WizardConstants.COMPANY_DOMAIN_KEY, savedCompanyDomain);
        }
        super.init();
    }

    private void createUIComponents() {
        this.mySdkControls = new FormFactorApiComboBox();
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        CreateModuleTemplate template = this.getFormfactorModuleTemplate();
        if (template != null && template.getFormFactor() != null && template.getMetadata() != null) {
            this.myModuleType = template;
            this.registerValueDeriver(FormFactorUtils.getModuleNameKey(template.getFormFactor()), this.ourModuleNameDeriver);
            this.getComponent();
            this.myHeader.setTitle(this.myModuleType.getName());
        } else {
            LOG.error("init() Called on ConfigureAndroidModuleStepDynamic with an incorrect selected ModuleType");
        }
        if (this.mySdkControls != null) {
            this.mySdkControls.loadSavedApi();
        }
        this.invokeUpdate(null);
    }

    @Override
    public boolean commitStep() {
        boolean commit = super.commitStep();
        if (commit && this.myPath instanceof NewFormFactorModulePath) {
            ((NewFormFactorModulePath)this.myPath).updatePackageDerivedValues();
        }
        return commit;
    }

    @Nullable
    private CreateModuleTemplate getFormfactorModuleTemplate() {
        CreateModuleTemplate type;
        ModuleTemplate moduleTemplate = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        if (moduleTemplate instanceof CreateModuleTemplate && (type = (CreateModuleTemplate)moduleTemplate).getFormFactor() != null && type.getMetadata() != null) {
            return type;
        }
        return null;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (this.mySdkControls != null) {
            this.mySdkControls.deriveValues(this.myState, modified);
        }
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        return this.validateAppName() && this.validatePackageName() && this.validateApiLevel();
    }

    private boolean validateApiLevel() {
        if (this.mySdkControls == null || this.mySdkControls.getItemCount() < 1) {
            this.setErrorHtml("No supported platforms found. Please install the proper platform or add-on through the SDK manager.");
            return false;
        }
        return true;
    }

    protected boolean validateAppName() {
        String appName = this.myState.get(WizardConstants.APPLICATION_NAME_KEY);
        if (appName == null || appName.isEmpty()) {
            this.setErrorHtml("Please enter an application name (shown in launcher), or a descriptive name for your library");
            return false;
        }
        if (Character.isLowerCase(appName.charAt(0))) {
            this.setErrorHtml("The application name for most apps begins with an uppercase letter");
        }
        return true;
    }

    protected boolean validatePackageName() {
        String packageName = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        if (packageName == null) {
            this.setErrorHtml("Please enter a package name (This package uniquely identifies your application or library)");
            return false;
        }
        String message = AndroidUtils.validateAndroidPackageName(packageName);
        if (message != null) {
            this.setErrorHtml("Invalid package name: " + message);
            return false;
        }
        return true;
    }

    @Override
    public boolean isStepVisible() {
        return this.getFormfactorModuleTemplate() != null;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("New Android Module Configuration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/deprecated/ConfigureAndroidModuleStepDynamic", "getStepName"));
        }
        return "New Android Module Configuration";
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = this.getFormfactorModuleTemplate() == null ? NewModuleWizardDynamic.buildHeader() : (this.myFormFactor == null ? DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createTitleOnlyHeader(this.getFormfactorModuleTemplate().getName()) : DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createTitleAndIconHeader(this.getFormfactorModuleTemplate().getName(), this.myFormFactor.getIcon()));
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/deprecated/ConfigureAndroidModuleStepDynamic", "getStepHeader"));
        }
        return wizardStepHeaderSettings;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAppName;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        LabelWithEditLink labelWithEditLink;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Application/Library name:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Package name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPackageName = labelWithEditLink = new LabelWithEditLink();
        jPanel.add((Component)labelWithEditLink, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        ((Component)jLabel3).setVisible(true);
        jLabel3.setText("Module name:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField = new JTextField();
        ((Component)jTextField).setVisible(true);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Minimum SDK");
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        FormFactorApiComboBox formFactorApiComboBox = this.mySdkControls;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        formFactorApiComboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)formFactorApiComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

