/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.wizard.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class IdeaWizardAdapter
implements ModelWizard.ResultListener,
WizardDelegate,
Disposable {
    @NotNull
    private final ListenerManager myListeners;
    @NotNull
    private final ModelWizardDialog.CustomLayout myCustomLayout;
    @NotNull
    private final AbstractWizard myHostWizard;
    @NotNull
    private final ModelWizard myGuestWizard;

    IdeaWizardAdapter(@NotNull AbstractWizard host, @NotNull ModelWizard guest) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/npw/ideahost/IdeaWizardAdapter", "<init>"));
        }
        if (guest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guest", "com/android/tools/idea/npw/ideahost/IdeaWizardAdapter", "<init>"));
        }
        this.myListeners = new ListenerManager();
        this.myCustomLayout = new StudioWizardLayout();
        this.myHostWizard = host;
        this.myGuestWizard = guest;
        this.myGuestWizard.addResultListener(this);
        this.myListeners.listenAll(this.myGuestWizard.canGoBack(), this.myGuestWizard.canGoForward(), this.myGuestWizard.onLastStep()).withAndFire(this::updateButtons);
        Disposer.register((Disposable)this.myHostWizard.getDisposable(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myGuestWizard);
        Disposer.register((Disposable)this, (Disposable)this.myCustomLayout);
    }

    private void updateButtons() {
        this.myHostWizard.updateButtons(((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue(), ((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue(), (Boolean)this.myGuestWizard.canGoBack().get() == false);
    }

    @Override
    public void onWizardFinished(boolean success) {
        this.myHostWizard.close(1, success);
    }

    public void doNextAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public void doPreviousAction() {
        assert (((Boolean)this.myGuestWizard.canGoBack().get()).booleanValue());
        this.myGuestWizard.goBack();
        this.updateButtons();
    }

    public void doFinishAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        assert (((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public boolean canProceed() {
        return (Boolean)this.myGuestWizard.canGoForward().get();
    }

    public void dispose() {
        this.myListeners.releaseAll();
        this.myGuestWizard.removeResultListener(this);
    }

    @NotNull
    public ModuleWizardStep getProxyStep() {
        ModuleWizardStep moduleWizardStep = new ModuleWizardStep(){

            public JComponent getComponent() {
                return IdeaWizardAdapter.this.myCustomLayout.decorate(IdeaWizardAdapter.this.myGuestWizard.title(), IdeaWizardAdapter.this.myGuestWizard.getContentPanel());
            }

            public void updateDataModel() {
            }
        };
        if (moduleWizardStep == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ideahost/IdeaWizardAdapter", "getProxyStep"));
        }
        return moduleWizardStep;
    }
}

