/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    @NotNull
    private final TemplateHandle myTemplateHandle;
    @NotNull
    private final String myCommandName;
    private final OptionalProperty<SourceProvider> mySourceSet;
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @Nullable
    private AndroidProjectPaths myPaths;
    @Nullable
    private AndroidIconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull AndroidFacet androidFacet, @NotNull TemplateHandle templateHandle, @NotNull String commandName) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (templateHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateHandle", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/android/tools/idea/npw/template/RenderTemplateModel", "<init>"));
        }
        this.mySourceSet = new OptionalValueProperty<SourceProvider>();
        this.myTemplateValues = Maps.newHashMap();
        this.myAndroidFacet = androidFacet;
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.mySourceSet.addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/npw/template/RenderTemplateModel$1", "onInvalidated"));
                }
                RenderTemplateModel.this.myPaths = null;
                if (((Optional)RenderTemplateModel.this.mySourceSet.get()).isPresent()) {
                    RenderTemplateModel.this.myPaths = new AndroidProjectPaths(RenderTemplateModel.this.myAndroidFacet, (SourceProvider)RenderTemplateModel.this.mySourceSet.getValue());
                }
            }
        });
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    public AndroidFacet getFacet() {
        return this.myAndroidFacet;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myAndroidFacet.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public OptionalProperty<SourceProvider> getSourceSet() {
        OptionalProperty<SourceProvider> optionalProperty = this.mySourceSet;
        if (optionalProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getSourceSet"));
        }
        return optionalProperty;
    }

    @NotNull
    public TemplateHandle getTemplateHandle() {
        TemplateHandle templateHandle = this.myTemplateHandle;
        if (templateHandle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/RenderTemplateModel", "getTemplateHandle"));
        }
        return templateHandle;
    }

    public void setIconGenerator(@NotNull AndroidIconGenerator iconGenerator) {
        if (iconGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconGenerator", "com/android/tools/idea/npw/template/RenderTemplateModel", "setIconGenerator"));
        }
        this.myIconGenerator = iconGenerator;
    }

    @Nullable
    public AndroidProjectPaths getPaths() {
        return this.myPaths;
    }

    @Override
    protected void handleFinished() {
        ArrayList filesToReformat;
        if (!((Optional)this.mySourceSet.get()).isPresent()) {
            RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        assert (this.myPaths != null);
        final Project project = this.getModule().getProject();
        boolean canRender = this.renderTemplate(true, this.myPaths, null, null);
        if (!canRender) {
            return;
        }
        final ArrayList filesToOpen = Lists.newArrayListWithExpectedSize((int)3);
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, this.myCommandName, new PsiFile[0], (List)(filesToReformat = Lists.newArrayList())){
            final /* synthetic */ List val$filesToReformat;
            {
                this.val$filesToReformat = list2;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/template/RenderTemplateModel$2", "run"));
                }
                boolean success = RenderTemplateModel.this.renderTemplate(false, RenderTemplateModel.this.myPaths, filesToOpen, this.val$filesToReformat);
                if (success && RenderTemplateModel.this.myIconGenerator != null) {
                    RenderTemplateModel.this.myIconGenerator.generateImageIconsIntoPath(RenderTemplateModel.this.myPaths);
                }
                result.setResult((Object)success);
            }
        }.execute().getResultObject();
        if (success) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    TemplateUtils.openEditors(project, filesToOpen, true);
                }
            });
        }
    }

    private boolean renderTemplate(boolean dryRun, @NotNull AndroidProjectPaths paths, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/template/RenderTemplateModel", "renderTemplate"));
        }
        Module module = this.getModule();
        Project project = module.getProject();
        Template template = this.myTemplateHandle.getTemplate();
        File moduleRoot = paths.getModuleRoot();
        if (moduleRoot == null) {
            return false;
        }
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModule(this.getModule()).withParams(this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
        return template.render(context);
    }
}

