/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.google.common.collect.Iterables;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageComboProvider
extends ParameterComponentProvider<EditorComboBox> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myInitialPackage;
    @NotNull
    private final String myRecentsKey;

    public PackageComboProvider(@NotNull Project project, @NotNull Parameter parameter, @NotNull String initialPackage, @NotNull String recentsKey) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/template/components/PackageComboProvider", "<init>"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/components/PackageComboProvider", "<init>"));
        }
        if (initialPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialPackage", "com/android/tools/idea/npw/template/components/PackageComboProvider", "<init>"));
        }
        if (recentsKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentsKey", "com/android/tools/idea/npw/template/components/PackageComboProvider", "<init>"));
        }
        super(parameter);
        this.myProject = project;
        this.myInitialPackage = initialPackage;
        this.myRecentsKey = recentsKey;
    }

    @Override
    @NotNull
    protected EditorComboBox createComponent(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/template/components/PackageComboProvider", "createComponent"));
        }
        Document doc = JavaReferenceEditorUtil.createDocument((String)this.myInitialPackage, (Project)this.myProject, (boolean)false, (JavaCodeFragment.VisibilityChecker)JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE);
        assert (doc != null);
        EditorComboBox classComboBox = new EditorComboBox(doc, this.myProject, (FileType)StdFileTypes.JAVA);
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(this.myRecentsKey, this.myInitialPackage);
        List recents = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(this.myRecentsKey);
        assert (recents != null);
        classComboBox.setHistory((String[])Iterables.toArray((Iterable)recents, String.class));
        EditorComboBox editorComboBox = classComboBox;
        if (editorComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/components/PackageComboProvider", "createComponent"));
        }
        return editorComboBox;
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull EditorComboBox classComboBox) {
        if (classComboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classComboBox", "com/android/tools/idea/npw/template/components/PackageComboProvider", "createProperty"));
        }
        return new TextProperty(classComboBox);
    }

    @Override
    public void accept(@NotNull EditorComboBox component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/template/components/PackageComboProvider", "accept"));
        }
        RecentsManager recentsManager = RecentsManager.getInstance((Project)this.myProject);
        recentsManager.registerRecentEntry(this.myRecentsKey, component.getText());
    }
}

