/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.ui.UIUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlBuilderHelper {
    @Nullable
    private static String getIconPath(String relative) {
        URL resource = AllIcons.class.getClassLoader().getResource(relative);
        try {
            return resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Nullable
    public static String getCloseIconPath() {
        return HtmlBuilderHelper.getIconPath("/actions/closeNew.png");
    }

    @Nullable
    public static String getTipIconPath() {
        return HtmlBuilderHelper.getIconPath("/actions/createFromUsage.png");
    }

    @Nullable
    public static String getWarningIconPath() {
        return HtmlBuilderHelper.getIconPath("/general/warningDialog.png");
    }

    @Nullable
    public static String getErrorIconPath() {
        return HtmlBuilderHelper.getIconPath("/general/error.png");
    }

    @Nullable
    public static String getRefreshIconPath() {
        return HtmlBuilderHelper.getIconPath("/actions/refresh.png");
    }

    public static String getHeaderFontColor() {
        return UIUtil.isUnderDarcula() ? "#A5C25C" : "#005555";
    }

    public static void fixFontStyles(@NotNull JTextComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/rendering/HtmlBuilderHelper", "fixFontStyles"));
        }
        Document document = component.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)document;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        Style style = styledDocument.addStyle("active", null);
        StyleConstants.setFontFamily(style, scheme.getEditorFontName());
        StyleConstants.setFontSize(style, scheme.getEditorFontSize());
        styledDocument.setCharacterAttributes(0, document.getLength(), style, false);
    }
}

