/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.WebpImageReaderSpi;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;

public class NativeLibHelper {
    private static boolean sJniLibLoaded;
    private static boolean sJniLibLoadAttempted;

    private NativeLibHelper() {
    }

    static boolean loadNativeLibraryIfNeeded() {
        if (!sJniLibLoadAttempted) {
            try {
                NativeLibHelper.loadNativeLibrary();
            }
            catch (UnsatisfiedLinkError e) {
                WebpImageReaderSpi.getLogger().warn((Throwable)e);
            }
        }
        return sJniLibLoaded;
    }

    private static synchronized void loadNativeLibrary() {
        if (sJniLibLoadAttempted) {
            return;
        }
        try {
            String libFileName = NativeLibHelper.getLibName();
            File pluginPath = NativeLibHelper.getLibLocation();
            File libPath = new File(pluginPath, libFileName);
            if (!libPath.exists()) {
                throw new UnsatisfiedLinkError(String.format("'%1$s' not found at '%2$s'", libFileName, libPath.getAbsolutePath()));
            }
            System.load(libPath.getAbsolutePath());
        }
        finally {
            sJniLibLoadAttempted = true;
        }
        sJniLibLoaded = true;
    }

    public static String getLibName() {
        String baseName = SystemInfo.is64Bit ? "webp_jni64" : "webp_jni";
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    public static File getLibLocation() {
        String adtPath = PathManager.getHomePath() + "/../adt/idea/android/lib/libwebp/" + NativeLibHelper.getPlatformName();
        File adtFile = new File(adtPath);
        return adtFile.exists() ? adtFile : new File(PluginPathManager.getPluginHome((String)"android"), "lib");
    }

    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }
}

