/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.DataBindingResourceType;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceFolderRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(ResourceFolderRepository.class);
    private final Module myModule;
    private final AndroidFacet myFacet;
    private final PsiListener myListener;
    private final VirtualFile myResourceDir;
    private final String myLibraryName;
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myItems;
    private final Map<VirtualFile, ResourceFile> myResourceFiles;
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    private long myDataBindingResourceFilesModificationCount;
    private final Object SCAN_LOCK;
    private Set<PsiFile> myPendingScans;
    private InitialScanState myInitialScanState;
    static int ourFullRescans;

    private ResourceFolderRepository(@NotNull AndroidFacet facet, @NotNull VirtualFile resourceDir, @Nullable String libraryName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ResourceFolderRepository", "<init>"));
        }
        if (resourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDir", "com/android/tools/idea/res/ResourceFolderRepository", "<init>"));
        }
        super(resourceDir.getName());
        this.myItems = Maps.newEnumMap(ResourceType.class);
        this.myResourceFiles = Maps.newHashMap();
        this.myDataBindingResourceFiles = Maps.newHashMap();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
        this.SCAN_LOCK = new Object();
        this.myFacet = facet;
        this.myModule = facet.getModule();
        this.myListener = new PsiListener();
        this.myResourceDir = resourceDir;
        this.myLibraryName = libraryName;
        ResourceMerger merger = this.loadPreviousStateIfExists();
        this.myInitialScanState = new InitialScanState(merger, VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir));
        this.scanRemainingFiles();
        Application app = ApplicationManager.getApplication();
        if (!this.hasFreshFileCache() && !app.isUnitTestMode()) {
            this.saveStateToFile();
        }
        if (!app.isUnitTestMode()) {
            this.myInitialScanState = null;
        }
    }

    @NotNull
    AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "getFacet"));
        }
        return androidFacet;
    }

    VirtualFile getResourceDir() {
        return this.myResourceDir;
    }

    @NotNull
    static ResourceFolderRepository create(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @Nullable String libraryName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/res/ResourceFolderRepository", "create"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/res/ResourceFolderRepository", "create"));
        }
        ResourceFolderRepository resourceFolderRepository = new ResourceFolderRepository(facet, dir, libraryName);
        if (resourceFolderRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "create"));
        }
        return resourceFolderRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveStateToFile() {
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null) {
            return;
        }
        try {
            NoOpResourcePreprocessor preprocessor = new NoOpResourcePreprocessor();
            File tempDirectory = FileUtil.createTempDirectory((String)"resource", (String)"tmp", (boolean)false);
            try {
                MergedResourceWriter consumer = MergedResourceWriter.createWriterWithoutPngCruncher((File)blobRoot, null, null, (ResourcePreprocessor)preprocessor, (File)tempDirectory);
                this.myInitialScanState.myResourceMerger.writeBlobToWithTimestamps(blobRoot, (MergeConsumer)consumer);
            }
            finally {
                FileUtil.delete((File)tempDirectory);
            }
        }
        catch (MergingException | IOException e) {
            LOG.error("Failed to saveStateToFile", e);
            FileUtil.delete((File)blobRoot);
        }
    }

    private ResourceMerger loadPreviousStateIfExists() {
        File blobRoot = ResourceFolderRepositoryFileCacheService.get().getResourceDir(this.myModule.getProject(), this.myResourceDir);
        if (blobRoot == null || !blobRoot.exists()) {
            return this.createFreshResourceMerger();
        }
        ResourceMerger merger = new ResourceMerger(0);
        try {
            if (!merger.loadFromBlob(blobRoot, false)) {
                LOG.warn("failed to loadPreviousStateIfExists " + blobRoot);
                return this.createFreshResourceMerger();
            }
        }
        catch (MergingException e) {
            LOG.warn("failed to loadPreviousStateIfExists " + blobRoot, (Throwable)e);
            return this.createFreshResourceMerger();
        }
        HashSet resourceFiles = Sets.newHashSet();
        List resourceSets = merger.getDataSets();
        if (resourceSets.size() != 1) {
            LOG.error("Expecting exactly one resource set, but found " + resourceSets.size());
            return this.createFreshResourceMerger();
        }
        ResourceSet dataSet = (ResourceSet)resourceSets.get(0);
        List sourceFiles = dataSet.getSourceFiles();
        if (sourceFiles.size() != 1) {
            LOG.error("Expecting exactly source files (res/ directories), but found " + sourceFiles.size());
            return this.createFreshResourceMerger();
        }
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)((File)sourceFiles.get(0)), (File)myResourceDirFile)) {
            LOG.warn(String.format("source file %1$s, does not match resource dir %2$s", sourceFiles.get(0), myResourceDirFile));
            return this.createFreshResourceMerger();
        }
        for (Map.Entry entry : dataSet.getDataMap().entries()) {
            ResourceItem item = (ResourceItem)entry.getValue();
            ResourceFile file = (ResourceFile)item.getSource();
            if (file != null) {
                if (!resourceFiles.contains(file)) {
                    VirtualFile vFile = VfsUtil.findFileByIoFile((File)file.getFile(), (boolean)false);
                    if (vFile == null) {
                        item.setIgnoredFromDiskMerge(true);
                        continue;
                    }
                    resourceFiles.add(file);
                    this.myResourceFiles.put(vFile, file);
                }
                ListMultimap<String, ResourceItem> map = this.getMap(item.getType(), true);
                map.put((Object)item.getName(), (Object)item);
                continue;
            }
            item.setIgnoredFromDiskMerge(true);
        }
        return merger;
    }

    private ResourceMerger createFreshResourceMerger() {
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet myData = new ResourceSet(this.myResourceDir.getName(), this.myLibraryName, false);
        File resourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        myData.addSource(resourceDir);
        merger.addDataSet(myData);
        return merger;
    }

    boolean hasFreshFileCache() {
        return this.myInitialScanState.numXmlReparsed * 4 <= this.myInitialScanState.numXml;
    }

    InitialScanState getInitialScanState() {
        return this.myInitialScanState;
    }

    private void scanRemainingFiles() {
        if (!this.myResourceDir.isValid()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> this.getPsiDirsForListener(this.myResourceDir));
        this.scanResFolder(this.myResourceDir);
        ApplicationManager.getApplication().runReadAction(this::scanQueuedPsiResources);
    }

    private void getPsiDirsForListener(VirtualFile resourceDir) {
        PsiManager manager = PsiManager.getInstance((Project)this.myModule.getProject());
        PsiDirectory resourceDirPsi = manager.findDirectory(resourceDir);
        if (resourceDirPsi != null) {
            resourceDirPsi.getSubdirectories();
        }
    }

    private void scanQueuedPsiResources() {
        PsiFile file;
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        for (PsiValueResourceQueueEntry valueResource : this.myInitialScanState.myPsiValueResourceQueue) {
            file = psiManager.findFile(valueResource.file);
            if (file == null) continue;
            this.scanValueFileAsPsi(valueResource.qualifiers, file, valueResource.folderConfiguration);
        }
        for (PsiFileResourceQueueEntry fileResource : this.myInitialScanState.myPsiFileResourceQueue) {
            file = psiManager.findFile(fileResource.file);
            if (file == null) continue;
            List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)fileResource.folderType);
            assert (resourceTypes.size() >= 1) : fileResource.folderType;
            ResourceType type = (ResourceType)resourceTypes.get(0);
            ListMultimap<String, ResourceItem> map = this.getMap(type, true);
            this.scanFileResourceFileAsPsi(fileResource.qualifiers, fileResource.folderType, fileResource.folderConfiguration, type, true, map, file);
        }
    }

    @Nullable
    private PsiFile ensureValid(@NotNull PsiFile psiFile) {
        Project project;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/res/ResourceFolderRepository", "ensureValid"));
        }
        if (psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && virtualFile.exists() && !(project = this.myModule.getProject()).isDisposed()) {
            return PsiManager.getInstance((Project)project).findFile(virtualFile);
        }
        return null;
    }

    private void scanResFolder(@NotNull VirtualFile resDir) {
        if (resDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resDir", "com/android/tools/idea/res/ResourceFolderRepository", "scanResFolder"));
        }
        for (VirtualFile subDir : resDir.getChildren()) {
            FolderConfiguration folderConfiguration;
            String name;
            ResourceFolderType folderType;
            if (!subDir.isValid() || !subDir.isDirectory() || (folderType = ResourceFolderType.getFolderType((String)(name = subDir.getName()))) == null || (folderConfiguration = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
            String qualifiers = ResourceFolderRepository.getQualifiers(name);
            if (folderType == ResourceFolderType.VALUES) {
                this.scanValueResFolder(subDir, qualifiers, folderConfiguration);
                continue;
            }
            this.scanFileResourceFolder(subDir, folderType, qualifiers, folderConfiguration);
        }
    }

    private static String getQualifiers(String dirName) {
        int index = dirName.indexOf(45);
        return index != -1 ? dirName.substring(index + 1) : "";
    }

    private void scanFileResourceFolder(@NotNull VirtualFile directory, ResourceFolderType folderType, String qualifiers, FolderConfiguration folderConfiguration) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/res/ResourceFolderRepository", "scanFileResourceFolder"));
        }
        List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        assert (resourceTypes.size() >= 1) : folderType;
        ResourceType type = (ResourceType)resourceTypes.get(0);
        boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
        ListMultimap<String, ResourceItem> map = this.getMap(type, true);
        for (VirtualFile file : directory.getChildren()) {
            boolean idGeneratingFile;
            if (!file.isValid() || file.isDirectory()) continue;
            FileType fileType = file.getFileType();
            boolean bl = idGeneratingFile = idGeneratingFolder && fileType == StdFileTypes.XML;
            if (!PsiProjectListener.isRelevantFileType(fileType) && folderType != ResourceFolderType.RAW) continue;
            this.scanFileResourceFile(qualifiers, folderType, folderConfiguration, type, idGeneratingFile, map, file);
        }
    }

    private void scanFileResourceFileAsPsi(String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, ListMultimap<String, ResourceItem> map, PsiFile file) {
        String name = ResourceHelper.getResourceName(file);
        PsiResourceItem item = new PsiResourceItem(name, type, null, file);
        if (idGenerating) {
            ArrayList items = Lists.newArrayList();
            items.add(item);
            map.put((Object)name, (Object)item);
            this.addIds(items, file);
            PsiResourceFile resourceFile = new PsiResourceFile(file, items, qualifiers, folderType, folderConfiguration);
            this.scanDataBinding(resourceFile, this.getModificationCount());
            this.myResourceFiles.put(file.getVirtualFile(), resourceFile);
        } else {
            PsiResourceFile resourceFile = new PsiResourceFile(file, item, qualifiers, folderType, folderConfiguration);
            this.myResourceFiles.put(file.getVirtualFile(), resourceFile);
            map.put((Object)name, (Object)item);
        }
    }

    private void scanFileResourceFile(String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration, ResourceType type, boolean idGenerating, ListMultimap<String, ResourceItem> map, VirtualFile file) {
        ResourceFile resourceFile;
        if (idGenerating) {
            if (this.myResourceFiles.containsKey(file)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            try {
                boolean isDensityBasedResource;
                resourceFile = this.myInitialScanState.loadFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                    return;
                }
                ListMultimap<String, ResourceItem> idMap = this.getMap(ResourceType.ID, true);
                boolean bl = isDensityBasedResource = folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
                if (!isDensityBasedResource) {
                    this.myInitialScanState.countCacheMiss();
                }
                for (ResourceItem item : resourceFile.getItems()) {
                    ListMultimap<String, ResourceItem> itemMap;
                    if (item.getType() == ResourceType.ID) {
                        itemMap = idMap;
                    } else {
                        assert (item.getType() == type);
                        itemMap = map;
                    }
                    itemMap.put((Object)item.getName(), (Object)item);
                    if (!isDensityBasedResource) continue;
                    item.setIgnoredFromDiskMerge(true);
                }
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiFileResourceScan(new PsiFileResourceQueueEntry(file, qualifiers, folderType, folderConfiguration));
                return;
            }
        } else {
            String name = ResourceHelper.getResourceName(file);
            ResourceItem item = new ResourceItem(name, type, null, this.myLibraryName);
            map.put((Object)name, (Object)item);
            resourceFile = new ResourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file), item, qualifiers, folderConfiguration);
            item.setIgnoredFromDiskMerge(true);
        }
        this.myResourceFiles.put(file, resourceFile);
    }

    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        List resourceItems = this.getResourceItem(ResourceType.LAYOUT, layoutName);
        if (resourceItems == null) {
            return null;
        }
        for (ResourceItem item : resourceItems) {
            ResourceFile source = (ResourceFile)item.getSource();
            if (!(source instanceof PsiResourceFile) || ((PsiResourceFile)source).getDataBindingInfo() == null) continue;
            return ((PsiResourceFile)source).getDataBindingInfo();
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "getDataBindingResourceFiles"));
            }
            return map;
        }
        HashMap selected = Maps.newHashMap();
        for (ResourceFile file : this.myResourceFiles.values()) {
            DataBindingInfo info;
            if (!(file instanceof PsiResourceFile) || (info = ((PsiResourceFile)file).getDataBindingInfo()) == null) continue;
            selected.put(info.getQualifiedName(), info);
        }
        this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
        this.myDataBindingResourceFilesModificationCount = modificationCount;
        Map<String, DataBindingInfo> map = this.myDataBindingResourceFiles;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "getDataBindingResourceFiles"));
        }
        return map;
    }

    @Nullable
    private static XmlTag getLayoutTag(PsiElement element) {
        if (!(element instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)element).getRootTag();
        if (rootTag != null && "layout".equals(rootTag.getName())) {
            return rootTag;
        }
        return null;
    }

    @Nullable
    private static XmlTag getDataTag(XmlTag layoutTag) {
        return layoutTag.findFirstSubTag("data");
    }

    private static void scanDataBindingDataTag(PsiResourceFile resourceFile, @Nullable XmlTag dataTag, long modificationCount) {
        DataBindingInfo info = resourceFile.getDataBindingInfo();
        assert (info != null);
        ArrayList items = Lists.newArrayList();
        if (dataTag == null) {
            info.replaceItems(items, modificationCount);
            return;
        }
        HashSet usedNames = Sets.newHashSet();
        for (XmlTag tag : dataTag.findSubTags("variable")) {
            String name;
            String nameValue = tag.getAttributeValue("name");
            if (nameValue == null || !StringUtil.isNotEmpty((String)(name = StringUtil.unescapeXml((String)nameValue))) || !usedNames.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.VARIABLE, tag);
            item.setSource((DataFile)resourceFile);
            items.add(item);
        }
        HashSet usedAliases = Sets.newHashSet();
        for (XmlTag tag : dataTag.findSubTags("import")) {
            int lastIndexOfDot;
            String nameValue = tag.getAttributeValue("type");
            if (nameValue == null) continue;
            String name = StringUtil.unescapeXml((String)nameValue);
            String aliasValue = tag.getAttributeValue("alias");
            String alias = null;
            if (aliasValue != null) {
                alias = StringUtil.unescapeXml((String)aliasValue);
            }
            if (alias == null && (lastIndexOfDot = name.lastIndexOf(46)) >= 0) {
                alias = name.substring(lastIndexOfDot + 1);
            }
            if (!StringUtil.isNotEmpty((String)alias) || !usedAliases.add(name)) continue;
            PsiDataBindingResourceItem item = new PsiDataBindingResourceItem(name, DataBindingResourceType.IMPORT, tag);
            item.setSource((DataFile)resourceFile);
            items.add(item);
        }
        info.replaceItems(items, modificationCount);
    }

    private void scanDataBinding(PsiResourceFile resourceFile, long modificationCount) {
        String classPackage;
        String className;
        if (resourceFile.getFolderType() != ResourceFolderType.LAYOUT) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag layout = ResourceFolderRepository.getLayoutTag((PsiElement)resourceFile.getPsiFile());
        if (layout == null) {
            resourceFile.setDataBindingInfo(null);
            return;
        }
        XmlTag dataTag = ResourceFolderRepository.getDataTag(layout);
        String modulePackage = MergedManifest.get(this.myFacet).getPackage();
        String classAttrValue = null;
        if (dataTag != null && (classAttrValue = dataTag.getAttributeValue("class")) != null) {
            classAttrValue = StringUtil.unescapeXml((String)classAttrValue);
        }
        if (StringUtil.isEmpty(classAttrValue)) {
            className = DataBindingUtil.convertToJavaClassName(resourceFile.getName()) + "Binding";
            classPackage = modulePackage + ".databinding";
        } else {
            int firstDotIndex = classAttrValue.indexOf(46);
            if (firstDotIndex < 0) {
                classPackage = modulePackage + ".databinding";
                className = classAttrValue;
            } else {
                int lastDotIndex = classAttrValue.lastIndexOf(46);
                classPackage = firstDotIndex == 0 ? modulePackage + classAttrValue.substring(0, lastDotIndex) : classAttrValue.substring(0, lastDotIndex);
                className = classAttrValue.substring(lastDotIndex + 1);
            }
        }
        if (resourceFile.getDataBindingInfo() == null) {
            resourceFile.setDataBindingInfo(new DataBindingInfo(this.myFacet, resourceFile, className, classPackage));
        } else {
            resourceFile.getDataBindingInfo().update(className, classPackage, modificationCount);
        }
        ResourceFolderRepository.scanDataBindingDataTag(resourceFile, dataTag, modificationCount);
    }

    protected Map<ResourceType, ListMultimap<String, ResourceItem>> getMap() {
        return this.myItems;
    }

    @Nullable
    @Contract(value="_, true -> !null")
    protected ListMultimap<String, ResourceItem> getMap(ResourceType type, boolean create) {
        ArrayListMultimap multimap = this.myItems.get(type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myItems.put(type, (ListMultimap<String, ResourceItem>)multimap);
        }
        return multimap;
    }

    public void clear() {
        super.clear();
        this.myResourceFiles.clear();
    }

    private void addIds(List<ResourceItem> items, PsiFile file) {
        this.addIds(items, (PsiElement)file, file);
    }

    private void addIds(List<ResourceItem> items, PsiElement element, PsiFile file) {
        HashMap pendingResourceIds = Maps.newHashMap();
        Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)element, XmlTag.class);
        if (element instanceof XmlTag) {
            this.addId(items, file, (XmlTag)element, pendingResourceIds);
        }
        if (!xmlTags.isEmpty()) {
            for (XmlTag tag : xmlTags) {
                this.addId(items, file, tag, pendingResourceIds);
            }
        }
        if (!pendingResourceIds.isEmpty()) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceType.ID, true);
            for (Map.Entry entry : pendingResourceIds.entrySet()) {
                String id = (String)entry.getKey();
                PsiResourceItem remainderItem = new PsiResourceItem(id, ResourceType.ID, (XmlTag)entry.getValue(), file);
                items.add(remainderItem);
                map.put((Object)id, (Object)remainderItem);
            }
        }
    }

    private void addId(List<ResourceItem> items, PsiFile file, XmlTag tag, Map<String, XmlTag> pendingResourceIds) {
        assert (tag.isValid());
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) || (value = attribute.getValue()) == null || !value.startsWith("@+id/") || "id".equals(attribute.getLocalName())) continue;
            ListMultimap<String, ResourceItem> map = this.myItems.get(ResourceType.ID);
            String id = value.substring("@+id/".length());
            if (map == null || map.containsKey((Object)id) || pendingResourceIds.containsKey(id)) continue;
            pendingResourceIds.put(id, tag);
        }
        String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (id != null) {
            if (id.startsWith("@id/")) {
                if (!pendingResourceIds.containsKey(id = id.substring("@id/".length()))) {
                    return;
                }
            } else if (id.startsWith("@+id/")) {
                id = id.substring("@+id/".length());
            } else {
                return;
            }
            pendingResourceIds.remove(id);
            PsiResourceItem item = new PsiResourceItem(id, ResourceType.ID, tag, file);
            items.add(item);
            this.getMap(ResourceType.ID, true).put((Object)id, (Object)item);
        }
    }

    private void scanValueResFolder(@NotNull VirtualFile directory, String qualifiers, FolderConfiguration folderConfiguration) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/res/ResourceFolderRepository", "scanValueResFolder"));
        }
        assert (directory.getName().startsWith("values"));
        for (VirtualFile file : directory.getChildren()) {
            if (!file.isValid() || file.isDirectory()) continue;
            this.scanValueFile(qualifiers, file, folderConfiguration);
        }
    }

    private boolean scanValueFileAsPsi(String qualifiers, PsiFile file, FolderConfiguration folderConfiguration) {
        boolean added = false;
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.XML) {
            XmlFile xmlFile = (XmlFile)file;
            assert (xmlFile.isValid());
            XmlDocument document = xmlFile.getDocument();
            if (document != null) {
                XmlTag root = document.getRootTag();
                if (root == null) {
                    return false;
                }
                if (!root.getName().equals("resources")) {
                    return false;
                }
                XmlTag[] subTags = root.getSubTags();
                ArrayList items = Lists.newArrayListWithExpectedSize((int)subTags.length);
                for (XmlTag tag : subTags) {
                    XmlTag[] attrs;
                    ResourceType type;
                    String name = tag.getAttributeValue("name");
                    if (name == null || (type = AndroidResourceUtil.getType(tag)) == null) continue;
                    ListMultimap<String, ResourceItem> map = this.getMap(type, true);
                    PsiResourceItem item = new PsiResourceItem(name, type, tag, file);
                    map.put((Object)name, (Object)item);
                    items.add(item);
                    added = true;
                    if (type != ResourceType.DECLARE_STYLEABLE || (attrs = tag.getSubTags()).length <= 0) continue;
                    map = this.getMap(ResourceType.ATTR, true);
                    for (XmlTag child : attrs) {
                        String attrName = child.getAttributeValue("name");
                        if (attrName == null || attrName.startsWith("android:") || child.getAttribute("format") == null && child.getSubTags().length <= 0) continue;
                        PsiResourceItem attrItem = new PsiResourceItem(attrName, ResourceType.ATTR, child, file);
                        items.add(attrItem);
                        map.put((Object)attrName, (Object)attrItem);
                    }
                }
                PsiResourceFile resourceFile = new PsiResourceFile(file, items, qualifiers, ResourceFolderType.VALUES, folderConfiguration);
                this.myResourceFiles.put(file.getVirtualFile(), resourceFile);
            }
        }
        return added;
    }

    private void scanValueFile(String qualifiers, VirtualFile virtualFile, FolderConfiguration folderConfiguration) {
        FileType fileType = virtualFile.getFileType();
        if (fileType == StdFileTypes.XML) {
            if (this.myResourceFiles.containsKey(virtualFile)) {
                this.myInitialScanState.countCacheHit();
                return;
            }
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            try {
                ResourceFile resourceFile = this.myInitialScanState.loadFile(file);
                if (resourceFile == null) {
                    this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
                    return;
                }
                for (ResourceItem item : resourceFile.getItems()) {
                    ListMultimap<String, ResourceItem> map = this.getMap(item.getType(), true);
                    map.put((Object)item.getName(), (Object)item);
                }
                this.myInitialScanState.countCacheMiss();
                this.myResourceFiles.put(virtualFile, resourceFile);
            }
            catch (MergingException e) {
                this.myInitialScanState.queuePsiValueResourceScan(new PsiValueResourceQueueEntry(virtualFile, qualifiers, folderConfiguration));
            }
        }
    }

    private boolean convertToPsiIfNeeded(@NotNull PsiFile psiFile, ResourceFolderType folderType) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/res/ResourceFolderRepository", "convertToPsiIfNeeded"));
        }
        ResourceFile resFile = this.myResourceFiles.get(psiFile.getVirtualFile());
        if (resFile instanceof PsiResourceFile) {
            return false;
        }
        this.rescan(psiFile, folderType);
        return true;
    }

    private boolean isResourceFolder(@Nullable PsiElement parent) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (parent instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)parent).getParentDirectory()) != null) {
            VirtualFile dir = parentDirectory.getVirtualFile();
            return dir.equals(this.myResourceDir);
        }
        return false;
    }

    private boolean isResourceFile(PsiFile psiFile) {
        return this.isResourceFolder((PsiElement)psiFile.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(PsiFile psiFile) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            return this.myPendingScans != null && this.myPendingScans.contains(psiFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescan(final PsiFile psiFile, final ResourceFolderType folderType) {
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.isScanPending(psiFile)) {
                return;
            }
            if (this.myPendingScans == null) {
                this.myPendingScans = Sets.newHashSet();
            }
            this.myPendingScans.add(psiFile);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!psiFile.isValid()) {
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean rescan;
                        Object object = ResourceFolderRepository.this.SCAN_LOCK;
                        synchronized (object) {
                            rescan = ResourceFolderRepository.this.myPendingScans != null && ResourceFolderRepository.this.myPendingScans.contains(psiFile);
                        }
                        if (rescan) {
                            ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
                            object = ResourceFolderRepository.this.SCAN_LOCK;
                            synchronized (object) {
                                ResourceFolderRepository.this.myPendingScans.remove(psiFile);
                                if (ResourceFolderRepository.this.myPendingScans.isEmpty()) {
                                    ResourceFolderRepository.this.myPendingScans = null;
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        ArrayList<PsiFile> files;
        super.sync();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            if (this.myPendingScans == null || this.myPendingScans.isEmpty()) {
                return;
            }
            files = new ArrayList<PsiFile>(this.myPendingScans);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (PsiFile file : files) {
                    ResourceFolderType folderType;
                    if (!file.isValid() || (folderType = ResourceHelper.getFolderType(file)) == null) continue;
                    ResourceFolderRepository.this.rescanImmediately(file, folderType);
                }
            }
        });
        object = this.SCAN_LOCK;
        synchronized (object) {
            this.myPendingScans = null;
        }
    }

    private void rescanImmediately(final PsiFile psiFile, final ResourceFolderType folderType) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
                }
            });
            return;
        }
        PsiFile file = psiFile;
        if (folderType == ResourceFolderType.VALUES) {
            ++ourFullRescans;
            ResourceFile resourceFile = this.myResourceFiles.get(file.getVirtualFile());
            boolean removed = false;
            if (resourceFile != null) {
                for (ResourceItem item : resourceFile.getItems()) {
                    removed |= this.removeItems(resourceFile, item.getType(), item.getName(), false);
                }
                this.myResourceFiles.remove(file.getVirtualFile());
            }
            file = this.ensureValid(file);
            boolean added = false;
            if (file != null) {
                FolderConfiguration folderConfiguration;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                String dirName = parent.getName();
                PsiDirectory fileParent = psiFile.getParent();
                if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                    added = this.scanValueFileAsPsi(ResourceFolderRepository.getQualifiers(dirName), file, folderConfiguration);
                }
            }
            if (added || removed) {
                this.myGeneration = ourModificationCounter.incrementAndGet();
                this.invalidateItemCaches(new ResourceType[0]);
            }
        } else {
            ResourceFile resFile = this.myResourceFiles.get(file.getVirtualFile());
            if (resFile != null && resFile instanceof PsiResourceFile) {
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && file.getFileType() == StdFileTypes.XML) {
                    ArrayList idItems;
                    ++ourFullRescans;
                    HashSet idsBefore = Sets.newHashSet();
                    HashSet idsAfter = Sets.newHashSet();
                    ListMultimap<String, ResourceItem> map = this.myItems.get(ResourceType.ID);
                    if (map != null) {
                        idItems = Lists.newArrayList();
                        for (ResourceItem item : resourceFile) {
                            if (item.getType() != ResourceType.ID) continue;
                            idsBefore.add(item.getName());
                            idItems.add(item);
                        }
                        for (String id : idsBefore) {
                            List mapItems = map.get((Object)id);
                            if (mapItems == null || mapItems.isEmpty()) continue;
                            ArrayList toDelete = Lists.newArrayListWithExpectedSize((int)mapItems.size());
                            for (ResourceItem mapItem : mapItems) {
                                if (mapItem.getSource() != resourceFile) continue;
                                toDelete.add(mapItem);
                            }
                            for (ResourceItem delete : toDelete) {
                                map.remove((Object)delete.getName(), (Object)delete);
                            }
                        }
                        resourceFile.removeItems(idItems);
                    }
                    idItems = Lists.newArrayList();
                    if ((file = this.ensureValid(file)) != null) {
                        this.addIds(idItems, file);
                    }
                    if (!idItems.isEmpty()) {
                        resourceFile.addItems(idItems);
                        for (ResourceItem item : idItems) {
                            idsAfter.add(item.getName());
                        }
                    }
                    if (!idsBefore.equals(idsAfter)) {
                        this.myGeneration = ourModificationCounter.incrementAndGet();
                    }
                    this.scanDataBinding(resourceFile, this.myGeneration);
                    this.invalidateItemCaches(ResourceType.ID);
                }
            } else {
                boolean switchingToPsi;
                boolean bl = switchingToPsi = resFile != null && !(resFile instanceof PsiResourceFile);
                if (switchingToPsi) {
                    this.removeItemsFromFile(resFile);
                }
                ++ourFullRescans;
                PsiDirectory parent = file.getParent();
                assert (parent != null);
                String dirName = parent.getName();
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                assert (resourceTypes.size() >= 1) : folderType;
                ResourceType type = (ResourceType)resourceTypes.get(0);
                boolean idGeneratingFolder = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
                ListMultimap<String, ResourceItem> map = this.getMap(type, true);
                if ((file = this.ensureValid(file)) != null) {
                    FolderConfiguration folderConfiguration;
                    PsiDirectory fileParent = psiFile.getParent();
                    if (fileParent != null && (folderConfiguration = FolderConfiguration.getConfigForFolder((String)fileParent.getName())) != null) {
                        boolean idGeneratingFile = idGeneratingFolder && file.getFileType() == StdFileTypes.XML;
                        this.scanFileResourceFileAsPsi(ResourceFolderRepository.getQualifiers(dirName), folderType, folderConfiguration, type, idGeneratingFile, map, file);
                    }
                    this.myGeneration = ourModificationCounter.incrementAndGet();
                    this.invalidateItemCaches(new ResourceType[0]);
                }
            }
        }
    }

    private boolean removeItems(ResourceFile resourceFile, ResourceType type, String name, boolean removeFromFile) {
        List mapItems;
        boolean removed = false;
        ListMultimap<String, ResourceItem> map = this.myItems.get(type);
        if (map != null && (mapItems = map.get((Object)name)) != null) {
            ListIterator iterator = mapItems.listIterator();
            while (iterator.hasNext()) {
                ResourceItem next = (ResourceItem)iterator.next();
                if (next.getSource() != resourceFile) continue;
                iterator.remove();
                if (removeFromFile) {
                    resourceFile.removeItem(next);
                }
                removed = true;
            }
        }
        return removed;
    }

    private void bitmapUpdated() {
        Module module;
        AndroidTargetData targetData;
        IAndroidTarget target;
        ConfigurationManager configurationManager = this.myFacet.getConfigurationManager(false);
        if (configurationManager != null && (target = configurationManager.getTarget()) != null && (targetData = AndroidTargetData.getTargetData(target, module = this.myFacet.getModule())) != null) {
            targetData.clearLayoutBitmapCache(module);
        }
    }

    @NotNull
    public PsiTreeChangeListener getPsiListener() {
        PsiListener psiListener = this.myListener;
        if (psiListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "getPsiListener"));
        }
        return psiListener;
    }

    @Nullable
    private ResourceFile findResourceFile(String dirName, String fileName) {
        String folderTypeName;
        String qualifiers;
        int index = dirName.indexOf(45);
        if (index == -1) {
            qualifiers = "";
            folderTypeName = dirName;
        } else {
            qualifiers = dirName.substring(index + 1);
            folderTypeName = dirName.substring(0, index);
        }
        ResourceFolderType folderType = ResourceFolderType.getTypeByName((String)folderTypeName);
        for (ResourceFile resourceFile : this.myResourceFiles.values()) {
            String name = resourceFile.getFile().getName();
            ResourceFolderType resFolderType = ResourceHelper.getFolderType(resourceFile);
            if (folderType != resFolderType || !fileName.equals(name) || !qualifiers.equals(resourceFile.getQualifiers())) continue;
            return resourceFile;
        }
        return null;
    }

    private void removeItemsFromFile(ResourceFile resourceFile) {
        for (ResourceItem item : resourceFile.getItems()) {
            this.removeItems(resourceFile, item.getType(), item.getName(), false);
        }
    }

    private static boolean isItemElement(XmlTag xmlTag) {
        String tag = xmlTag.getName();
        if (tag.equals("resources")) {
            return false;
        }
        return tag.equals("item") || ResourceType.getEnum((String)tag) != null;
    }

    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceFolderRepository", "findValueResourceItem"));
        }
        if (!tag.isValid()) {
            ResourceFile resFile = this.myResourceFiles.get(file.getVirtualFile());
            if (resFile != null) {
                assert (resFile instanceof PsiResourceFile);
                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                for (ResourceItem item : resourceFile) {
                    PsiResourceItem pri = (PsiResourceItem)item;
                    XmlTag xmlTag = pri.getTag();
                    if (xmlTag != tag) continue;
                    return item;
                }
            }
            return null;
        }
        String name = tag.getAttributeValue("name");
        return name != null ? this.findValueResourceItem(tag, file, name) : null;
    }

    @Nullable
    private ResourceItem findValueResourceItem(XmlTag tag, @NotNull PsiFile file, String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceFolderRepository", "findValueResourceItem"));
        }
        ResourceType type = AndroidResourceUtil.getType(tag);
        return this.findResourceItem(type, file, name, tag);
    }

    @Nullable
    private ResourceItem findResourceItem(@Nullable ResourceType type, @NotNull PsiFile file, @Nullable String name, @Nullable XmlTag tag) {
        ListMultimap<String, ResourceItem> map;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/res/ResourceFolderRepository", "findResourceItem"));
        }
        if (type != null && name != null && (map = this.myItems.get(type)) != null) {
            List items = map.get((Object)name);
            assert (items != null);
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file.getVirtualFile());
            if (tag != null) {
                for (ResourceItem item : items) {
                    ResourceFile resourceFile = (ResourceFile)item.getSource();
                    if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                    assert (item instanceof PsiResourceItem);
                    PsiResourceItem psiItem = (PsiResourceItem)item;
                    if (psiItem.getTag() != tag) continue;
                    return item;
                }
                return null;
            }
            for (ResourceItem item : items) {
                ResourceFile resourceFile = (ResourceFile)item.getSource();
                if (resourceFile == null || !FileUtil.filesEqual((File)resourceFile.getFile(), (File)ioFile)) continue;
                return item;
            }
        }
        return null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myResourceDir + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        HashSet hashSet = Sets.newHashSet((Object[])new VirtualFile[]{this.myResourceDir});
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/ResourceFolderRepository", "computeResourceDirs"));
        }
        return hashSet;
    }

    boolean equalFilesItems(ResourceFolderRepository other) {
        File otherResourceDir;
        File myResourceDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myResourceDir);
        if (!FileUtil.filesEqual((File)myResourceDirFile, (File)(otherResourceDir = VfsUtilCore.virtualToIoFile((VirtualFile)other.myResourceDir)))) {
            return false;
        }
        if (this.myResourceFiles.size() != other.myResourceFiles.size()) {
            return false;
        }
        for (Map.Entry<VirtualFile, ResourceFile> entry : this.myResourceFiles.entrySet()) {
            ResourceFile otherResFile = other.myResourceFiles.get(entry.getKey());
            if (otherResFile == null) {
                return false;
            }
            if (FileUtil.filesEqual((File)entry.getValue().getFile(), (File)otherResFile.getFile())) continue;
            return false;
        }
        if (this.myItems.size() != other.myItems.size()) {
            return false;
        }
        for (Map.Entry<VirtualFile, ResourceFile> entry : this.myItems.entrySet()) {
            ListMultimap ownEntries = (ListMultimap)entry.getValue();
            ListMultimap<String, ResourceItem> otherEntries = other.myItems.get(entry.getKey());
            if (otherEntries == null || otherEntries.size() != ownEntries.size()) {
                return false;
            }
            for (Map.Entry itemEntry : ownEntries.entries()) {
                List otherItemsList = otherEntries.get(itemEntry.getKey());
                if (otherItemsList == null) {
                    return false;
                }
                final ResourceItem item = (ResourceItem)itemEntry.getValue();
                if (ContainerUtil.exists((Iterable)otherItemsList, (Condition)new Condition<ResourceItem>(){

                    public boolean value(ResourceItem resourceItem) {
                        if (resourceItem.compareTo(item) != 0) {
                            return false;
                        }
                        if (item.getType() != ResourceType.ID) {
                            ResourceValue resValue = item.getResourceValue(false);
                            ResourceValue otherResValue = resourceItem.getResourceValue(false);
                            if (resValue == null || otherResValue == null) {
                                if (resValue != otherResValue) {
                                    return false;
                                }
                            } else {
                                String resValueStr = resValue.getValue();
                                String otherResValueStr = otherResValue.getValue();
                                if (resValueStr == null || otherResValueStr == null ? resValueStr != otherResValueStr : !resValueStr.equals(otherResValueStr)) {
                                    return false;
                                }
                            }
                        }
                        ResourceFile source = (ResourceFile)item.getSource();
                        ResourceFile otherSource = (ResourceFile)resourceItem.getSource();
                        if (source != null && otherSource != null) {
                            ResourceFolderType ownFolderType = ResourceHelper.getFolderType(source);
                            ResourceFolderType otherFolderType = ResourceHelper.getFolderType(otherSource);
                            if (otherFolderType != ownFolderType) {
                                return false;
                            }
                            if (otherFolderType == ResourceFolderType.VALUES) {
                                return resourceItem.compareValueWith(item);
                            }
                        }
                        return true;
                    }
                })) continue;
                return false;
            }
        }
        return this.myDataBindingResourceFiles.keySet().equals(other.myDataBindingResourceFiles.keySet());
    }

    private final class PsiListener
    extends PsiTreeChangeAdapter {
        private boolean myIgnoreChildrenChanged;
        private boolean mySeenPrePropertyChange;

        private PsiListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "childAdded"));
            }
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                PsiDirectory directory;
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    psiFile = (PsiFile)child;
                    if (PsiProjectListener.isRelevantFile(psiFile)) {
                        this.addFile(psiFile);
                    }
                } else if (child instanceof PsiDirectory && ResourceFolderRepository.this.isResourceFolder((PsiElement)(directory = (PsiDirectory)child))) {
                    for (PsiFile file : directory.getFiles()) {
                        if (!PsiProjectListener.isRelevantFile(file)) continue;
                        this.addFile(file);
                    }
                }
            } else if (PsiProjectListener.isRelevantFile(psiFile)) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (folderType == ResourceFolderType.VALUES) {
                        if (child instanceof XmlTag) {
                            XmlTag parentTag;
                            XmlTag tag = (XmlTag)child;
                            if (ResourceFolderRepository.isItemElement(tag)) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceFile resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
                                if (resFile != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                    String name = tag.getAttributeValue("name");
                                    if (name != null) {
                                        ResourceType type = AndroidResourceUtil.getType(tag);
                                        if (type == ResourceType.DECLARE_STYLEABLE) {
                                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                                            return;
                                        }
                                        if (type != null) {
                                            ListMultimap<String, ResourceItem> map = ResourceFolderRepository.this.getMap(type, true);
                                            PsiResourceItem item = new PsiResourceItem(name, type, tag, psiFile);
                                            map.put((Object)name, (Object)item);
                                            resourceFile.addItems(Collections.singletonList(item));
                                            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                            ResourceFolderRepository.this.invalidateItemCaches(type);
                                            return;
                                        }
                                    }
                                }
                            }
                            if ((parentTag = tag.getParentTag()) != null && ResourceType.getEnum((String)parentTag.getName()) != null) {
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ResourceItem parentItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                if (parentItem instanceof PsiResourceItem) {
                                    if (((PsiResourceItem)parentItem).recomputeValue()) {
                                        ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                    }
                                    return;
                                }
                            }
                            ResourceFolderRepository.this.rescan(psiFile, folderType);
                        } else {
                            if (parent instanceof XmlText) {
                                XmlText text = (XmlText)parent;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (child instanceof XmlText) {
                                this.handleValueXmlTextEdit(parent, psiFile);
                                return;
                            }
                            if (parent instanceof XmlComment || child instanceof XmlComment) {
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlText || child instanceof XmlText && child.getText().trim().isEmpty()) {
                            return;
                        }
                        if (parent instanceof XmlElement && child instanceof XmlElement) {
                            if (child instanceof XmlTag) {
                                ResourceFile resFile;
                                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                    return;
                                }
                                ArrayList ids = Lists.newArrayList();
                                ResourceFolderRepository.this.addIds(ids, child, psiFile);
                                if (!ids.isEmpty() && (resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile())) != null) {
                                    assert (resFile instanceof PsiResourceFile);
                                    PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                    resourceFile.addItems(ids);
                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                    ResourceFolderRepository.this.invalidateItemCaches(ResourceType.ID);
                                }
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent instanceof XmlAttribute) : parent;
                                XmlAttribute attribute = (XmlAttribute)parent;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING)) {
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            }
                        }
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            block29: {
                ResourceFolderType folderType;
                PsiFile psiFile;
                block31: {
                    PsiElement parent;
                    PsiElement child;
                    block32: {
                        XmlTag parentTag;
                        block30: {
                            String dirName;
                            ResourceFolderType folderType2;
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "childRemoved"));
                            }
                            psiFile = event.getFile();
                            if (psiFile != null) break block30;
                            PsiElement child2 = event.getChild();
                            if (child2 instanceof PsiFile) {
                                psiFile = (PsiFile)child2;
                                if (PsiProjectListener.isRelevantFile(psiFile)) {
                                    this.removeFile(psiFile);
                                }
                                break block29;
                            } else if (child2 instanceof PsiDirectory && (folderType2 = ResourceFolderType.getFolderType((String)(dirName = ((PsiDirectory)child2).getName()))) != null) {
                                PsiDirectory parentDirectory = ((PsiDirectory)child2).getParent();
                                if (parentDirectory == null) {
                                    return;
                                }
                                VirtualFile dir = parentDirectory.getVirtualFile();
                                if (!ResourceFolderRepository.this.myFacet.getLocalResourceManager().isResourceDir(dir)) {
                                    return;
                                }
                                int index = dirName.indexOf(45);
                                String qualifiers = index == -1 ? "" : dirName.substring(index + 1);
                                ArrayList resourceFiles = new ArrayList(ResourceFolderRepository.this.myResourceFiles.values());
                                for (ResourceFile file : resourceFiles) {
                                    ResourceFolderType resFolderType = ResourceHelper.getFolderType(file);
                                    if (folderType2 != resFolderType || !qualifiers.equals(file.getQualifiers())) continue;
                                    this.removeFile(file);
                                }
                            }
                            break block29;
                        }
                        if (!PsiProjectListener.isRelevantFile(psiFile)) break block29;
                        if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                            return;
                        }
                        folderType = ResourceHelper.getFolderType(psiFile);
                        if (folderType == null || !ResourceFolderRepository.this.isResourceFile(psiFile)) break block29;
                        child = event.getChild();
                        parent = event.getParent();
                        if (folderType != ResourceFolderType.VALUES) break block31;
                        if (!(child instanceof XmlTag)) break block32;
                        XmlTag tag = (XmlTag)child;
                        if (parent instanceof XmlTag && ResourceType.getEnum((String)(parentTag = (XmlTag)parent).getName()) != null) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                            if (resourceItem instanceof PsiResourceItem) {
                                ResourceItem declareStyleable;
                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                }
                                if (resourceItem.getType() == ResourceType.ATTR && (parentTag = parentTag.getParentTag()) != null && parentTag.getName().equals(ResourceType.DECLARE_STYLEABLE.getName()) && (declareStyleable = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem && ((PsiResourceItem)declareStyleable).recomputeValue()) {
                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                }
                                return;
                            }
                        }
                        if (ResourceFolderRepository.isItemElement(tag)) {
                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                return;
                            }
                            ResourceFile resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
                            if (resFile != null) {
                                ResourceType type;
                                String name;
                                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                if (!tag.isValid()) {
                                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(tag, psiFile);
                                    if (item == null) {
                                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                                        return;
                                    }
                                    name = item.getName();
                                } else {
                                    name = tag.getAttributeValue("name");
                                }
                                if (name != null && (type = AndroidResourceUtil.getType(tag)) != null) {
                                    ListMultimap map = (ListMultimap)ResourceFolderRepository.this.myItems.get(type);
                                    if (map == null) {
                                        return;
                                    }
                                    if (ResourceFolderRepository.this.removeItems(resourceFile, type, name, true)) {
                                        ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                        ResourceFolderRepository.this.invalidateItemCaches(type);
                                    }
                                }
                                return;
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                        break block29;
                    }
                    if (parent instanceof XmlText) {
                        XmlText text = (XmlText)parent;
                        this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                        break block29;
                    } else if (child instanceof XmlText) {
                        this.handleValueXmlTextEdit(parent, psiFile);
                        break block29;
                    } else {
                        if (parent instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    }
                    break block29;
                }
                if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void removeFile(@Nullable ResourceFile resourceFile) {
            if (resourceFile == null) {
                return;
            }
            for (Map.Entry entry : ResourceFolderRepository.this.myResourceFiles.entrySet()) {
                ResourceFile file = (ResourceFile)entry.getValue();
                if (resourceFile != file) continue;
                VirtualFile keyFile = (VirtualFile)entry.getKey();
                ResourceFolderRepository.this.myResourceFiles.remove(keyFile);
                break;
            }
            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
            ResourceFolderType folderType = ResourceHelper.getFolderType(resourceFile);
            if (folderType == ResourceFolderType.VALUES || FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType)) {
                ResourceFolderRepository.this.removeItemsFromFile(resourceFile);
            } else if (folderType != null) {
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : resourceTypes) {
                    if (type == ResourceType.ID) continue;
                    String name = LintUtils.getBaseName((String)resourceFile.getFile().getName());
                    ResourceFolderRepository.this.removeItems(resourceFile, type, name, false);
                }
            }
        }

        private void removeFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "removeFile"));
            }
            assert (!psiFile.isValid() || PsiProjectListener.isRelevantFile(psiFile));
            ResourceFile resourceFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
            if (resourceFile == null) {
                return;
            }
            ResourceFolderRepository.this.myResourceFiles.remove(psiFile.getVirtualFile());
            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType == ResourceFolderType.VALUES || FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                ResourceFolderRepository.this.removeItemsFromFile(resourceFile);
            } else if (folderType != null) {
                FileType fileType;
                if (folderType == ResourceFolderType.DRAWABLE && (fileType = psiFile.getFileType()).isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png")) {
                    ResourceFolderRepository.this.bitmapUpdated();
                }
                List resourceTypes = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                for (ResourceType type : resourceTypes) {
                    if (type == ResourceType.ID) continue;
                    String name = ResourceHelper.getResourceName(psiFile);
                    ResourceFolderRepository.this.removeItems(resourceFile, type, name, false);
                }
            }
        }

        private void addFile(PsiFile psiFile) {
            assert (PsiProjectListener.isRelevantFile(psiFile));
            ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
            if (folderType != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                ResourceFolderRepository.this.rescanImmediately(psiFile, folderType);
            }
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "childReplaced"));
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                if (ResourceFolderRepository.this.isScanPending(psiFile)) {
                    return;
                }
                if (PsiProjectListener.isRelevantFile(psiFile)) {
                    PsiElement parent;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (folderType != null && FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType) && psiFile.getFileType() == StdFileTypes.XML) {
                        PsiElement parent2 = event.getParent();
                        PsiElement child = event.getChild();
                        if (parent2 instanceof XmlText || child instanceof XmlText || parent2 instanceof XmlComment || child instanceof XmlComment) {
                            return;
                        }
                        if (parent2 instanceof XmlElement && child instanceof XmlElement) {
                            if (event.getOldChild() == event.getNewChild()) {
                                ResourceFolderRepository.this.rescan(psiFile, folderType);
                                return;
                            }
                            if (child instanceof XmlAttributeValue) {
                                assert (parent2 instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)parent2;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFile resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
                                    if (resFile != null) {
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        if (oldChild instanceof XmlAttributeValue && newChild instanceof XmlAttributeValue) {
                                            String newName;
                                            XmlAttributeValue oldValue = (XmlAttributeValue)oldChild;
                                            XmlAttributeValue newValue = (XmlAttributeValue)newChild;
                                            String oldName = LintUtils.stripIdPrefix((String)oldValue.getValue());
                                            if (oldName.equals(newName = LintUtils.stripIdPrefix((String)newValue.getValue()))) {
                                                return;
                                            }
                                            if (resFile instanceof PsiResourceFile) {
                                                ListMultimap map;
                                                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                                if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                                    map.remove((Object)oldName, (Object)item);
                                                    PsiResourceItem newItem = new PsiResourceItem(newName, ResourceType.ID, xmlTag, psiFile);
                                                    map.put((Object)newName, (Object)newItem);
                                                    resourceFile.replace(item, newItem);
                                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                                    ResourceFolderRepository.this.invalidateItemCaches(ResourceType.ID);
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                }
                            } else if (parent2 instanceof XmlAttributeValue) {
                                ResourceFile resFile;
                                PsiElement grandParent = parent2.getParent();
                                if (grandParent instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                assert (grandParent instanceof XmlAttribute) : parent2;
                                XmlAttribute attribute = (XmlAttribute)grandParent;
                                if ("id".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                                    ResourceFile resFile2 = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
                                    if (resFile2 != null) {
                                        String newName;
                                        XmlTag xmlTag = attribute.getParent();
                                        PsiElement oldChild = event.getOldChild();
                                        PsiElement newChild = event.getNewChild();
                                        String oldName = LintUtils.stripIdPrefix((String)oldChild.getText());
                                        if (oldName.equals(newName = LintUtils.stripIdPrefix((String)newChild.getText()))) {
                                            return;
                                        }
                                        if (resFile2 instanceof PsiResourceFile) {
                                            ListMultimap map;
                                            PsiResourceFile resourceFile = (PsiResourceFile)resFile2;
                                            ResourceItem item = ResourceFolderRepository.this.findResourceItem(ResourceType.ID, psiFile, oldName, xmlTag);
                                            if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                                map.remove((Object)oldName, (Object)item);
                                                PsiResourceItem newItem = new PsiResourceItem(newName, ResourceType.ID, xmlTag, psiFile);
                                                map.put((Object)newName, (Object)newItem);
                                                resourceFile.replace(item, newItem);
                                                ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                                ResourceFolderRepository.this.invalidateItemCaches(ResourceType.ID);
                                                return;
                                            }
                                        }
                                    }
                                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                                } else if (ArrayUtil.contains((String)attribute.getLocalName(), (String[])SdkConstants.ATTRS_DATA_BINDING) && ArrayUtil.contains((String)attribute.getParent().getLocalName(), (String[])SdkConstants.TAGS_DATA_BINDING) && (resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile())) != null) {
                                    PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                    ResourceFolderRepository.this.scanDataBinding(resourceFile, ResourceFolderRepository.this.myGeneration);
                                }
                            }
                            return;
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.VALUES) {
                        PsiElement parent3 = event.getParent();
                        if (parent3 instanceof XmlElement) {
                            if (parent3 instanceof XmlComment) {
                                return;
                            }
                            if (parent3 instanceof XmlTag) {
                                XmlTag parentTag = (XmlTag)parent3;
                                if (ResourceType.getEnum((String)parentTag.getName()) != null) {
                                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                        return;
                                    }
                                    ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                    if (resourceItem instanceof PsiResourceItem) {
                                        if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                        }
                                        return;
                                    }
                                }
                                if (parentTag.getName().equals("resources") && event.getOldChild() instanceof XmlText && event.getNewChild() instanceof XmlText) {
                                    return;
                                }
                            }
                            if (parent3 instanceof XmlText) {
                                XmlText text = (XmlText)parent3;
                                this.handleValueXmlTextEdit((PsiElement)text.getParentTag(), psiFile);
                                return;
                            }
                            if (parent3 instanceof XmlAttributeValue) {
                                PsiElement attribute = parent3.getParent();
                                if (attribute instanceof XmlProcessingInstruction) {
                                    return;
                                }
                                PsiElement tag = attribute.getParent();
                                assert (attribute instanceof XmlAttribute) : attribute;
                                XmlAttribute xmlAttribute = (XmlAttribute)attribute;
                                assert (tag instanceof XmlTag) : tag;
                                XmlTag xmlTag = (XmlTag)tag;
                                String attributeName = xmlAttribute.getName();
                                if (ResourceFolderRepository.isItemElement(xmlTag) && attributeName.equals("name")) {
                                    ResourceType type = AndroidResourceUtil.getType(xmlTag);
                                    if (type != null) {
                                        ListMultimap map;
                                        String newName;
                                        String oldName = event.getOldChild().getText();
                                        if (oldName.equals(newName = event.getNewChild().getText())) {
                                            return;
                                        }
                                        if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                            return;
                                        }
                                        ResourceItem item = ResourceFolderRepository.this.findResourceItem(type, psiFile, oldName, xmlTag);
                                        if (item != null && (map = (ListMultimap)ResourceFolderRepository.this.myItems.get(item.getType())) != null) {
                                            ResourceItem style;
                                            XmlTag parentTag;
                                            map.remove((Object)oldName, (Object)item);
                                            PsiResourceItem newItem = new PsiResourceItem(newName, type, xmlTag, psiFile);
                                            map.put((Object)newName, (Object)newItem);
                                            ResourceFile resFile = (ResourceFile)ResourceFolderRepository.this.myResourceFiles.get(psiFile.getVirtualFile());
                                            if (resFile != null) {
                                                PsiResourceFile resourceFile = (PsiResourceFile)resFile;
                                                resourceFile.replace(item, newItem);
                                            } else assert (false) : item;
                                            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                            ResourceFolderRepository.this.invalidateItemCaches(type);
                                            if (type == ResourceType.ATTR && (parentTag = xmlTag.getParentTag()) != null && parentTag.getName().equals(ResourceType.DECLARE_STYLEABLE.getName()) && (style = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile)) instanceof PsiResourceItem) {
                                                ((PsiResourceItem)style).recomputeValue();
                                            }
                                            return;
                                        }
                                    } else {
                                        XmlTag parentTag = xmlTag.getParentTag();
                                        if (parentTag != null && ResourceType.getEnum((String)parentTag.getName()) != null) {
                                            if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                                                return;
                                            }
                                            ResourceItem resourceItem = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                                            if (resourceItem instanceof PsiResourceItem) {
                                                if (((PsiResourceItem)resourceItem).recomputeValue()) {
                                                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                                                }
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ResourceFolderRepository.this.rescan(psiFile, folderType);
                    } else if (folderType == ResourceFolderType.COLOR && (parent = event.getParent()) instanceof XmlElement) {
                        PsiElement attribute;
                        if (parent instanceof XmlComment) {
                            return;
                        }
                        if (parent instanceof XmlAttributeValue && (attribute = parent.getParent()) instanceof XmlProcessingInstruction) {
                            return;
                        }
                        ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                        return;
                    }
                }
            } else {
                PsiElement parent = event.getParent();
                if (ResourceFolderRepository.this.isResourceFolder(parent)) {
                    PsiFile newFile;
                    PsiFile oldFile;
                    PsiElement oldChild = event.getOldChild();
                    PsiElement newChild = event.getNewChild();
                    if (oldChild instanceof PsiFile && PsiProjectListener.isRelevantFile(oldFile = (PsiFile)oldChild)) {
                        this.removeFile(oldFile);
                    }
                    if (newChild instanceof PsiFile && PsiProjectListener.isRelevantFile(newFile = (PsiFile)newChild)) {
                        this.addFile(newFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        private void handleValueXmlTextEdit(@Nullable PsiElement parent, @NotNull PsiFile psiFile) {
            XmlTag style;
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "handleValueXmlTextEdit"));
            }
            if (!(parent instanceof XmlTag)) {
                return;
            }
            XmlTag parentTag = (XmlTag)parent;
            String parentTagName = parentTag.getName();
            if (parentTagName.equals("resources")) {
                return;
            }
            if (parentTagName.equals("item") && (style = parentTag.getParentTag()) != null && ResourceType.getEnum((String)style.getName()) != null) {
                boolean cleared;
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                    return;
                }
                ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(style, psiFile);
                if (item instanceof PsiResourceItem && (cleared = ((PsiResourceItem)item).recomputeValue())) {
                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                }
                return;
            }
            while (parentTag != null) {
                if (ResourceFolderRepository.isItemElement(parentTag)) {
                    boolean cleared;
                    ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                    if (ResourceFolderRepository.this.convertToPsiIfNeeded(psiFile, folderType)) {
                        return;
                    }
                    ResourceItem item = ResourceFolderRepository.this.findValueResourceItem(parentTag, psiFile);
                    if (!(item instanceof PsiResourceItem) || !(cleared = ((PsiResourceItem)item).recomputeValue())) break;
                    ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                    break;
                }
                parentTag = parentTag.getParentTag();
            }
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "childMoved"));
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = event.getFile();
            if (psiFile == null && child instanceof PsiFile) {
                boolean isResourceFolder;
                psiFile = (PsiFile)child;
                if (!PsiProjectListener.isRelevantFile(psiFile)) {
                    return;
                }
                String name = psiFile.getName();
                PsiElement oldParent = event.getOldParent();
                if (!(oldParent instanceof PsiDirectory)) {
                    this.addFile(psiFile);
                    return;
                }
                PsiDirectory oldParentDir = (PsiDirectory)oldParent;
                String oldDirName = oldParentDir.getName();
                ResourceFolderType oldFolderType = ResourceFolderType.getFolderType((String)oldDirName);
                ResourceFolderType newFolderType = ResourceHelper.getFolderType(psiFile);
                boolean wasResourceFolder = oldFolderType != null && ResourceFolderRepository.this.isResourceFolder((PsiElement)oldParentDir);
                boolean bl = isResourceFolder = newFolderType != null && ResourceFolderRepository.this.isResourceFile(psiFile);
                if (wasResourceFolder == isResourceFolder) {
                    if (!isResourceFolder) {
                        return;
                    }
                    ResourceFile resourceFile = ResourceFolderRepository.this.findResourceFile(oldDirName, name);
                    if (resourceFile != null) {
                        if (oldFolderType != newFolderType) {
                            this.removeFile(resourceFile);
                            this.addFile(psiFile);
                        } else {
                            VirtualFile vFile = VfsUtil.findFileByIoFile((File)resourceFile.getFile(), (boolean)false);
                            if (!(resourceFile instanceof PsiResourceFile) || vFile == null) {
                                this.removeFile(resourceFile);
                                this.addFile(psiFile);
                                return;
                            }
                            ResourceFolderRepository.this.myResourceFiles.remove(vFile);
                            ResourceFolderRepository.this.myResourceFiles.put(psiFile.getVirtualFile(), resourceFile);
                            PsiResourceFile psiResourceFile = (PsiResourceFile)resourceFile;
                            PsiDirectory newParent = psiFile.getParent();
                            assert (newParent != null);
                            String newDirName = newParent.getName();
                            psiResourceFile.setPsiFile(psiFile, ResourceFolderRepository.getQualifiers(newDirName));
                            ResourceFolderRepository.this.myGeneration = LocalResourceRepository.ourModificationCounter.incrementAndGet();
                            for (ResourceItem item : psiResourceFile) {
                                if (!(item instanceof PsiResourceItem)) continue;
                                ((PsiResourceItem)item).recomputeValue();
                            }
                            ResourceFolderRepository.this.invalidateItemCaches(new ResourceType[0]);
                        }
                    } else {
                        this.addFile(psiFile);
                    }
                } else if (isResourceFolder) {
                    this.addFile(psiFile);
                } else {
                    assert (wasResourceFolder);
                    String dirName = oldParentDir.getName();
                    ResourceFile resourceFile = ResourceFolderRepository.this.findResourceFile(dirName, name);
                    if (resourceFile != null) {
                        this.removeFile(resourceFile);
                    }
                }
            }
            this.myIgnoreChildrenChanged = true;
        }

        public final void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "beforeChildrenChange"));
            }
            this.myIgnoreChildrenChanged = false;
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "childrenChanged"));
            }
            PsiElement parent = event.getParent();
            if (this.myIgnoreChildrenChanged ? parent != event.getChild() : event.getNewChild() == null && event.getOldChild() == null && event.getOldParent() == null && event.getNewParent() == null && parent instanceof PsiFile) {
                return;
            }
            if (parent != null && parent.getChildren().length == 1 && parent.getChildren()[0] instanceof PsiWhiteSpace) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile != null && PsiProjectListener.isRelevantFile(psiFile)) {
                ResourceFolderType folderType;
                VirtualFile file = psiFile.getVirtualFile();
                if (file != null && (folderType = ResourceHelper.getFolderType(psiFile)) != null && ResourceFolderRepository.this.isResourceFile(psiFile)) {
                    ResourceFolderRepository.this.rescan(psiFile, folderType);
                }
            } else {
                Throwable throwable = new Throwable();
                throwable.fillInStackTrace();
                LOG.debug("Received unexpected childrenChanged event for inter-file operations", throwable);
            }
        }

        public final void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "beforePropertyChange"));
            }
            if ("fileName" == event.getPropertyName() && (child = event.getChild()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                this.removeFile(psiFile);
            }
            this.mySeenPrePropertyChange = true;
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRepository$PsiListener", "propertyChanged"));
            }
            if ("fileName" == event.getPropertyName() && ResourceFolderRepository.this.isResourceFolder(event.getParent()) && (child = event.getElement()) instanceof PsiFile && PsiProjectListener.isRelevantFile(psiFile = (PsiFile)child) && ResourceFolderRepository.this.isResourceFolder(event.getParent())) {
                Object oldValue;
                if (!this.mySeenPrePropertyChange && (oldValue = event.getOldValue()) instanceof String) {
                    PsiDirectory parent = psiFile.getParent();
                    String oldName = (String)oldValue;
                    if (parent != null && parent.findFile(oldName) == null) {
                        this.removeFile(ResourceFolderRepository.this.findResourceFile(parent.getName(), oldName));
                    }
                }
                this.addFile(psiFile);
            }
            this.mySeenPrePropertyChange = false;
        }
    }

    private static class PsiValueResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final FolderConfiguration folderConfiguration;

        public PsiValueResourceQueueEntry(VirtualFile file, String qualifiers, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderConfiguration = folderConfiguration;
        }
    }

    private static class PsiFileResourceQueueEntry {
        public final VirtualFile file;
        public final String qualifiers;
        public final ResourceFolderType folderType;
        public final FolderConfiguration folderConfiguration;

        public PsiFileResourceQueueEntry(VirtualFile file, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration) {
            this.file = file;
            this.qualifiers = qualifiers;
            this.folderType = folderType;
            this.folderConfiguration = folderConfiguration;
        }
    }

    static class InitialScanState {
        int numXml;
        int numXmlReparsed;
        final ResourceMerger myResourceMerger;
        final ResourceSet myResourceSet;
        final ILogger myILogger;
        final File myResourceDir;
        final Collection<PsiFileResourceQueueEntry> myPsiFileResourceQueue = new ArrayList<PsiFileResourceQueueEntry>();
        final Collection<PsiValueResourceQueueEntry> myPsiValueResourceQueue = new ArrayList<PsiValueResourceQueueEntry>();

        public InitialScanState(ResourceMerger merger, File resourceDir) {
            this.myResourceMerger = merger;
            assert (this.myResourceMerger.getDataSets().size() == 1);
            this.myResourceSet = (ResourceSet)this.myResourceMerger.getDataSets().get(0);
            this.myResourceSet.setShouldParseResourceIds(true);
            this.myResourceSet.setDontNormalizeQualifiers(true);
            this.myResourceSet.setTrackSourcePositions(false);
            this.myILogger = new LogWrapper(LOG);
            this.myResourceDir = resourceDir;
        }

        public void countCacheHit() {
            ++this.numXml;
        }

        public void countCacheMiss() {
            ++this.numXml;
            ++this.numXmlReparsed;
        }

        @Nullable
        ResourceFile loadFile(File file) throws MergingException {
            return (ResourceFile)this.myResourceSet.loadFile(this.myResourceDir, file, this.myILogger);
        }

        public void queuePsiFileResourceScan(PsiFileResourceQueueEntry data) {
            this.myPsiFileResourceQueue.add(data);
        }

        public void queuePsiValueResourceScan(PsiValueResourceQueueEntry data) {
            this.myPsiValueResourceQueue.add(data);
        }
    }
}

