/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    private final String myExecutorId;
    private final int myRunConfigId;
    private final boolean myInstantRun;

    public AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor, int runConfigId, @NotNull String executorId, boolean instantRunEnabled) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/run/AndroidSessionInfo", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/run/AndroidSessionInfo", "<init>"));
        }
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/android/tools/idea/run/AndroidSessionInfo", "<init>"));
        }
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor;
        this.myRunConfigId = runConfigId;
        this.myExecutorId = executorId;
        this.myInstantRun = instantRunEnabled;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidSessionInfo", "getProcessHandler"));
        }
        return processHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        RunContentDescriptor runContentDescriptor = this.myDescriptor;
        if (runContentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidSessionInfo", "getDescriptor"));
        }
        return runContentDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        String string = this.myExecutorId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidSessionInfo", "getExecutorId"));
        }
        return string;
    }

    public boolean isInstantRun() {
        return this.myInstantRun;
    }

    @Nullable
    public List<IDevice> getDevices() {
        if (this.myProcessHandler instanceof AndroidProcessHandler) {
            return ((AndroidProcessHandler)this.myProcessHandler).getDevices();
        }
        Client client = (Client)this.myProcessHandler.getUserData(ANDROID_DEBUG_CLIENT);
        if (client != null) {
            return Collections.singletonList(client.getDevice());
        }
        return null;
    }

    public int getRunConfigurationId() {
        return this.myRunConfigId;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, int currentID) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/AndroidSessionInfo", "findOldSession"));
        }
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info;
            if (handler.isProcessTerminated() || handler.isProcessTerminating() || (info = (AndroidSessionInfo)handler.getUserData(KEY)) == null || currentID != info.getRunConfigurationId() || executor != null && !executor.getId().equals(info.getExecutorId())) continue;
            return info;
        }
        return null;
    }
}

