/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchableAndroidDevice
implements AndroidDevice {
    private static final Map<Abi, List<Abi>> ABI_MAPPINGS = ImmutableMap.of((Object)Abi.X86_64, (Object)ImmutableList.of((Object)Abi.X86_64, (Object)Abi.X86), (Object)Abi.ARM64_V8A, (Object)ImmutableList.of((Object)Abi.ARM64_V8A, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARMEABI));
    private final AvdInfo myAvdInfo;
    private final Object LOCK;
    private ListenableFuture<IDevice> myLaunchedEmulator;

    public LaunchableAndroidDevice(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/run/LaunchableAndroidDevice", "<init>"));
        }
        this.LOCK = new Object();
        this.myAvdInfo = avdInfo;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = this.myAvdInfo.getAndroidVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getVersion"));
        }
        return androidVersion;
    }

    @Override
    public int getDensity() {
        String s = (String)this.myAvdInfo.getProperties().get("hw.lcd.density");
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        Abi abi = Abi.getEnum((String)this.myAvdInfo.getAbiType());
        if (abi == null) {
            List<Abi> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getAbis"));
            }
            return list;
        }
        List<Abi> abis = ABI_MAPPINGS.get(abi);
        if (abis != null) {
            List<Abi> list = abis;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getAbis"));
            }
            return list;
        }
        List<Abi> list = Collections.singletonList(abi);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getAbis"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getSerial() {
        String string = this.myAvdInfo.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getSerial"));
        }
        return string;
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/android/tools/idea/run/LaunchableAndroidDevice", "supportsFeature"));
        }
        switch (feature) {
            case WATCH: {
                return SystemImage.WEAR_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case TV: {
                return SystemImage.TV_TAG.equals((Object)this.myAvdInfo.getTag());
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string = AvdManagerConnection.getAvdDisplayName(this.myAvdInfo);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getName"));
        }
        return string;
    }

    @Override
    public void renderName(@NotNull SimpleColoredComponent renderer, boolean isCompatible, @Nullable String searchPrefix) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/run/LaunchableAndroidDevice", "renderName"));
        }
        renderer.setIcon(AndroidIcons.Ddms.EmulatorDevice);
        SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        SearchUtil.appendFragments((String)searchPrefix, (String)this.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/LaunchableAndroidDevice", "launch"));
        }
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myLaunchedEmulator == null) {
            this.myLaunchedEmulator = AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(project, this.myAvdInfo);
        }
        ListenableFuture<IDevice> listenableFuture = this.myLaunchedEmulator;
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "launch"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myLaunchedEmulator == null) {
            throw new IllegalStateException("Attempt to get device corresponding to an emulator that hasn't been launched yet.");
        }
        ListenableFuture<IDevice> listenableFuture = this.myLaunchedEmulator;
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getLaunchedDevice"));
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSdkVersion", "com/android/tools/idea/run/LaunchableAndroidDevice", "canRun"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTarget", "com/android/tools/idea/run/LaunchableAndroidDevice", "canRun"));
        }
        if (requiredFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredFeatures", "com/android/tools/idea/run/LaunchableAndroidDevice", "canRun"));
        }
        LaunchCompatibility compatibility = LaunchCompatibility.YES;
        if (this.myAvdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            compatibility = AvdManagerConnection.isSystemImageDownloadProblem(this.myAvdInfo.getStatus()) ? new LaunchCompatibility(ThreeState.UNSURE, "Missing system image") : new LaunchCompatibility(ThreeState.NO, this.myAvdInfo.getErrorMessage());
        }
        LaunchCompatibility launchCompatibility = compatibility.combine(LaunchCompatibility.canRunOnDevice(minSdkVersion, projectTarget, requiredFeatures, supportedAbis, this));
        if (launchCompatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "canRun"));
        }
        return launchCompatibility;
    }

    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }
}

