/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.AndroidActivityLauncher;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActivityLaunchTask
implements LaunchTask {
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final StartActivityFlagsProvider myStartActivityFlagsProvider;

    public ActivityLaunchTask(@NotNull String applicationId, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "<init>"));
        }
        if (startActivityFlagsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startActivityFlagsProvider", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "<init>"));
        }
        this.myApplicationId = applicationId;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Launching activity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "getDescription"));
        }
        return "Launching activity";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/ActivityLaunchTask", "perform"));
        }
        String activityName = this.getQualifiedActivityName(device, printer);
        if (activityName == null) {
            return false;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(this.myApplicationId, activityName);
        String command = AndroidActivityLauncher.getStartActivityCommand(activityPath, this.myStartActivityFlagsProvider.getFlags(device));
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, 15L, TimeUnit.SECONDS);
    }

    @Nullable
    protected abstract String getQualifiedActivityName(@NotNull IDevice var1, @NotNull ConsolePrinter var2);
}

