/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandlerLaunchStatus
implements LaunchStatus {
    @NotNull
    private ProcessHandler myHandler;
    private boolean myTerminated;

    public ProcessHandlerLaunchStatus(@NotNull ProcessHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/run/util/ProcessHandlerLaunchStatus", "<init>"));
        }
        this.myHandler = handler;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/util/ProcessHandlerLaunchStatus", "getProcessHandler"));
        }
        return processHandler;
    }

    public void setProcessHandler(@NotNull ProcessHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/run/util/ProcessHandlerLaunchStatus", "setProcessHandler"));
        }
        this.myHandler = handler;
    }

    @Override
    public boolean isLaunchTerminated() {
        return this.myTerminated || this.myHandler.isProcessTerminated() || this.myHandler.isProcessTerminating();
    }

    @Override
    public void terminateLaunch(@Nullable String reason) {
        this.myTerminated = true;
        this.myHandler.notifyTextAvailable(reason + "\n", ProcessOutputTypes.STDERR);
        this.myHandler.destroyProcess();
    }
}

