/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchInstaller
extends AbstractInstaller
implements PatchOperation {
    private LocalPackage myExisting;
    private File myPatchFile;

    public PatchInstaller(@Nullable LocalPackage existing, @NotNull RemotePackage p, @NotNull Downloader downloader, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "<init>"));
        }
        if (downloader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "<init>"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "<init>"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "<init>"));
        }
        super(p, mgr, downloader, fop);
        this.myExisting = existing;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "doComplete"));
        }
        return PatchInstallerUtil.installPatch(this, this.myPatchFile, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File tempDir, @NotNull ProgressIndicator progress) {
        if (tempDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDir", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "doPrepare"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "doPrepare"));
        }
        LocalPackage local = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get(this.getPackage().getPath());
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        Archive.PatchType patch = archive.getPatch(local.getVersion());
        assert (patch != null);
        this.myPatchFile = this.downloadPatchFile(patch, tempDir, progress);
        if (this.myPatchFile == null) {
            progress.logWarning("Patch failed to download.");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @NotNull
    public LocalPackage getPatcher() {
        LocalPackage dependantPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        assert (dependantPatcher != null) : "Shouldn't be creating a PatchInstaller with no patcher";
        LocalPackage localPackage = dependantPatcher;
        if (localPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "getPatcher"));
        }
        return localPackage;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        throw new UnsupportedOperationException("PatchInstaller can't generate patches");
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        String string = this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "getNewVersionName"));
        }
        return string;
    }

    @Nullable
    private File downloadPatchFile(@NotNull Archive.PatchType patch, @NotNull File tempDir, @NotNull ProgressIndicator progress) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "downloadPatchFile"));
        }
        if (tempDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDir", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "downloadPatchFile"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/patch/PatchInstaller", "downloadPatchFile"));
        }
        URL url = InstallerUtil.resolveUrl((String)patch.getUrl(), (RemotePackage)this.getPackage(), (ProgressIndicator)progress);
        if (url == null) {
            progress.logWarning("Failed to resolve URL: " + patch.getUrl());
            return null;
        }
        try {
            File patchFile = new File(tempDir, "patch.jar");
            this.getDownloader().downloadFully(url, patchFile, patch.getChecksum(), progress);
            return patchFile;
        }
        catch (IOException e) {
            progress.logWarning("Error during downloading", (Throwable)e);
            return null;
        }
    }
}

