/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import org.jetbrains.annotations.NotNull;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (downloader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloader", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        LocalPackage local = (LocalPackage)mgr.getPackages().getLocalPackages().get(p.getPath());
        Archive archive = p.getArchive();
        assert (archive != null);
        if (local != null && archive.getPatch(local.getVersion()) != null) {
            PatchInstaller patchInstaller = new PatchInstaller(local, p, downloader, mgr, fop);
            if (patchInstaller == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
            }
            return patchInstaller;
        }
        FullInstaller fullInstaller = new FullInstaller(local, p, mgr, downloader, fop);
        if (fullInstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateInstaller"));
        }
        return fullInstaller;
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        if (fop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        PatchUninstaller patchUninstaller = new PatchUninstaller(p, mgr, fop);
        if (patchUninstaller == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "doCreateUninstaller"));
        }
        return patchUninstaller;
    }

    public static boolean canHandlePackage(@NotNull RepoPackage p, @NotNull AndroidSdkHandler handler) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "canHandlePackage"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory", "canHandlePackage"));
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        RepoManager mgr = handler.getSdkManager((ProgressIndicator)progress);
        if (p instanceof LocalPackage) {
            return PatchInstallerUtil.getLatestPatcher(mgr) != null;
        }
        LocalPackage patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, mgr);
        return patcher != null && PatchRunner.getPatchRunner(patcher, (ProgressIndicator)progress, handler.getFileOp()) != null;
    }
}

