/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FmUtil {
    public static String stripSuffix(String name, String suffix, boolean recursiveStrip) {
        if (name.length() < 2) {
            return name;
        }
        int suffixStart = name.lastIndexOf(suffix.charAt(0));
        if (suffixStart != -1 && name.regionMatches(suffixStart, suffix, 0, name.length() - suffixStart)) {
            name = name.substring(0, suffixStart);
        }
        if (recursiveStrip && name.endsWith(suffix)) {
            return FmUtil.stripSuffix(name, suffix, recursiveStrip);
        }
        return name;
    }

    @Nullable
    public static Module findModule(@NotNull String modulePath) {
        Project project;
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/android/tools/idea/templates/FmUtil", "findModule"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(modulePath.replace('/', File.separatorChar)));
        if (file != null && (project = ProjectLocator.getInstance().guessProjectForFile(file)) != null) {
            return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        }
        return null;
    }
}

