/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.google.common.base.Strings;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipLabel
extends JBLabel {
    private static final String PROPERTY_FOCUS_OWNER = "focusOwner";
    @Nullable
    private Component myRootComponent;

    public TooltipLabel() {
        final PropertyChangeListener focusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Component) {
                    Component component = (Component)evt.getNewValue();
                    TooltipLabel.super.setText(Strings.nullToEmpty((String)TooltipLabel.this.getTooltip(component)));
                }
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) == 0L) {
                    return;
                }
                if (TooltipLabel.this.isShowing()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(TooltipLabel.PROPERTY_FOCUS_OWNER, focusListener);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(TooltipLabel.PROPERTY_FOCUS_OWNER, focusListener);
                }
            }
        });
    }

    public void setText(String text) {
    }

    public void setScope(@Nullable Component rootComponent) {
        this.myRootComponent = rootComponent;
    }

    private boolean isInScope(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/ui/TooltipLabel", "isInScope"));
        }
        if (this.myRootComponent == null) {
            return true;
        }
        for (Component currComponent = component; currComponent != null; currComponent = currComponent.getParent()) {
            if (currComponent != this.myRootComponent) continue;
            return true;
        }
        return false;
    }

    @Nullable
    String getTooltip(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/ui/TooltipLabel", "getTooltip"));
        }
        if (!this.isInScope(component)) {
            return null;
        }
        String tooltip = null;
        for (Component currComponent = component; tooltip == null && currComponent != null; currComponent = currComponent.getParent()) {
            if (currComponent instanceof JComponent) {
                tooltip = ((JComponent)currComponent).getToolTipText();
            }
            if (currComponent == this.myRootComponent) break;
        }
        return tooltip;
    }
}

