/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.google.common.collect.Queues;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class BatchInvoker {
    public static final Strategy APPLICATION_INVOKE_LATER_STRATEGY = runnableBatch -> ApplicationManager.getApplication().invokeLater(runnableBatch, ModalityState.any());
    public static final Strategy SWING_INVOKE_LATER_STRATEGY = SwingUtilities::invokeLater;
    public static final Strategy INVOKE_IMMEDIATELY_STRATEGY = Runnable::run;
    private static final int MAX_CYCLE_COUNT = 10;
    private static Strategy ourOverrideStrategy = null;
    private final Strategy myStrategy;
    private final Queue<Runnable> myRunnables;
    private final Queue<Runnable> myDeferredRunnables;
    private boolean myUpdateInProgress;

    public BatchInvoker() {
        this(ourOverrideStrategy != null ? ourOverrideStrategy : (ApplicationManager.getApplication() != null ? APPLICATION_INVOKE_LATER_STRATEGY : SWING_INVOKE_LATER_STRATEGY));
    }

    public BatchInvoker(@NotNull Strategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/android/tools/idea/ui/properties/BatchInvoker", "<init>"));
        }
        this.myRunnables = Queues.newArrayDeque();
        this.myDeferredRunnables = Queues.newArrayDeque();
        this.myStrategy = strategy;
    }

    public void enqueue(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/ui/properties/BatchInvoker", "enqueue"));
        }
        if (this.myUpdateInProgress) {
            if (!this.myDeferredRunnables.contains(runnable)) {
                this.myDeferredRunnables.add(runnable);
            }
            return;
        }
        boolean shouldInvoke = this.myRunnables.isEmpty();
        if (!this.myRunnables.contains(runnable)) {
            this.myRunnables.add(runnable);
        }
        if (shouldInvoke) {
            this.enqueueInvoke();
        }
    }

    private void enqueueInvoke() {
        this.myStrategy.invoke(() -> {
            int cycleCount = 0;
            while (true) {
                this.myUpdateInProgress = true;
                for (Runnable runnable : this.myRunnables) {
                    runnable.run();
                }
                this.myRunnables.clear();
                this.myUpdateInProgress = false;
                if (this.myDeferredRunnables.isEmpty()) break;
                if (++cycleCount > 10) {
                    this.myDeferredRunnables.clear();
                    throw new InfiniteCycleException();
                }
                this.myRunnables.addAll(this.myDeferredRunnables);
                this.myDeferredRunnables.clear();
            }
        });
    }

    public static void setOverrideStrategy(Strategy overrideStrategy) {
        ourOverrideStrategy = overrideStrategy;
    }

    public static void clearOverrideStrategy() {
        ourOverrideStrategy = null;
    }

    public static final class InfiniteCycleException
    extends RuntimeException {
        public InfiniteCycleException() {
            super("Endless invocation cycle detected.");
        }
    }

    public static interface Strategy {
        public void invoke(@NotNull Runnable var1);
    }
}

