/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.adapters;

import com.android.tools.idea.ui.properties.AbstractProperty;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdapterProperty<S, D>
extends AbstractProperty<D>
implements InvalidationListener {
    @NotNull
    private final AbstractProperty<S> myWrappedProperty;
    private final BoolProperty myInSync;
    @NotNull
    private D myLastValue;
    private boolean myNeedsInitialSync;

    public AdapterProperty(@NotNull AbstractProperty<S> wrappedProperty, @NotNull D initialValue) {
        if (wrappedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedProperty", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "<init>"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "<init>"));
        }
        this.myInSync = new BoolValueProperty();
        this.myNeedsInitialSync = true;
        this.myLastValue = initialValue;
        this.myWrappedProperty = wrappedProperty;
        this.myWrappedProperty.addWeakListener(this);
    }

    @Override
    protected final void setDirectly(@NotNull D value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "setDirectly"));
        }
        this.myWrappedProperty.set(this.convertFromDestType(value));
    }

    @Override
    @NotNull
    public final D get() {
        this.doInitialSync();
        D d = this.myLastValue;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "get"));
        }
        return d;
    }

    @NotNull
    public ObservableBool inSync() {
        this.doInitialSync();
        BoolProperty boolProperty = this.myInSync;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "inSync"));
        }
        return boolProperty;
    }

    @Override
    public final void onInvalidated(@NotNull ObservableValue<?> sender) {
        if (sender == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/ui/properties/adapters/AdapterProperty", "onInvalidated"));
        }
        this.trySync();
        this.notifyInvalidated();
    }

    @Nullable
    protected abstract D convertFromSourceType(@NotNull S var1);

    @NotNull
    protected abstract S convertFromDestType(@NotNull D var1);

    private void doInitialSync() {
        if (this.myNeedsInitialSync) {
            this.trySync();
        }
    }

    private void trySync() {
        D result = this.convertFromSourceType(this.myWrappedProperty.get());
        this.myInSync.set(result != null);
        if (result != null) {
            this.myLastValue = result;
        }
        this.myNeedsInitialSync = false;
    }
}

