/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.ui.resourcechooser.ResourceEditorTab;
import com.android.tools.idea.ui.resourcechooser.SimpleTabUI;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditResourcePanel
extends JBScrollPane {
    private JPanel myFullPanel;
    private JTextField myResourceNameField;
    private JComboBox myVariantComboBox;
    private JBLabel myResourceNameMessage;
    private JTabbedPane myEditorTabs;
    @NotNull
    private List<ResourceItem> myVariants;
    @NotNull
    private final Map<Component, ResourceEditorTab> myAllTabs;

    public EditResourcePanel(@Nullable String resourceName) {
        this.$$$setupUI$$$();
        this.myVariants = Collections.emptyList();
        this.myAllTabs = new HashMap<Component, ResourceEditorTab>();
        Color notificationsBackgroundColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        this.myResourceNameMessage.setBackground((Color)(notificationsBackgroundColor == null ? JBColor.YELLOW : notificationsBackgroundColor));
        this.myEditorTabs.setUI(new SimpleTabUI());
        if (resourceName != null) {
            this.myResourceNameField.setText(resourceName);
        }
        this.setBorder(null);
        this.setViewportView(this.myFullPanel);
    }

    @NotNull
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension(this.getViewport().getView().getMinimumSize().width + insets.left + insets.right, super.getMinimumSize().height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getMinimumSize"));
        }
        return dimension;
    }

    public void setResourceName(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "setResourceName"));
        }
        this.myResourceNameField.setText(resourceName);
    }

    @NotNull
    public String getResourceName() {
        String string = this.myResourceNameField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public String getResourceNameMessage() {
        String string = this.myResourceNameMessage.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getResourceNameMessage"));
        }
        return string;
    }

    public void setResourceNameMessage(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "setResourceNameMessage"));
        }
        this.myResourceNameMessage.setText(message);
    }

    @NotNull
    public JTextField getResourceNameField() {
        JTextField jTextField = this.myResourceNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getResourceNameField"));
        }
        return jTextField;
    }

    public void addTab(@NotNull ResourceEditorTab panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "addTab"));
        }
        this.myAllTabs.put(panel.getFullPanel(), panel);
        this.myEditorTabs.addTab(panel.getTabTitle(), panel.getFullPanel());
    }

    @NotNull
    public ResourceEditorTab getSelectedTab() {
        ResourceEditorTab resourceEditorTab = this.myAllTabs.get(this.myEditorTabs.getSelectedComponent());
        if (resourceEditorTab == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getSelectedTab"));
        }
        return resourceEditorTab;
    }

    public void setSelectedTab(@NotNull ResourceEditorTab panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "setSelectedTab"));
        }
        this.myEditorTabs.setSelectedComponent(panel.getFullPanel());
    }

    public void addVariantActionListener(@NotNull ActionListener al) {
        if (al == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "al", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "addVariantActionListener"));
        }
        this.myVariantComboBox.addActionListener(al);
    }

    public void setVariant(@NotNull List<ResourceItem> resources, @Nullable ResourceItem defaultValue) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "setVariant"));
        }
        if (resources.size() > 1) {
            resources = Lists.newArrayList(resources);
            Collections.sort(resources, (element1, element2) -> {
                File directory1 = element1.getFile().getParentFile();
                File directory2 = element2.getFile().getParentFile();
                return directory1.getName().compareTo(directory2.getName());
            });
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            String defaultSelection = null;
            for (ResourceItem resource : resources) {
                String name = resource.getFile().getParentFile().getName();
                model.addElement(name);
                if (defaultSelection != null || resource != defaultValue) continue;
                defaultSelection = name;
            }
            model.setSelectedItem(defaultSelection);
            this.myVariantComboBox.setModel(model);
        }
        this.myVariants = resources;
        this.myVariantComboBox.setVisible(resources.size() > 1);
    }

    @NotNull
    public ResourceItem getSelectedVariant() {
        ResourceItem resourceItem = this.myVariants.size() > 1 ? this.myVariants.get(this.myVariantComboBox.getSelectedIndex()) : this.myVariants.get(0);
        if (resourceItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getSelectedVariant"));
        }
        return resourceItem;
    }

    public void setSelectedVariant(@NotNull ResourceItem selectedVariant) {
        if (selectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariant", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "setSelectedVariant"));
        }
        if (this.myVariants.size() == 1) {
            assert (this.myVariants.get(0) == selectedVariant);
        } else {
            ActionListener[] listeners;
            ComboBoxModel model = this.myVariantComboBox.getModel();
            for (ActionListener l : listeners = this.myVariantComboBox.getActionListeners()) {
                this.myVariantComboBox.removeActionListener(l);
            }
            model.setSelectedItem(model.getElementAt(this.myVariants.indexOf(selectedVariant)));
            for (ActionListener l : listeners) {
                this.myVariantComboBox.addActionListener(l);
            }
        }
    }

    @NotNull
    public Collection<ResourceEditorTab> getAllTabs() {
        Collection<ResourceEditorTab> collection = this.myAllTabs.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/EditResourcePanel", "getAllTabs"));
        }
        return collection;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTabbedPane jTabbedPane;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myFullPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVariantComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setVisible(false);
        jComboBox.setMaximumRowCount(15);
        jPanel.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 0, 1, null, new Dimension(10, -1), null));
        this.myResourceNameMessage = jBLabel = new JBLabel();
        jBLabel.setOpaque(true);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myEditorTabs = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(2, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myFullPanel;
    }
}

