/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.resources.FrameworkResources;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResourceChooserGroup {
    @NotNull
    private final List<ResourceChooserItem> myItems;
    @NotNull
    private final String myLabel;
    @NotNull
    private final ResourceType myType;
    public static final boolean FILTER_OUT_PRIVATE = true;

    public ResourceChooserGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, boolean framework, boolean includeFileResources) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        this.myItems = new ArrayList<ResourceChooserItem>();
        assert (type != ResourceType.MIPMAP);
        this.myType = type;
        this.myLabel = label;
        if (framework) {
            FrameworkResources frameworkResources;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet.getModule());
            if (androidPlatform == null) {
                return;
            }
            AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
            try {
                frameworkResources = targetData.getFrameworkResources(type == ResourceType.STRING);
                if (frameworkResources == null) {
                    return;
                }
            }
            catch (IOException ignore) {
                return;
            }
            this.addFrameworkItems(type, includeFileResources, frameworkResources);
            if (type == ResourceType.DRAWABLE) {
                this.addFrameworkItems(ResourceType.MIPMAP, includeFileResources, frameworkResources);
            }
        } else {
            AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
            ResourceVisibilityLookup lookup = repository.getResourceVisibility(facet);
            this.addProjectItems(type, includeFileResources, repository, lookup);
            if (type == ResourceType.DRAWABLE) {
                this.addProjectItems(ResourceType.MIPMAP, includeFileResources, repository, lookup);
            }
        }
        this.sortItems();
    }

    public ResourceChooserGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet, @NotNull Collection<String> attrs) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "<init>"));
        }
        this.myItems = new ArrayList<ResourceChooserItem>();
        this.myType = type;
        this.myLabel = label;
        AppResourceRepository repository = AppResourceRepository.getAppResources(facet, true);
        ResourceVisibilityLookup lookup = repository.getResourceVisibility(facet);
        for (String name : attrs) {
            String simpleName;
            boolean framework = name.startsWith("android:");
            String string = simpleName = framework ? ResolutionUtils.getNameFromQualifiedName(name) : name;
            if (!framework && lookup != null && lookup.isPrivate(ResourceType.ATTR, simpleName)) continue;
            this.myItems.add(new ResourceChooserItem.AttrItem(this.myType, framework, simpleName));
        }
        this.sortItems();
    }

    private void addFrameworkItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull FrameworkResources frameworkResources) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "addFrameworkItems"));
        }
        if (frameworkResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkResources", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "addFrameworkItems"));
        }
        List items = frameworkResources.getResourceItemsOfType(type);
        for (ResourceItem item : items) {
            List sourceFileList;
            if (!includeFileResources && !(sourceFileList = item.getSourceFileList()).isEmpty() && !((ResourceFile)sourceFileList.get(0)).getFolder().getFolder().getName().startsWith("values")) continue;
            this.myItems.add(new ResourceChooserItem.FrameworkItem(this.myType, item.getName(), item));
        }
    }

    private void addProjectItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull AppResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "addProjectItems"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "addProjectItems"));
        }
        for (String resourceName : repository.getItemsOfType(type)) {
            List items;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items = repository.getResourceItem(type, resourceName)) == null || items.isEmpty() || !includeFileResources && ((com.android.ide.common.res2.ResourceItem)items.get(0)).getSourceType() != DataFile.FileType.XML_VALUES) continue;
            this.myItems.add(new ResourceChooserItem.ProjectItem(type, resourceName, items));
        }
    }

    private void sortItems() {
        Collections.sort(this.myItems, (resource1, resource2) -> {
            int framework2;
            int framework1 = resource1.isFramework() ? 1 : 0;
            int delta = framework1 - (framework2 = resource2.isFramework() ? 1 : 0);
            if (delta != 0) {
                return delta;
            }
            return resource1.getName().compareTo(resource2.getName());
        });
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "getType"));
        }
        return resourceType;
    }

    @NotNull
    public List<ResourceChooserItem> getItems() {
        List<ResourceChooserItem> list = this.myItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ResourceChooserGroup", "getItems"));
        }
        return list;
    }

    public String toString() {
        return this.myLabel;
    }

    public boolean isEmpty() {
        return this.getItems().isEmpty();
    }
}

