/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.google.common.collect.Lists;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGrid<T>
extends Box {
    @NotNull
    private final ArrayList<JList<T>> myLists;
    @NotNull
    private final ArrayList<HideableDecorator> myHideables;
    private boolean myFiltered;

    public TreeGrid(final @NotNull AbstractTreeStructure model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "<init>"));
        }
        super(1);
        Object root = model.getRootElement();
        Object[] sections = model.getChildElements(root);
        this.myLists = Lists.newArrayListWithCapacity((int)sections.length);
        this.myHideables = Lists.newArrayListWithCapacity((int)sections.length);
        ListSelectionListener listSelectionListener = e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel sourceSelectionModel = (ListSelectionModel)e.getSource();
            if (!sourceSelectionModel.isSelectionEmpty()) {
                for (JList<T> aList : this.myLists) {
                    if (sourceSelectionModel == aList.getSelectionModel()) continue;
                    aList.clearSelection();
                }
            }
        };
        for (final Object section : sections) {
            JPanel panel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
                }
            };
            String name = section.toString();
            HideableDecorator hidyPanel = new HideableDecorator(panel, name, false);
            FilteringListModel listModel = new FilteringListModel((ListModel)new AbstractListModel(){

                @Override
                public int getSize() {
                    return model.getChildElements(section).length;
                }

                @Override
                public Object getElementAt(int index) {
                    return model.getChildElements(section)[index];
                }
            });
            listModel.refilter();
            JList list = new JList(listModel);
            list.setSelectionMode(0);
            list.setVisibleRowCount(-1);
            list.getSelectionModel().addListSelectionListener(listSelectionListener);
            list.setName(name);
            list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    block4: {
                        int selectedIndex;
                        JList list;
                        int keyCode;
                        block5: {
                            Object source;
                            keyCode = e.getKeyCode();
                            if (keyCode != 40 && keyCode != 38 || !((source = e.getSource()) instanceof JList)) break block4;
                            list = (JList)source;
                            selectedIndex = list.getSelectedIndex();
                            if (keyCode != 40) break block5;
                            int size = list.getModel().getSize();
                            if (selectedIndex != size - 1) break block4;
                            for (int index = ContainerUtil.indexOf((List)TreeGrid.this.myLists, (Object)list) + 1; index != 0 && index < TreeGrid.this.myLists.size(); ++index) {
                                JList nextList = (JList)TreeGrid.this.myLists.get(index);
                                if (nextList.getModel().getSize() <= 0) continue;
                                list.clearSelection();
                                nextList.setSelectedIndex(0);
                                TreeGrid.this.ensureIndexVisible(nextList, 0);
                                nextList.requestFocus();
                                e.consume();
                                break block4;
                            }
                            break block4;
                        }
                        assert (keyCode == 38) : keyCode;
                        if (selectedIndex == 0) {
                            for (int index = ContainerUtil.indexOf((List)TreeGrid.this.myLists, (Object)list) - 1; index >= 0; --index) {
                                JList prevList = (JList)TreeGrid.this.myLists.get(index);
                                int count = prevList.getModel().getSize();
                                if (count <= 0) continue;
                                list.clearSelection();
                                prevList.setSelectedIndex(count - 1);
                                TreeGrid.this.ensureIndexVisible(prevList, count - 1);
                                prevList.requestFocus();
                                e.consume();
                                break;
                            }
                        }
                    }
                }
            });
            new ListSpeedSearch(list);
            this.myLists.add(list);
            this.myHideables.add(hidyPanel);
            hidyPanel.setContentComponent(list);
            this.add(panel);
        }
    }

    public void addListSelectionListener(@NotNull ListSelectionListener lsl) {
        if (lsl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lsl", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "addListSelectionListener"));
        }
        for (JList<T> list : this.myLists) {
            list.getSelectionModel().addListSelectionListener(lsl);
        }
    }

    public void setCellRenderer(@NotNull ListCellRenderer<T> cellRenderer) {
        if (cellRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellRenderer", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "setCellRenderer"));
        }
        for (JList<T> list : this.myLists) {
            list.setCellRenderer(cellRenderer);
        }
    }

    public void setFixedCellWidth(int width) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellWidth(width);
        }
    }

    public void setFixedCellHeight(int height) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellHeight(height);
        }
    }

    public void expandAll() {
        for (HideableDecorator hidyPanel : this.myHideables) {
            hidyPanel.setOn(true);
        }
    }

    @Nullable
    public T getSelectedElement() {
        for (JList<T> list : this.myLists) {
            if (list.getSelectedIndex() <= -1) continue;
            return list.getSelectedValue();
        }
        return null;
    }

    public void setSelectedElement(@Nullable T selectedElement) {
        for (JList<T> list : this.myLists) {
            if (selectedElement == null) {
                list.clearSelection();
                continue;
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (list.getModel().getElementAt(i) != selectedElement) continue;
                list.setSelectedIndex(i);
                this.ensureIndexVisible(list, i);
                return;
            }
        }
    }

    private void ensureIndexVisible(@NotNull JList<T> list, int index) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "ensureIndexVisible"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "lambda$ensureIndexVisible$1"));
            }
            Rectangle cellBounds = list.getCellBounds(index, index);
            if (cellBounds != null) {
                list.getBounds();
                Rectangle rectangle = SwingUtilities.convertRectangle(list, cellBounds, this);
                this.scrollRectToVisible(rectangle);
            }
        }, ModalityState.any());
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "addMouseListener"));
        }
        for (JList<T> list : this.myLists) {
            list.addMouseListener(l);
        }
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/android/tools/idea/ui/resourcechooser/TreeGrid", "removeMouseListener"));
        }
        for (JList<T> list : this.myLists) {
            list.removeMouseListener(l);
        }
    }

    public void setLayoutOrientation(int mode) {
        for (JList<T> list : this.myLists) {
            list.setLayoutOrientation(mode);
        }
    }

    public void setFilter(@Nullable Condition<T> condition) {
        this.myFiltered = condition != null;
        for (JList<T> list : this.myLists) {
            ((FilteringListModel)list.getModel()).setFilter(condition);
        }
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public void selectIfUnique() {
        T single = this.findSingleItem();
        if (single != null) {
            this.setSelectedElement(single);
        }
    }

    @Nullable
    private T findSingleItem() {
        T singleMatch = null;
        boolean found = false;
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size == 1) {
                if (found) {
                    return null;
                }
                found = true;
                singleMatch = model.getElementAt(0);
                continue;
            }
            if (size <= 1) continue;
            return null;
        }
        return singleMatch;
    }

    void selectFirst() {
        for (JList<T> list : this.myLists) {
            ListModel<T> model = list.getModel();
            int size = model.getSize();
            if (size <= 0) continue;
            T item = model.getElementAt(0);
            this.setSelectedElement(item);
            list.requestFocus();
            this.ensureIndexVisible(list, 0);
            return;
        }
    }
}

