/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.tools.idea.ui.wizard.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioWizardDialogBuilder {
    private static final Dimension DEFAULT_MIN_SIZE = JBUI.size((int)800, (int)650);
    private static final float SCREEN_PERCENT = 0.8f;
    @NotNull
    ModelWizard myWizard;
    @NotNull
    String myTitle;
    @Nullable
    Component myParent;
    @Nullable
    Project myProject;
    @Nullable
    URL myHelpUrl;
    @NotNull
    DialogWrapper.IdeModalityType myModalityType;
    @NotNull
    Dimension myMinimumSize;
    @NotNull
    ModelWizardDialog.CancellationPolicy myCancellationPolicy;

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        this.myModalityType = DialogWrapper.IdeModalityType.IDE;
        this.myMinimumSize = DEFAULT_MIN_SIZE;
        this.myCancellationPolicy = ModelWizardDialog.CancellationPolicy.ALWAYS_CAN_CANCEL;
        this.myWizard = wizard;
        this.myTitle = title;
    }

    public StudioWizardDialogBuilder(@NotNull ModelWizardStep step, @NotNull String title) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        this(new ModelWizard.Builder(step).build(), title);
    }

    public StudioWizardDialogBuilder(@NotNull ModelWizard wizard, @NotNull String title, @Nullable Component parent) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "<init>"));
        }
        this(wizard, title);
        this.myParent = parent;
    }

    @NotNull
    public StudioWizardDialogBuilder setProject(@Nullable Project project) {
        if (project != null) {
            this.myProject = project;
        }
        StudioWizardDialogBuilder studioWizardDialogBuilder = this;
        if (studioWizardDialogBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setProject"));
        }
        return studioWizardDialogBuilder;
    }

    @NotNull
    public StudioWizardDialogBuilder setModalityType(@Nullable DialogWrapper.IdeModalityType modalityType) {
        if (modalityType != null) {
            this.myModalityType = modalityType;
        }
        StudioWizardDialogBuilder studioWizardDialogBuilder = this;
        if (studioWizardDialogBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setModalityType"));
        }
        return studioWizardDialogBuilder;
    }

    @NotNull
    public StudioWizardDialogBuilder setMinimumSize(@Nullable Dimension minimumSize) {
        if (minimumSize != null) {
            this.myMinimumSize = minimumSize;
        }
        StudioWizardDialogBuilder studioWizardDialogBuilder = this;
        if (studioWizardDialogBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setMinimumSize"));
        }
        return studioWizardDialogBuilder;
    }

    @NotNull
    public StudioWizardDialogBuilder setHelpUrl(@Nullable URL helpUrl) {
        if (helpUrl != null) {
            this.myHelpUrl = helpUrl;
        }
        StudioWizardDialogBuilder studioWizardDialogBuilder = this;
        if (studioWizardDialogBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setHelpUrl"));
        }
        return studioWizardDialogBuilder;
    }

    @NotNull
    public StudioWizardDialogBuilder setCancellationPolicy(@Nullable ModelWizardDialog.CancellationPolicy cancellationPolicy) {
        if (cancellationPolicy != null) {
            this.myCancellationPolicy = cancellationPolicy;
        }
        StudioWizardDialogBuilder studioWizardDialogBuilder = this;
        if (studioWizardDialogBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "setCancellationPolicy"));
        }
        return studioWizardDialogBuilder;
    }

    @NotNull
    public ModelWizardDialog build() {
        StudioWizardLayout customLayout = new StudioWizardLayout();
        ModelWizardDialog dialog = this.myParent != null ? new ModelWizardDialog(this.myWizard, this.myTitle, this.myParent, customLayout, this.myHelpUrl, this.myCancellationPolicy) : new ModelWizardDialog(this.myWizard, this.myTitle, customLayout, this.myProject, this.myHelpUrl, this.myModalityType, this.myCancellationPolicy);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension clampedSize = new Dimension(Math.min(this.myMinimumSize.width, (int)((float)screenSize.width * 0.8f)), Math.min(this.myMinimumSize.height, (int)((float)screenSize.height * 0.8f)));
        dialog.setSize(clampedSize.width, clampedSize.height);
        ModelWizardDialog modelWizardDialog = dialog;
        if (modelWizardDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/wizard/StudioWizardDialogBuilder", "build"));
        }
        return modelWizardDialog;
    }
}

