/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.rendering.SaveScreenshotAction;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutAction;
import com.android.tools.idea.uibuilder.actions.DeselectAllAction;
import com.android.tools.idea.uibuilder.actions.GotoComponentAction;
import com.android.tools.idea.uibuilder.actions.SelectAllAction;
import com.android.tools.idea.uibuilder.actions.SelectParentAction;
import com.android.tools.idea.uibuilder.actions.SelectSameTypeAction;
import com.android.tools.idea.uibuilder.actions.SelectSiblingsAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewActionGroup;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.editor.NlActionsToolbar;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.InteractionManager;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlActionManager {
    private final DesignSurface mySurface;
    private AnAction mySelectAllAction;
    private AnAction mySelectParent;
    private GotoComponentAction myGotoComponentAction;

    public NlActionManager(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/editor/NlActionManager", "<init>"));
        }
        this.mySurface = surface;
    }

    public void registerActions(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager", "registerActions"));
        }
        assert (this.mySelectAllAction == null);
        this.mySelectAllAction = new SelectAllAction(this.mySurface);
        NlActionManager.registerAction(this.mySelectAllAction, "$SelectAll", component);
        this.myGotoComponentAction = new GotoComponentAction(this.mySurface);
        NlActionManager.registerAction(this.myGotoComponentAction, "GotoDeclaration", component);
        this.mySelectParent = new SelectParentAction(this.mySurface);
        this.mySelectParent.registerCustomShortcutSet(27, 0, component);
    }

    private static void registerAction(@NotNull AnAction action, @NonNls String actionId, @NotNull JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/editor/NlActionManager", "registerAction"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager", "registerAction"));
        }
        action.registerCustomShortcutSet(ActionManager.getInstance().getAction(actionId).getShortcutSet(), component);
    }

    @NotNull
    public JComponent createToolbar(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createToolbar"));
        }
        NlActionsToolbar actionsToolbar = new NlActionsToolbar(this.mySurface);
        actionsToolbar.setModel(model);
        JComponent jComponent = actionsToolbar.getToolbarComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createToolbar"));
        }
        return jComponent;
    }

    @NotNull
    private static ActionGroup createRefactoringMenu() {
        DefaultActionGroup group = new DefaultActionGroup("_Refactor", true);
        ActionManager manager = ActionManager.getInstance();
        AnAction action = manager.getAction("AndroidExtractStyleAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Extract Style...", action));
        action = manager.getAction("AndroidInlineStyleReferenceAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("_Inline Style...", action));
        action = manager.getAction("AndroidExtractAsIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("E_xtract Layout...", action));
        action = manager.getAction("AndroidInlineIncludeAction");
        group.add((AnAction)new AndroidRefactoringActionWrapper("I_nline Layout...", action));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createRefactoringMenu"));
        }
        return defaultActionGroup;
    }

    public void showPopup(@NotNull MouseEvent event) {
        int y;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/editor/NlActionManager", "showPopup"));
        }
        NlComponent component = null;
        int x = event.getX();
        ScreenView screenView = this.mySurface.getScreenView(x, y = event.getY());
        if (screenView == null) {
            screenView = this.mySurface.getCurrentScreenView();
        }
        if (screenView != null) {
            component = Coordinates.findComponent(screenView, x, y);
        }
        this.showPopup(event, screenView, component);
    }

    public void showPopup(@NotNull MouseEvent event, @Nullable ScreenView screenView, @Nullable NlComponent leafComponent) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/editor/NlActionManager", "showPopup"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = this.createPopupMenu(actionManager, screenView, leafComponent);
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("LayoutEditor", (ActionGroup)group);
        Component invoker = event.getSource() instanceof Component ? (Component)event.getSource() : this.mySurface;
        popupMenu.getComponent().show(invoker, event.getX(), event.getY());
    }

    @NotNull
    private DefaultActionGroup createPopupMenu(@NotNull ActionManager actionManager, @Nullable ScreenView screenView, @Nullable NlComponent leafComponent) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createPopupMenu"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (screenView != null) {
            if (leafComponent != null) {
                this.addViewHandlerActions(group, leafComponent, screenView.getSelectionModel().getSelection());
            }
            group.add((AnAction)this.createSelectActionGroup(screenView.getSelectionModel()));
            group.addSeparator();
        }
        group.add(actionManager.getAction("$Cut"));
        group.add(actionManager.getAction("$Copy"));
        group.add(actionManager.getAction("$Paste"));
        group.addSeparator();
        group.add(actionManager.getAction("$Delete"));
        group.addSeparator();
        group.add((AnAction)this.myGotoComponentAction);
        group.add((AnAction)NlActionManager.createRefactoringMenu());
        group.add((AnAction)new SaveScreenshotAction(this.mySurface));
        group.addSeparator();
        group.add((AnAction)new ConvertToConstraintLayoutAction(this.mySurface));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createPopupMenu"));
        }
        return defaultActionGroup;
    }

    private void addViewHandlerActions(@NotNull DefaultActionGroup group, @NotNull NlComponent component, @NotNull List<NlComponent> selection) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewHandlerActions"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewHandlerActions"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewHandlerActions"));
        }
        int prevCount = group.getChildrenCount();
        NlComponent parent = !component.isRoot() ? component.getParent() : null;
        this.addViewActions(group, component, parent, selection, false);
        if (group.getChildrenCount() > prevCount) {
            group.addSeparator();
        }
    }

    @NotNull
    private ActionGroup createSelectActionGroup(@NotNull SelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createSelectActionGroup"));
        }
        DefaultActionGroup group = new DefaultActionGroup("_Select", true);
        SelectSiblingsAction selectSiblings = new SelectSiblingsAction(model);
        SelectSameTypeAction selectSameType = new SelectSameTypeAction(model);
        DeselectAllAction deselectAllAction = new DeselectAllAction(model);
        group.add(this.mySelectParent);
        group.add((AnAction)selectSiblings);
        group.add((AnAction)selectSameType);
        group.addSeparator();
        group.add(this.mySelectAllAction);
        group.add((AnAction)deselectAllAction);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createSelectActionGroup"));
        }
        return defaultActionGroup;
    }

    public void addViewActions(@NotNull DefaultActionGroup group, @Nullable NlComponent component, @Nullable NlComponent parent, @NotNull List<NlComponent> newSelection, boolean toolbar) {
        ViewHandler handler;
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActions"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActions"));
        }
        ScreenView screenView = this.mySurface.getCurrentScreenView();
        if (screenView == null || parent == null && component == null) {
            return;
        }
        ViewEditorImpl editor = new ViewEditorImpl(screenView);
        if (component != null) {
            handler = ViewHandlerManager.get(this.mySurface.getProject()).getHandler(component);
            this.addViewActionsForHandler(group, component, newSelection, editor, handler, toolbar);
        }
        if (parent != null) {
            handler = ViewHandlerManager.get(this.mySurface.getProject()).getHandler(parent);
            ArrayList selectedChildren = Lists.newArrayListWithCapacity((int)newSelection.size());
            for (NlComponent selected : newSelection) {
                if (selected.getParent() != parent) continue;
                selectedChildren.add(selected);
            }
            this.addViewActionsForHandler(group, parent, selectedChildren, editor, handler, toolbar);
        }
    }

    private void addViewActionsForHandler(@NotNull DefaultActionGroup group, @NotNull NlComponent component, @NotNull List<NlComponent> newSelection, @NotNull ViewEditor editor, @Nullable ViewHandler handler, boolean toolbar) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActionsForHandler"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActionsForHandler"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActionsForHandler"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addViewActionsForHandler"));
        }
        if (handler == null) {
            return;
        }
        List<ViewAction> viewActions = NlActionManager.createViewActionList();
        if (toolbar) {
            viewActions.addAll(ViewHandlerManager.get(this.mySurface.getProject()).getToolbarActions(handler));
        } else {
            viewActions.addAll(ViewHandlerManager.get(this.mySurface.getProject()).getPopupMenuActions(handler));
        }
        Collections.sort(viewActions);
        group.removeAll();
        ArrayList target = Lists.newArrayList();
        NlActionManager actionManager = this.mySurface.getActionManager();
        for (ViewAction viewAction : viewActions) {
            actionManager.addActions(target, toolbar, viewAction, this.mySurface.getProject(), editor, handler, component, newSelection);
        }
        boolean lastWasSeparator = false;
        for (AnAction action : target) {
            boolean isSeparator = action instanceof Separator;
            if (isSeparator && lastWasSeparator) continue;
            group.add(action);
            lastWasSeparator = isSeparator;
        }
    }

    @NotNull
    private static List<ViewAction> createViewActionList() {
        ArrayList<ViewAction> arrayList = new ArrayList<ViewAction>(){

            @Override
            public boolean add(ViewAction viewAction) {
                if (!this.isEmpty()) {
                    ViewAction prev = (ViewAction)this.get(this.size() - 1);
                    if (viewAction.getRank() == prev.getRank() || viewAction.getRank() == -1) {
                        viewAction.setRank(prev.getRank() + 5);
                    }
                } else if (viewAction.getRank() == -1) {
                    viewAction.setRank(0);
                }
                return super.add(viewAction);
            }
        };
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager", "createViewActionList"));
        }
        return arrayList;
    }

    void addActions(@NotNull List<AnAction> target, boolean toolbar, @NotNull ViewAction viewAction, @NotNull Project project, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent parent, @NotNull List<NlComponent> newSelection) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (viewAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewAction", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/editor/NlActionManager", "addActions"));
        }
        if (viewAction instanceof DirectViewAction) {
            target.add(new DirectViewActionWrapper(project, (DirectViewAction)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof ViewActionSeparator) {
            target.add((AnAction)Separator.getInstance());
        } else if (viewAction instanceof ToggleViewAction) {
            target.add((AnAction)new ToggleViewActionWrapper(project, (ToggleViewAction)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof ToggleViewActionGroup) {
            ArrayList actions = Lists.newArrayList();
            for (ToggleViewAction action : ((ToggleViewActionGroup)viewAction).getActions()) {
                actions.add(new ToggleViewActionWrapper(project, action, editor, handler, parent, newSelection));
            }
            if (!actions.isEmpty()) {
                ToggleViewActionWrapper prev = null;
                for (ToggleViewActionWrapper action : actions) {
                    target.add((AnAction)action);
                    if (prev != null) {
                        prev.myGroupSibling = action;
                    }
                    prev = action;
                }
                if (prev != null) {
                    prev.myGroupSibling = (ToggleViewActionWrapper)actions.get(0);
                }
            }
        } else if (viewAction instanceof ViewActionMenu) {
            target.add((AnAction)new ViewActionMenuWrapper((ViewActionMenu)viewAction, editor, handler, parent, newSelection));
        } else if (viewAction instanceof NestedViewActionMenu) {
            if (toolbar) {
                target.add(new ViewActionToolbarMenuWrapper((NestedViewActionMenu)viewAction, editor, handler, parent, newSelection));
            }
        } else {
            throw new UnsupportedOperationException(viewAction.getClass().getName());
        }
    }

    private class ViewActionToolbarMenuWrapper
    extends FlatComboAction
    implements ViewActionPresentation {
        private final NestedViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public ViewActionToolbarMenuWrapper(@NotNull NestedViewActionMenu action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "<init>"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "<init>"));
            }
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setDescription(action.getLabel());
        }

        @Override
        public void update(AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        @NotNull
        protected DefaultActionGroup createPopupActionGroup() {
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                ArrayList actions = Lists.newArrayList();
                for (ViewAction viewAction : rows.get(0)) {
                    NlActionManager.this.addActions(actions, false, viewAction, NlActionManager.this.mySurface.getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup((List)actions);
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        @Override
        protected JBPopup createPopup(@Nullable Runnable onDispose, @Nullable DataContext context) {
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                return super.createPopup(onDispose, context);
            }
            ActionManager actionManager = ActionManager.getInstance();
            JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
            for (List<ViewAction> row : rows) {
                if (row.size() == 1 && row.get(0) instanceof ViewActionSeparator) {
                    panel.add(new JSeparator());
                    continue;
                }
                ArrayList actions = Lists.newArrayList();
                for (ViewAction viewAction : row) {
                    NlActionManager.this.addActions(actions, false, viewAction, NlActionManager.this.mySurface.getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                DefaultActionGroup group = new DefaultActionGroup((List)actions);
                ActionToolbar toolbar = actionManager.createActionToolbar("DynamicToolbar", (ActionGroup)group, true);
                panel.add(toolbar.getComponent());
            }
            return JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)panel).setRequestFocus(true).setCancelOnClickOutside(true).setLocateWithinScreenBounds(true).setShowShadow(true).setCancelOnWindowDeactivation(true).setCancelCallback(() -> {
                if (onDispose != null) {
                    onDispose.run();
                }
                return Boolean.TRUE;
            }).createPopup();
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionToolbarMenuWrapper", "setLabel"));
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }
    }

    private class ViewActionMenuWrapper
    extends ActionGroup
    implements ViewActionPresentation {
        private final ViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public ViewActionMenuWrapper(@NotNull ViewActionMenu action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "<init>"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "<init>"));
            }
            super(action.getLabel(), true);
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setText(action.getLabel());
        }

        public void update(AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "setLabel"));
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList actions = Lists.newArrayList();
            for (ViewAction viewAction : this.myAction.getActions()) {
                NlActionManager.this.addActions(actions, false, viewAction, NlActionManager.this.mySurface.getProject(), this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            }
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/editor/NlActionManager$ViewActionMenuWrapper", "getChildren"));
            }
            return anActionArray;
        }
    }

    private class ToggleViewActionWrapper
    extends ToggleAction
    implements ViewActionPresentation {
        private final Project myProject;
        private final ToggleViewAction myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;
        private ToggleViewActionWrapper myGroupSibling;

        public ToggleViewActionWrapper(@NotNull Project project, @NotNull ToggleViewAction action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "<init>"));
            }
            this.myProject = project;
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(action.getUnselectedLabel());
            presentation.setIcon(action.getUnselectedIcon());
            presentation.setSelectedIcon(action.getSelectedIcon());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
        }

        public void setSelected(AnActionEvent e, final boolean state) {
            String description = e.getPresentation().getText();
            PsiFile file = this.myComponent.getTag().getContainingFile();
            if (this.myAction.affectsUndo()) {
                new WriteCommandAction<Void>(this.myProject, description, null, new PsiFile[]{file}){

                    protected void run(@NotNull Result<Void> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper$1", "run"));
                        }
                        ToggleViewActionWrapper.this.applySelection(state);
                    }
                }.execute();
            } else {
                try {
                    this.applySelection(state);
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
        }

        private void applySelection(boolean state) {
            this.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, state);
            if (state) {
                ToggleViewActionWrapper groupSibling = this.myGroupSibling;
                while (groupSibling != null && groupSibling != this) {
                    groupSibling.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, false);
                    groupSibling = groupSibling.myGroupSibling;
                }
            }
            NlActionManager.this.mySurface.repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "update"));
            }
            this.myCurrentPresentation = e.getPresentation();
            try {
                boolean selected = this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                if (this.myAction.getSelectedLabel() != null) {
                    this.myCurrentPresentation.setText(selected ? this.myAction.getSelectedLabel() : this.myAction.getUnselectedLabel());
                }
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers(), selected);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/uibuilder/editor/NlActionManager$ToggleViewActionWrapper", "setLabel"));
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }
    }

    private class DirectViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final Project myProject;
        private final DirectViewAction myAction;
        private final ViewHandler myHandler;
        private final ViewEditor myEditor;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        public DirectViewActionWrapper(@NotNull Project project, @NotNull DirectViewAction action, @NotNull ViewEditor editor, @NotNull ViewHandler handler, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            if (selectedChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedChildren", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "<init>"));
            }
            this.myProject = project;
            this.myAction = action;
            this.myEditor = editor;
            this.myHandler = handler;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action.getDefaultIcon());
            presentation.setText(action.getLabel());
        }

        public void actionPerformed(final AnActionEvent e) {
            String description = e.getPresentation().getText();
            PsiFile file = this.myComponent.getTag().getContainingFile();
            if (this.myAction.affectsUndo()) {
                new WriteCommandAction<Void>(this.myProject, description, null, new PsiFile[]{file}){

                    protected void run(@NotNull Result<Void> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper$1", "run"));
                        }
                        DirectViewActionWrapper.this.myAction.perform(DirectViewActionWrapper.this.myEditor, DirectViewActionWrapper.this.myHandler, DirectViewActionWrapper.this.myComponent, DirectViewActionWrapper.this.mySelectedChildren, e.getModifiers());
                    }
                }.execute();
            } else {
                try {
                    this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
            NlActionManager.this.mySurface.repaint();
        }

        public void update(AnActionEvent e) {
            int modifiers = InteractionManager.getLastModifiers();
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, modifiers);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/uibuilder/editor/NlActionManager$DirectViewActionWrapper", "setLabel"));
            }
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon) {
            this.myCurrentPresentation.setIcon(icon);
        }
    }

    private static class AndroidRefactoringActionWrapper
    extends AnAction {
        private final AnAction myRefactoringAction;

        public AndroidRefactoringActionWrapper(@NotNull String text, @NotNull AnAction refactoringAction) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/uibuilder/editor/NlActionManager$AndroidRefactoringActionWrapper", "<init>"));
            }
            if (refactoringAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoringAction", "com/android/tools/idea/uibuilder/editor/NlActionManager$AndroidRefactoringActionWrapper", "<init>"));
            }
            super(text, null, null);
            this.myRefactoringAction = refactoringAction;
            this.getTemplatePresentation().setDescription(refactoringAction.getTemplatePresentation().getDescription());
        }

        public void actionPerformed(AnActionEvent e) {
            this.myRefactoringAction.actionPerformed(e);
        }

        public void update(AnActionEvent e) {
            this.myRefactoringAction.update(e);
            Presentation p = e.getPresentation();
            if (!p.isVisible()) {
                p.setEnabled(false);
                p.setVisible(true);
            }
        }
    }
}

