/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SingleWidgetView
extends JPanel {
    WidgetConstraintPanel mWidgetConstraintPanel;
    public static final int ANY = 1;
    public static final int WRAP_CONTENT = 2;
    public static final int FIXED = 0;
    public static final int UNCONNECTED = -1;
    private final ColorSet mColorSet;
    private int mCacheBottom;
    private int mCacheTop;
    private int mCacheLeft;
    private int mCacheRight;
    private boolean mCacheBaseline;
    private int mCacheWidth;
    private int mCacheHeight;
    int mWidth;
    int mHeight;
    int mBoxSize;
    WidgetRender mWidgetRender = new WidgetRender();
    ArrayList<Graphic> mGraphicList = new ArrayList();
    MarginWidget mTopMargin;
    MarginWidget mLeftMargin;
    MarginWidget mRightMargin;
    MarginWidget mBottomMargin;
    HConstraintDisplay mHbar1;
    HConstraintDisplay mHbar2;
    VConstraintDisplay mVbar1;
    VConstraintDisplay mVbar2;
    KillButton mTopKill;
    KillButton mLeftKill;
    KillButton mRightKill;
    KillButton mBottomKill;
    KillButton mBaselineKill;
    private String[] statusString = new String[]{"Fixed", "Any Size", "Wrap Content"};

    public SingleWidgetView(WidgetConstraintPanel constraintPanel, ColorSet colorSet) {
        super(null);
        this.mColorSet = colorSet;
        this.mTopMargin = new MarginWidget(2, this.mColorSet);
        this.mLeftMargin = new MarginWidget(2, this.mColorSet);
        this.mRightMargin = new MarginWidget(2, this.mColorSet);
        this.mBottomMargin = new MarginWidget(2, this.mColorSet);
        this.mTopMargin.setToolTipText("Top Margin");
        this.mLeftMargin.setToolTipText("Left Margin");
        this.mRightMargin.setToolTipText("Right Margin");
        this.mBottomMargin.setToolTipText("Bottom Margin");
        this.mHbar1 = new HConstraintDisplay(this.mColorSet, true);
        this.mHbar2 = new HConstraintDisplay(this.mColorSet, false);
        this.mVbar1 = new VConstraintDisplay(this.mColorSet, true);
        this.mVbar2 = new VConstraintDisplay(this.mColorSet, false);
        this.mTopKill = new KillButton(this.mColorSet);
        this.mLeftKill = new KillButton(this.mColorSet);
        this.mRightKill = new KillButton(this.mColorSet);
        this.mBottomKill = new KillButton(this.mColorSet);
        this.mBaselineKill = new KillButton(this.mColorSet);
        this.mTopKill.setToolTipText("Delete Top Constraint");
        this.mLeftKill.setToolTipText("Delete Left Constraint");
        this.mRightKill.setToolTipText("Delete Right Constraint");
        this.mBottomKill.setToolTipText("Delete Bottom Constraint");
        this.mBaselineKill.setToolTipText("Delete Baseline Constraint");
        this.mHbar1.setSister(this.mHbar2);
        this.mHbar2.setSister(this.mHbar1);
        this.mVbar1.setSister(this.mVbar2);
        this.mVbar2.setSister(this.mVbar1);
        this.mWidgetConstraintPanel = constraintPanel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SingleWidgetView.this.resize();
            }
        });
        this.add(this.mTopMargin);
        this.add(this.mLeftMargin);
        this.add(this.mRightMargin);
        this.add(this.mBottomMargin);
        this.mTopMargin.addActionListener(e -> this.mWidgetConstraintPanel.setTopMargin(this.mTopMargin.getMargin()));
        this.mLeftMargin.addActionListener(e -> this.mWidgetConstraintPanel.setLeftMargin(this.mLeftMargin.getMargin()));
        this.mRightMargin.addActionListener(e -> this.mWidgetConstraintPanel.setRightMargin(this.mRightMargin.getMargin()));
        this.mBottomMargin.addActionListener(e -> this.mWidgetConstraintPanel.setBottomMargin(this.mBottomMargin.getMargin()));
        this.add(this.mTopKill);
        this.add(this.mLeftKill);
        this.add(this.mRightKill);
        this.add(this.mBottomKill);
        this.add(this.mBaselineKill);
        this.add(this.mHbar1);
        this.add(this.mHbar2);
        this.add(this.mVbar1);
        this.add(this.mVbar2);
        this.mTopKill.addActionListener(e -> this.topKill());
        this.mLeftKill.addActionListener(e -> this.leftKill());
        this.mRightKill.addActionListener(e -> this.rightKill());
        this.mBottomKill.addActionListener(e -> this.bottomKill());
        this.mBaselineKill.addActionListener(e -> this.baselineKill());
        this.mHbar1.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar1));
        this.mHbar2.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar2));
        this.mVbar1.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar1));
        this.mVbar2.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar2));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                SingleWidgetView.this.mTopMargin.showUI(SingleWidgetView.this.mTopMargin.getBounds().contains(e.getPoint()) ? MarginWidget.Show.IN_WIDGET : MarginWidget.Show.OUT_WIDGET);
                SingleWidgetView.this.mLeftMargin.showUI(SingleWidgetView.this.mLeftMargin.getBounds().contains(e.getPoint()) ? MarginWidget.Show.IN_WIDGET : MarginWidget.Show.OUT_WIDGET);
                SingleWidgetView.this.mRightMargin.showUI(SingleWidgetView.this.mRightMargin.getBounds().contains(e.getPoint()) ? MarginWidget.Show.IN_WIDGET : MarginWidget.Show.OUT_WIDGET);
                SingleWidgetView.this.mBottomMargin.showUI(SingleWidgetView.this.mBottomMargin.getBounds().contains(e.getPoint()) ? MarginWidget.Show.IN_WIDGET : MarginWidget.Show.OUT_WIDGET);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (SingleWidgetView.this.getBounds().contains(e.getPoint())) {
                    return;
                }
                SingleWidgetView.this.mTopMargin.showUI(MarginWidget.Show.OUT_PANEL);
                SingleWidgetView.this.mLeftMargin.showUI(MarginWidget.Show.OUT_PANEL);
                SingleWidgetView.this.mRightMargin.showUI(MarginWidget.Show.OUT_PANEL);
                SingleWidgetView.this.mBottomMargin.showUI(MarginWidget.Show.OUT_PANEL);
            }
        });
        this.mGraphicList.add(this.mWidgetRender);
    }

    private void setHorizontalState(HConstraintDisplay state) {
        if (state == this.mHbar1) {
            this.mHbar2.setState(state.getState());
        } else {
            this.mHbar1.setState(state.getState());
        }
        this.mHbar1.setToolTipText(this.statusString[state.getState()]);
        this.mHbar2.setToolTipText(this.statusString[state.getState()]);
        this.mWidgetConstraintPanel.setHorizontalConstraint(state.getState());
    }

    private void setVerticalState(VConstraintDisplay state) {
        if (state == this.mVbar1) {
            this.mVbar2.setState(state.getState());
        } else {
            this.mVbar1.setState(state.getState());
        }
        this.mVbar1.setToolTipText(this.statusString[state.getState()]);
        this.mVbar2.setToolTipText(this.statusString[state.getState()]);
        this.mWidgetConstraintPanel.setVerticalConstraint(state.getState());
    }

    private void topKill() {
        this.mWidgetConstraintPanel.killTopConstraint();
        this.mCacheTop = -1;
        this.update();
    }

    private void leftKill() {
        this.mWidgetConstraintPanel.killLeftConstraint();
        this.mCacheLeft = -1;
        this.update();
    }

    private void rightKill() {
        this.mWidgetConstraintPanel.killRightConstraint();
        this.mCacheRight = -1;
        this.update();
    }

    private void bottomKill() {
        this.mWidgetConstraintPanel.killBottomConstraint();
        this.mCacheBottom = -1;
        this.update();
    }

    private void baselineKill() {
        this.mWidgetConstraintPanel.killBaselineConstraint();
        this.mCacheBaseline = false;
        this.update();
    }

    static int baselinePos(int height) {
        return 9 * height / 10;
    }

    private void update() {
        this.configureUi(this.mCacheBottom, this.mCacheTop, this.mCacheLeft, this.mCacheRight, this.mCacheBaseline, this.mCacheWidth, this.mCacheHeight);
    }

    void resize() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        this.mWidgetRender.build(this.mWidth, this.mHeight);
        this.mBoxSize = Math.min(this.mWidth, this.mHeight) / 2;
        int vgap = 8;
        int hgap = 4;
        int cw = 38;
        int ch = 30;
        int inset = 5 + this.mWidth / 100;
        int boxLeft = (this.mWidth - this.mBoxSize) / 2;
        int boxTop = (this.mHeight - this.mBoxSize) / 2;
        int vSpace = (this.mHeight - this.mBoxSize - inset * 2) / 2;
        int hSpace = (this.mWidth - this.mBoxSize - inset * 2) / 2;
        this.mTopMargin.setBounds(hgap + this.mWidth / 2, inset + (vSpace - ch) / 2, cw, ch);
        this.mLeftMargin.setBounds((boxLeft + inset - cw) / 2, vgap + (this.mHeight - ch) / 2, cw, ch);
        this.mRightMargin.setBounds(boxLeft + this.mBoxSize + (hSpace - cw) / 2, vgap + (this.mHeight - ch) / 2, cw, ch);
        this.mBottomMargin.setBounds(hgap + this.mWidth / 2, boxTop + this.mBoxSize + (vSpace - ch) / 2, cw, ch);
        int rad = 10;
        int size = rad * 2 + 1;
        this.mTopKill.setBounds(boxLeft + this.mBoxSize / 2 - rad, boxTop - rad, size + 2, size);
        this.mLeftKill.setBounds(boxLeft - rad, boxTop + this.mBoxSize / 2 - rad + 1, size + 2, size);
        this.mRightKill.setBounds(boxLeft + this.mBoxSize - rad, boxTop + this.mBoxSize / 2 - rad + 1, size + 2, size);
        this.mBottomKill.setBounds(boxLeft + this.mBoxSize / 2 - rad, boxTop + this.mBoxSize - rad, size + 2, size);
        this.mBaselineKill.setBounds(boxLeft + this.mBoxSize / 2 - rad, boxTop + SingleWidgetView.baselinePos(this.mBoxSize) - rad, size + 2, size);
        int barSize = 10;
        int barLong = this.mBoxSize / 2 - barSize - 1;
        this.mHbar1.setBounds(1 + boxLeft, boxTop + this.mBoxSize / 2 - barSize / 2 + 1, barLong, barSize);
        this.mHbar2.setBounds(boxLeft + this.mBoxSize / 2 + barSize, boxTop + this.mBoxSize / 2 - barSize / 2 + 1, barLong, barSize);
        this.mVbar1.setBounds(boxLeft + this.mBoxSize / 2 - barSize / 2, 1 + boxTop, barSize, barLong);
        if (this.mCacheBaseline) {
            int left = boxLeft + this.mBoxSize / 2 - barSize / 2;
            int top = boxTop + this.mBoxSize / 2 + barSize;
            int height = boxTop + SingleWidgetView.baselinePos(this.mBoxSize) - top - 2;
            this.mVbar2.setBounds(left, top, barSize, height);
        } else {
            this.mVbar2.setBounds(boxLeft + this.mBoxSize / 2 - barSize / 2, boxTop + this.mBoxSize / 2 + barSize, barSize, barLong);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mWidth != this.getWidth() || this.mHeight != this.getHeight()) {
            this.resize();
        }
        Graphics2D g2d = (Graphics2D)g;
        boolean redraw = false;
        for (Graphic graphic : this.mGraphicList) {
            redraw |= graphic.paint(g2d, this.mColorSet);
        }
        if (redraw) {
            this.repaint();
        }
    }

    public void configureUi(int bottom, int top, int left, int right, boolean baseline, int width, int height) {
        this.mCacheBottom = bottom;
        this.mCacheTop = top;
        this.mCacheLeft = left;
        this.mCacheRight = right;
        this.mCacheBaseline = baseline;
        this.mCacheWidth = width;
        this.mCacheHeight = height;
        this.mTopMargin.setVisible(top != -1);
        this.mLeftMargin.setVisible(left != -1);
        this.mRightMargin.setVisible(right != -1);
        this.mBottomMargin.setVisible(bottom != -1);
        this.mTopMargin.setMargin(top);
        this.mLeftMargin.setMargin(left);
        this.mRightMargin.setMargin(right);
        this.mBottomMargin.setMargin(bottom);
        this.mWidgetRender.mMarginBottom = bottom;
        this.mWidgetRender.mMarginTop = top;
        this.mWidgetRender.mMarginLeft = left;
        this.mWidgetRender.mMarginRight = right;
        this.mWidgetRender.mBaseline = baseline;
        this.mTopKill.setVisible(top != -1);
        this.mLeftKill.setVisible(left != -1);
        this.mRightKill.setVisible(right != -1);
        this.mBottomKill.setVisible(bottom != -1);
        this.mBaselineKill.setVisible(baseline);
        this.mHbar1.setState(width);
        this.mHbar2.setState(width);
        this.mVbar1.setState(height);
        this.mVbar2.setState(height);
        this.mVbar1.setToolTipText(this.statusString[height]);
        this.mVbar2.setToolTipText(this.statusString[height]);
        this.mHbar1.setToolTipText(this.statusString[width]);
        this.mHbar2.setToolTipText(this.statusString[width]);
        this.mWidgetRender.build(this.getWidth(), this.getHeight());
        this.repaint();
    }

    static class VConstraintDisplay
    extends TriStateControl {
        boolean mDirection;

        VConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
            this.setPreferredSize(new Dimension(30, 200));
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 5;
            int end = height - 5;
            int pos = width / 2;
            switch (this.mState) {
                case 0: {
                    VConstraintDisplay.drawFixedVerticalConstraint(g, start, pos, end);
                    break;
                }
                case 1: {
                    VConstraintDisplay.drawSpringVerticalConstraint(g, start, pos, end);
                    break;
                }
                case 2: {
                    VConstraintDisplay.drawWrapVerticalConstraint(g, start, pos, end, this.mDirection);
                }
            }
        }

        private static void drawSpringVerticalConstraint(Graphics g, int t, int x, int b) {
            int m = 7;
            int d = 3;
            int h = b - t;
            int ni = h / (2 * d) - 1;
            int margin = (h - ni * 2 * d) / 2;
            g.drawLine(x - m, t, x + m, t);
            g.drawLine(x, t, x, t + margin);
            for (int i = t + margin; i <= b - margin - 2 * d; i += 2 * d) {
                g.drawLine(x, i, x + d, i + d);
                g.drawLine(x + d, i + d, x - d, i + d);
                g.drawLine(x - d, i + d, x, i + 2 * d);
            }
            g.drawLine(x, b - margin, x, b);
            g.drawLine(x - m, b, x + m, b);
        }

        private static void drawFixedVerticalConstraint(Graphics g, int t, int x, int b) {
            int m = 7;
            g.drawLine(x - m, t, x + m, t);
            g.drawLine(x, t, x, b);
            g.drawLine(x - m, b, x + m, b);
        }

        private static void drawWrapVerticalConstraint(Graphics g, int t, int x, int b, boolean topToBottom) {
            int d = 4;
            int h = b - t;
            int ni = h / (2 * d) - 1;
            int margin = (h - ni * 2 * d) / 2;
            if (topToBottom) {
                for (int i = t + margin; i <= b - margin; i += 2 * d) {
                    g.drawLine(x - d, i, x, i + d);
                    g.drawLine(x, i + d, x + d, i);
                }
            } else {
                for (int i = t + margin; i <= b - margin; i += 2 * d) {
                    g.drawLine(x - d, i + d, x, i);
                    g.drawLine(x, i, x + d, i + d);
                }
            }
        }
    }

    static class HConstraintDisplay
    extends TriStateControl {
        boolean mDirection;

        HConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
            this.setPreferredSize(new Dimension(200, 30));
        }

        @Override
        void resize() {
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 5;
            int end = width - 5;
            int pos = height / 2;
            switch (this.mState) {
                case 0: {
                    HConstraintDisplay.drawFixedHorizontalConstraint(g, start, pos, end);
                    break;
                }
                case 1: {
                    HConstraintDisplay.drawSpringHorizontalConstraint(g, start, pos, end);
                    break;
                }
                case 2: {
                    HConstraintDisplay.drawWrapHorizontalConstraint(g, start, pos, end, this.mDirection);
                }
            }
        }

        private static void drawSpringHorizontalConstraint(Graphics g, int l, int y, int r) {
            int m = 7;
            int d = 3;
            int w = r - l;
            int ni = w / (2 * d) - 1;
            int margin = (w - ni * 2 * d) / 2;
            g.drawLine(l, y - m, l, y + m);
            g.drawLine(l, y, l + margin, y);
            for (int i = l + margin; i <= r - margin - 2 * d; i += 2 * d) {
                g.drawLine(i, y, i + d, y - d);
                g.drawLine(i + d, y - d, i + d, y + d);
                g.drawLine(i + d, y + d, i + 2 * d, y);
            }
            g.drawLine(r - margin, y, r, y);
            g.drawLine(r, y - m, r, y + m);
        }

        private static void drawWrapHorizontalConstraint(Graphics g, int l, int y, int r, boolean directionLeftToRight) {
            int d = 4;
            int w = r - l;
            int ni = w / (2 * d) - 1;
            int margin = (w - ni * 2 * d) / 2;
            Graphics2D g2 = (Graphics2D)g;
            if (directionLeftToRight) {
                for (int i = l + margin; i <= r - margin; i += 2 * d) {
                    g2.drawLine(i, y - d, i + d, y);
                    g2.drawLine(i + d, y, i, y + d);
                }
            } else {
                for (int i = l + margin; i <= r - margin; i += 2 * d) {
                    g2.drawLine(i, y - d, i - d, y);
                    g2.drawLine(i - d, y, i, y + d);
                }
            }
        }

        private static void drawFixedHorizontalConstraint(Graphics g, int l, int y, int r) {
            int m = 7;
            g.drawLine(l, y - m, l, y + m);
            g.drawLine(l, y, r, y);
            g.drawLine(r, y - m, r, y + m);
        }
    }

    static class TriStateControl
    extends JComponent {
        boolean mMouseIn;
        int mState;
        Color mBackground;
        Color mLineColor;
        Color mMouseOverColor;
        TriStateControl mSisterControl;
        public static final String STATE = "state";

        TriStateControl(ColorSet colorSet) {
            this.mBackground = colorSet.getInspectorFillColor();
            this.mLineColor = colorSet.getInspectorStrokeColor();
            this.mMouseOverColor = colorSet.getInspectorHighlightsStrokeColor();
            this.setPreferredSize(new Dimension(200, 30));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int oldValue = mState;
                    mState = (mState + 1) % 3;
                    this.firePropertyChange(TriStateControl.STATE, oldValue, mState);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mMouseIn = false;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = mMouseIn;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    mMouseIn = true;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = mMouseIn;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.resize();
                }
            });
        }

        public void setSister(TriStateControl sister) {
            this.mSisterControl = sister;
        }

        public int getState() {
            return this.mState;
        }

        public void setState(int state) {
            this.mState = state;
            this.repaint();
        }

        void resize() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            g.setColor(this.mBackground);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.mMouseIn ? this.mMouseOverColor : this.mLineColor);
            this.drawState(g, width, height);
        }

        void drawState(Graphics g, int width, int height) {
        }
    }

    class WidgetRender
    implements Graphic {
        WidgetsScene mWidgetsScene;
        ConstraintWidgetContainer mRoot;
        int mMarginLeft;
        int mMarginTop;
        int mMarginRight;
        int mMarginBottom;
        boolean mBaseline;
        Box mWidgetCenter;
        Box mWidgetLeft;
        Box mWidgetRight;
        Box mWidgetTop;
        Box mWidgetBottom;
        Line mTopArrow;
        Line mLeftArrow;
        Line mRightArrow;
        Line mBottomArrow;
        LineArrow mBaselineArrow;

        WidgetRender() {
        }

        void setConstraints(int left, int top, int right, int bottom) {
            this.mMarginTop = top;
            this.mMarginLeft = left;
            this.mMarginRight = right;
            this.mMarginBottom = bottom;
        }

        public void build(int width, int height) {
            this.mRoot = new ConstraintWidgetContainer();
            this.mRoot.setCompanionWidget((Object)WidgetCompanion.create((ConstraintWidget)this.mRoot));
            this.mRoot.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
            this.mRoot.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
            this.mRoot.setOrigin(-1, -1);
            this.mRoot.setDebugName("       ");
            this.mRoot.setWidth(width + 1);
            this.mRoot.setHeight(height + 1);
            this.mRoot.forceUpdateDrawPosition();
            this.mWidgetsScene = new WidgetsScene();
            this.mWidgetsScene.setRoot(this.mRoot);
            SingleWidgetView.this.mBoxSize = Math.min(width, height) / 2;
            int inset = 5 + width / 100;
            int boxLeft = (width - SingleWidgetView.this.mBoxSize) / 2;
            int boxTop = (height - SingleWidgetView.this.mBoxSize) / 2;
            this.mWidgetCenter = new BaseLineBox(null, boxLeft, boxTop, SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, this.mBaseline, true);
            this.mWidgetBottom = new Box(boxLeft, height - inset, SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, 1);
            this.mWidgetRight = new Box(width - inset, boxTop, SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, 4);
            this.mWidgetLeft = new Box(inset - SingleWidgetView.this.mBoxSize, boxTop, SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, 8);
            this.mWidgetTop = new Box(boxLeft, inset - SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, SingleWidgetView.this.mBoxSize, 2);
            int baseArrowX = boxLeft + SingleWidgetView.this.mBoxSize / 2;
            this.mBaselineArrow = new LineArrow(baseArrowX, boxTop + SingleWidgetView.baselinePos(SingleWidgetView.this.mBoxSize), baseArrowX, height - inset, this.mBaseline);
            this.mTopArrow = new Line(width / 2, boxTop, width / 2, inset, this.mMarginTop >= 0);
            this.mLeftArrow = new Line(boxLeft, height / 2, inset, height / 2, this.mMarginLeft >= 0);
            this.mRightArrow = new Line(boxLeft + SingleWidgetView.this.mBoxSize, height / 2, width - inset, height / 2, this.mMarginRight >= 0);
            this.mBottomArrow = new Line(width / 2, boxTop + SingleWidgetView.this.mBoxSize, width / 2, height - inset, this.mMarginBottom >= 0);
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorBackgroundColor());
            g.fillRect(0, 0, SingleWidgetView.this.getWidth(), SingleWidgetView.this.getHeight());
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorStrokeColor());
            this.mWidgetCenter.paint(g, colorSet);
            this.mWidgetLeft.paint(g, colorSet);
            this.mWidgetRight.paint(g, colorSet);
            this.mWidgetTop.paint(g, colorSet);
            this.mWidgetBottom.paint(g, colorSet);
            this.mTopArrow.paint(g, colorSet);
            this.mLeftArrow.paint(g, colorSet);
            this.mRightArrow.paint(g, colorSet);
            this.mBottomArrow.paint(g, colorSet);
            this.mBaselineArrow.paint(g, colorSet);
            return false;
        }
    }

    static class LineArrow
    implements Graphic {
        int mX1;
        int mY1;
        int mX2;
        int mY2;
        boolean mDisplay;
        int[] mXArrow = new int[3];
        int[] mYArrow = new int[3];

        LineArrow(int x1, int y1, int x2, int y2, boolean display) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display;
            this.mXArrow[0] = x2;
            this.mYArrow[0] = y2;
            this.mXArrow[1] = x2 - 3;
            this.mYArrow[1] = y2 - 5;
            this.mXArrow[2] = x2 + 3;
            this.mYArrow[2] = y2 - 5;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2 - 2);
                g.fillPolygon(this.mXArrow, this.mYArrow, 3);
            }
            return false;
        }
    }

    static class Line
    implements Graphic {
        int mX1;
        int mY1;
        int mX2;
        int mY2;
        boolean mDisplay;

        Line(int x1, int y1, int x2, int y2, boolean display) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
            }
            return false;
        }
    }

    static class BaseLineBox
    extends Box {
        String mTitle = null;
        boolean mBaseline;
        boolean mDisplay;

        BaseLineBox(String title, int x, int y, int w, int h, boolean baseline, boolean display) {
            super(x, y, w, h, display ? 15 : 0);
            this.mTitle = title;
            this.mBaseline = baseline;
            this.mDisplay = display;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                Stroke defaultStroke = g.getStroke();
                g.setColor(colorSet.getInspectorFillColor());
                g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
                g.setColor(colorSet.getInspectorStrokeColor());
                if (this.mBaseline) {
                    g.drawLine(this.mX, this.mY, this.mX, this.mY + this.mWidth);
                    g.drawLine(this.mX + this.mWidth, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
                    int y = this.mY + SingleWidgetView.baselinePos(this.mHeight);
                    g.setStroke(defaultStroke);
                    g.drawLine(this.mX, y, this.mX + this.mWidth, y);
                } else {
                    g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
                }
                if (this.mTitle != null) {
                    int decent = g.getFontMetrics().getDescent();
                    g.drawString(this.mTitle, this.mX + 2, this.mY + this.mHeight - decent);
                }
            }
            return false;
        }
    }

    static class Box
    implements Graphic {
        int mX;
        int mY;
        int mWidth;
        int mHeight;
        int mEdges;
        public static final int TOP = 1;
        public static final int BOTTOM = 2;
        public static final int LEFT = 4;
        public static final int RIGHT = 8;
        public static final int ALL = 15;

        Box(int x, int y, int w, int h, int edges) {
            this.mX = x;
            this.mY = y;
            this.mHeight = h;
            this.mWidth = w;
            this.mEdges = edges;
        }

        @Override
        public boolean paint(Graphics2D g, ColorSet colorSet) {
            if (this.mEdges == 0) {
                return false;
            }
            g.setColor(colorSet.getInspectorFillColor());
            g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
            g.setColor(colorSet.getInspectorStrokeColor());
            if (this.mEdges == 15) {
                g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
            } else {
                if ((this.mEdges & 1) != 0) {
                    g.drawLine(this.mX, this.mY, this.mX + this.mWidth, this.mY);
                }
                if ((this.mEdges & 2) != 0) {
                    g.drawLine(this.mX, this.mY + this.mHeight, this.mX + this.mWidth, this.mY + this.mHeight);
                }
                if ((this.mEdges & 4) != 0) {
                    g.drawLine(this.mX, this.mY, this.mX, this.mY + this.mWidth);
                }
                if ((this.mEdges & 8) != 0) {
                    g.drawLine(this.mX + this.mWidth, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
                }
            }
            return false;
        }
    }

    static interface Graphic {
        public boolean paint(Graphics2D var1, ColorSet var2);
    }

    static class KillButton
    extends JComponent {
        boolean mMouseIn;
        boolean mShow = true;
        ColorSet mColorSet;
        private static int sCircleRadius = 10;
        private ActionListener mListener;
        static Dimension size = new Dimension(sCircleRadius * 2, sCircleRadius * 2);
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(Color.BLUE);
                if (mMouseIn) {
                    this.drawCircle((Graphics2D)g, x + sCircleRadius, y + sCircleRadius, sCircleRadius, true);
                }
            }

            private void drawCircle(Graphics2D g2, int x, int y, int radius, boolean full) {
                Graphics2D g = (Graphics2D)g2.create();
                Ellipse2D.Float circle = new Ellipse2D.Float(x - radius, y - radius, radius * 2, radius * 2);
                g.setColor(mColorSet.getInspectorStrokeColor());
                g.draw(circle);
                g.fill(circle);
                Ellipse2D.Float emptyCircle = new Ellipse2D.Float(x - --radius, y - radius, radius * 2, radius * 2);
                g.setColor(mColorSet.getInspectorBackgroundColor());
                g.draw(emptyCircle);
                g.fill(emptyCircle);
                if (full) {
                    Ellipse2D.Float innerCircle = new Ellipse2D.Float(x - (radius -= 2), y - radius, radius * 2, radius * 2);
                    g.setColor(mColorSet.getInspectorStrokeColor());
                    g.fill(innerCircle);
                    g.draw(innerCircle);
                    g.setColor(mColorSet.getInspectorBackgroundColor());
                    g.setStroke(new BasicStroke(2.0f));
                    radius = 4;
                    g.drawLine(x - radius, y - radius, x + radius, y + radius);
                    g.drawLine(x - radius, y + radius, x + radius, y - radius);
                }
                g.dispose();
            }

            @Override
            public int getIconWidth() {
                return sCircleRadius * 2 + 2;
            }

            @Override
            public int getIconHeight() {
                return sCircleRadius * 2;
            }
        };

        @Override
        public void paint(Graphics g) {
            if (this.mMouseIn && this.mShow) {
                this.icon.paintIcon(this, g, 0, 0);
            }
        }

        public void setShown(boolean show) {
            this.mShow = show;
        }

        public KillButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.setPreferredSize(size);
            this.setSize(size);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        public void addActionListener(ActionListener listener) {
            this.mListener = listener;
        }
    }
}

