/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.PanZoomListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.sherpa.drawing.BlueprintColorSet;
import com.android.tools.sherpa.drawing.ColorSet;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetNavigatorPanel
extends JPanel
implements DesignSurfaceListener,
PanZoomListener,
ModelListener,
JBPopupListener {
    public static final String TITLE = "Pan and Zoom";
    public static final String HINT = "(Scroll to Zoom)";
    private static final IconButton CANCEL_BUTTON = new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered);
    private static final int SCREEN_SPACE = 10;
    private static final Dimension PREFERRED_SIZE = new Dimension(250, 216);
    private static final BlueprintColorSet BLUEPRINT_COLOR_SET = new BlueprintColorSet();
    private static final JBColor DRAWING_SURFACE_RECTANGLE_COLOR = JBColor.red;
    private static final JBColor OVERLAY_COLOR = new JBColor(new Color(232, 232, 232, 127), new Color(80, 80, 80, 127));
    private static final JBColor NORMAL_SCREEN_VIEW_COLOR = new JBColor((Color)Gray._255, (Color)Gray._240);
    private static final Color BLUEPRINT_SCREEN_VIEW_COLOR = BLUEPRINT_COLOR_SET.getBackground();
    private static final Color COMPONENT_STROKE_COLOR = BLUEPRINT_COLOR_SET.getFrames();
    private static final Color BACKGROUND_COLOR = BLUEPRINT_COLOR_SET.getBackground();
    private final ColorSet myColorSet;
    private MiniMap myMiniMap;
    @Nullable
    private DesignSurface myDesignSurface;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private JBPopup myContainerPopup;
    private Dimension myCurrentScreenViewSize;
    private Dimension myDesignSurfaceSize;
    private Dimension myDeviceSize;
    private double myScreenViewScale;
    private double myDeviceScale;
    private Point myDesignSurfaceOffset;
    private Point mySecondScreenOffset;
    private int myCenterOffset;
    private boolean myIsZoomed;
    private int myYScreenNumber;
    private int myXScreenNumber;
    private int myScaledScreenSpace;
    private AncestorListenerAdapter myAncestorListener;

    public WidgetNavigatorPanel(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myDesignSurfaceOffset = new Point();
        this.mySecondScreenOffset = new Point();
        this.myMiniMap = new MiniMap();
        this.myAncestorListener = new MyAncestorListenerAdapter();
        this.myColorSet = BLUEPRINT_COLOR_SET;
        this.setPreferredSize(PREFERRED_SIZE);
        this.setSurface(surface);
        this.updateComponents(null);
        this.add((Component)this.myMiniMap, "Center");
        MouseInteractionListener listener = new MouseInteractionListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addMouseWheelListener(listener);
        this.configureUI();
    }

    public void configureUI() {
        if (this.myDesignSurface == null) {
            return;
        }
        this.computeScale(this.myDesignSurface.getCurrentScreenView(), this.myDesignSurface.getSize(), this.myDesignSurface.getContentSize(null));
        this.computeOffsets(this.myDesignSurface.getCurrentScreenView());
    }

    public void updateComponents(@Nullable List<NlComponent> selectedComponents) {
        ScreenView currentScreenView;
        if (selectedComponents != null && !selectedComponents.isEmpty()) {
            this.myComponent = selectedComponents.get(0);
        } else if (this.myComponent != null) {
            this.myComponent = this.myComponent.getRoot();
        } else if (this.myDesignSurface != null && (currentScreenView = this.myDesignSurface.getCurrentScreenView()) != null) {
            List<NlComponent> components = currentScreenView.getModel().getComponents();
            this.myComponent = !components.isEmpty() ? components.get(0) : null;
        }
        this.myMiniMap.repaint();
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> selectedComponents) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "componentSelectionChanged"));
        }
        if (selectedComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedComponents", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "componentSelectionChanged"));
        }
        this.updateComponents(selectedComponents);
        this.configureUI();
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "screenChanged"));
        }
        this.setSurface(surface);
        assert (this.myDesignSurface != null);
        this.computeOffsets(this.myDesignSurface.getCurrentScreenView());
        this.myMiniMap.repaint();
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "modelChanged"));
        }
        this.setSurface(surface);
        if (model != null) {
            model.addListener(this);
        }
        this.computeOffsets(surface.getCurrentScreenView());
        if (model != null) {
            List<NlComponent> selection = model.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                selection = model.getComponents();
            }
            this.updateComponents(selection);
        }
        this.configureUI();
        this.myMiniMap.repaint();
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "activatePreferredEditor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "activatePreferredEditor"));
        }
        return false;
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "modelChanged"));
        }
        if (this.myDesignSurface != null) {
            this.updateDeviceConfiguration(this.myDesignSurface.getConfiguration());
            this.updateComponents(model.getComponents());
            this.updateScreenNumber(this.myDesignSurface);
            this.myMiniMap.repaint();
        }
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "modelRendered"));
        }
    }

    @Override
    public void zoomChanged(DesignSurface designSurface) {
        this.setSurface(designSurface);
        this.myMiniMap.repaint();
    }

    @Override
    public void panningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myDesignSurface == null) {
            return;
        }
        Point scrollPosition = this.myDesignSurface.getScrollPosition();
        ScreenView currentScreenView = this.myDesignSurface.getCurrentScreenView();
        if (currentScreenView != null) {
            this.myDesignSurfaceSize = this.myDesignSurface.getSize(this.myDesignSurfaceSize);
            Dimension contentSize = this.myDesignSurface.getContentSize(null);
            this.computeScale(currentScreenView, this.myDesignSurfaceSize, contentSize);
        }
        this.myDesignSurfaceOffset.setLocation(scrollPosition.getX() * this.myScreenViewScale, scrollPosition.getY() * this.myScreenViewScale);
        this.repaint();
    }

    public void beforeShown(LightweightWindowEvent event) {
        this.myContainerPopup = event.asPopup();
    }

    public void onClosed(LightweightWindowEvent event) {
        if (this.myContainerPopup != null) {
            this.myContainerPopup.removeListener((JBPopupListener)this);
            this.myContainerPopup = null;
        }
    }

    public void setSurface(@Nullable DesignSurface surface) {
        Configuration configuration;
        ScreenView currentScreenView;
        this.updateScreenNumber(surface);
        if (surface == this.myDesignSurface) {
            return;
        }
        if (this.myDesignSurface != null) {
            this.myDesignSurface.removeListener(this);
            this.myDesignSurface.removePanZoomListener(this);
            this.myDesignSurface.removeAncestorListener((AncestorListener)this.myAncestorListener);
            currentScreenView = this.myDesignSurface.getCurrentScreenView();
            if (currentScreenView != null) {
                currentScreenView.getModel().removeListener(this);
            }
        }
        this.myDesignSurface = surface;
        if (this.myDesignSurface == null) {
            return;
        }
        this.myDesignSurface.addListener(this);
        this.myDesignSurface.addPanZoomListener(this);
        this.myDesignSurface.addAncestorListener((AncestorListener)this.myAncestorListener);
        currentScreenView = this.myDesignSurface.getCurrentScreenView();
        if (currentScreenView != null) {
            currentScreenView.getModel().addListener(this);
        }
        if ((configuration = this.myDesignSurface.getConfiguration()) != null) {
            this.updateDeviceConfiguration(configuration);
        }
    }

    private void updateScreenNumber(@Nullable DesignSurface surface) {
        if (surface != null) {
            this.myXScreenNumber = !surface.isStackVertically() && surface.getScreenMode() == DesignSurface.ScreenMode.BOTH ? 2 : 1;
            this.myYScreenNumber = surface.isStackVertically() && surface.getScreenMode() == DesignSurface.ScreenMode.BOTH ? 2 : 1;
        }
    }

    private void updateDeviceConfiguration(Configuration configuration) {
        Device device = configuration.getDevice();
        State deviceState = configuration.getDeviceState();
        if (device != null && deviceState != null) {
            this.myDeviceSize = device.getScreenSize(deviceState.getOrientation());
        }
    }

    private void computeScale(@Nullable ScreenView currentScreenView, @NotNull Dimension designSurfaceSize, @NotNull Dimension contentSize) {
        if (designSurfaceSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurfaceSize", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "computeScale"));
        }
        if (contentSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentSize", "com/android/tools/idea/uibuilder/handlers/constraint/WidgetNavigatorPanel", "computeScale"));
        }
        if (currentScreenView == null || this.myMiniMap == null) {
            return;
        }
        this.myIsZoomed = designSurfaceSize.getWidth() < (double)currentScreenView.getX() + contentSize.getWidth() || designSurfaceSize.getHeight() < (double)currentScreenView.getY() + contentSize.getHeight();
        double surfaceScale = (double)WidgetNavigatorPanel.PREFERRED_SIZE.height / designSurfaceSize.getHeight();
        this.myScaledScreenSpace = (int)Math.round(10.0 * surfaceScale);
        this.myScreenViewScale = (double)WidgetNavigatorPanel.PREFERRED_SIZE.height / contentSize.getHeight();
        this.myDeviceScale = (double)WidgetNavigatorPanel.PREFERRED_SIZE.height / this.myDeviceSize.getHeight() / (double)this.myYScreenNumber;
        this.computeOffsets(currentScreenView);
    }

    private void computeOffsets(@Nullable ScreenView currentScreenView) {
        if (this.myDesignSurface != null && currentScreenView != null) {
            this.myCurrentScreenViewSize = currentScreenView.getSize(this.myCurrentScreenViewSize);
            if (this.myDesignSurface.getScreenMode() == DesignSurface.ScreenMode.BOTH) {
                if (this.myDesignSurface.isStackVertically()) {
                    this.mySecondScreenOffset.setLocation(0.0, this.myDeviceSize.getHeight() * this.myDeviceScale + (double)this.myScaledScreenSpace);
                } else {
                    this.mySecondScreenOffset.setLocation(this.myDeviceSize.getWidth() * this.myDeviceScale + (double)this.myScaledScreenSpace, 0.0);
                }
            }
        }
        this.myCenterOffset = (int)Math.round((PREFERRED_SIZE.getWidth() - (double)this.myXScreenNumber * this.myDeviceSize.getWidth() * this.myDeviceScale) / 2.0);
    }

    public static JBPopup createPopup(DesignSurface surface) {
        WidgetNavigatorPanel navigatorPanel = new WidgetNavigatorPanel(surface);
        Dimension minSize = new Dimension(navigatorPanel.getSize());
        JBPopup builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)navigatorPanel, (JComponent)navigatorPanel).setTitle(TITLE).setMinSize(minSize).setResizable(false).setMovable(true).setRequestFocus(true).setLocateWithinScreenBounds(true).setCancelButton(CANCEL_BUTTON).setShowBorder(true).setShowShadow(true).setCancelOnClickOutside(false).setCancelOnWindowDeactivation(false).setCancelOnOtherWindowOpen(true).addListener((JBPopupListener)navigatorPanel).createPopup();
        int x = surface.getWidth() - WidgetNavigatorPanel.PREFERRED_SIZE.width - surface.getScrollPane().getVerticalScrollBar().getWidth();
        int y = 20;
        RelativePoint position = new RelativePoint((Component)surface, new Point(x, 20));
        builder.show(position);
        return builder;
    }

    private class MiniMap
    extends JPanel {
        private MiniMap() {
        }

        @Override
        public void paintChildren(Graphics g) {
            ScreenView currentScreenView;
            Graphics2D gc = (Graphics2D)g;
            gc.setBackground(UIUtil.getWindowColor());
            gc.clearRect(0, 0, this.getWidth(), this.getHeight());
            if (WidgetNavigatorPanel.this.myDesignSurface != null && (currentScreenView = WidgetNavigatorPanel.this.myDesignSurface.getCurrentScreenView()) != null) {
                WidgetNavigatorPanel.this.myDesignSurfaceSize = WidgetNavigatorPanel.this.myDesignSurface.getSize(WidgetNavigatorPanel.this.myDesignSurfaceSize);
                Dimension contentSize = WidgetNavigatorPanel.this.myDesignSurface.getContentSize(null);
                ScreenView blueprintView = WidgetNavigatorPanel.this.myDesignSurface.getBlueprintView();
                WidgetNavigatorPanel.this.computeScale(currentScreenView, WidgetNavigatorPanel.this.myDesignSurfaceSize, contentSize);
                gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gc.setColor(BACKGROUND_COLOR);
                this.drawContainers(gc, blueprintView);
                if (WidgetNavigatorPanel.this.myIsZoomed) {
                    this.drawDesignSurface(gc, currentScreenView);
                }
                gc.setColor(COMPONENT_STROKE_COLOR);
                if (WidgetNavigatorPanel.this.myComponent != null) {
                    this.drawAllComponents(gc, WidgetNavigatorPanel.this.myComponent.getRoot(), blueprintView);
                }
                super.paintChildren(g);
            }
        }

        private void drawAllComponents(Graphics2D gc, NlComponent component, @Nullable ScreenView blueprintView) {
            Color color = gc.getColor();
            if (WidgetNavigatorPanel.this.myComponent != null && component.getId() != null && component.getId().equals(WidgetNavigatorPanel.this.myComponent.getId())) {
                gc.setColor(WidgetNavigatorPanel.this.myColorSet.getSelectedFrames());
            }
            this.drawComponent(gc, component, blueprintView);
            gc.setColor(color);
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.drawAllComponents(gc, component.getChild(i), blueprintView);
            }
        }

        private void drawComponent(Graphics2D gc, NlComponent component, @Nullable ScreenView blueprintView) {
            double componentRatio = WidgetNavigatorPanel.this.myDeviceScale;
            gc.drawRect((int)Math.round((double)WidgetNavigatorPanel.this.myCenterOffset + (double)component.x * componentRatio), (int)Math.round((double)component.y * componentRatio), (int)Math.round((double)component.w * componentRatio), (int)Math.round((double)component.h * componentRatio));
            assert (WidgetNavigatorPanel.this.myDesignSurface != null);
            if (WidgetNavigatorPanel.this.myDesignSurface.getScreenMode() == DesignSurface.ScreenMode.BOTH && blueprintView != null) {
                gc.drawRect((int)Math.round((double)(WidgetNavigatorPanel.this.myCenterOffset + ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).mySecondScreenOffset.x) + (double)component.x * componentRatio), (int)Math.round((double)((WidgetNavigatorPanel)WidgetNavigatorPanel.this).mySecondScreenOffset.y + (double)component.y * componentRatio), (int)Math.round((double)component.w * componentRatio), (int)Math.round((double)component.h * componentRatio));
            }
        }

        private void drawContainers(Graphics2D gc, @Nullable ScreenView blueprintView) {
            assert (WidgetNavigatorPanel.this.myDesignSurface != null);
            if (WidgetNavigatorPanel.this.myDesignSurface.getScreenMode() == DesignSurface.ScreenMode.BLUEPRINT_ONLY) {
                gc.setColor(BLUEPRINT_SCREEN_VIEW_COLOR);
            } else {
                gc.setColor((Color)NORMAL_SCREEN_VIEW_COLOR);
            }
            gc.fillRect(WidgetNavigatorPanel.this.myCenterOffset, 0, (int)Math.round(WidgetNavigatorPanel.this.myDeviceSize.getWidth() * WidgetNavigatorPanel.this.myDeviceScale), (int)Math.round(WidgetNavigatorPanel.this.myDeviceSize.getHeight() * WidgetNavigatorPanel.this.myDeviceScale));
            if (WidgetNavigatorPanel.this.myDesignSurface.getScreenMode() == DesignSurface.ScreenMode.BOTH && blueprintView != null) {
                gc.setColor(BLUEPRINT_SCREEN_VIEW_COLOR);
                gc.fillRect(WidgetNavigatorPanel.this.myCenterOffset + ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).mySecondScreenOffset.x, ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).mySecondScreenOffset.y, (int)Math.round(WidgetNavigatorPanel.this.myDeviceSize.getWidth() * WidgetNavigatorPanel.this.myDeviceScale), (int)Math.round(WidgetNavigatorPanel.this.myDeviceSize.getHeight() * WidgetNavigatorPanel.this.myDeviceScale));
            }
        }

        private void drawDesignSurface(Graphics2D gc, ScreenView currentScreenView) {
            gc.setColor((Color)DRAWING_SURFACE_RECTANGLE_COLOR);
            int x = (int)Math.round((double)(WidgetNavigatorPanel.this.myCenterOffset + ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.x) - (double)(currentScreenView.getX() / 2) * WidgetNavigatorPanel.this.myScreenViewScale);
            int y = (int)Math.round((double)((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.y - (double)(currentScreenView.getX() / 2) * WidgetNavigatorPanel.this.myScreenViewScale);
            int width = (int)Math.round((WidgetNavigatorPanel.this.myDesignSurfaceSize.getWidth() - (double)currentScreenView.getX() / 2.0) * WidgetNavigatorPanel.this.myScreenViewScale);
            int height = (int)Math.round((WidgetNavigatorPanel.this.myDesignSurfaceSize.getHeight() - (double)currentScreenView.getY() / 2.0) * WidgetNavigatorPanel.this.myScreenViewScale);
            Rectangle intersection = new Rectangle(x, y, width, height).intersection(this.getVisibleRect());
            x = intersection.x;
            y = intersection.y;
            width = intersection.width - 1;
            height = intersection.height - 1;
            gc.drawRect(x, y, width, height);
            gc.setColor((Color)OVERLAY_COLOR);
            gc.fillRect(0, 0, x, this.getHeight());
            gc.fillRect(x, 0, width, y);
            gc.fillRect(x + width, 0, PREFERRED_SIZE.width, this.getHeight());
            gc.fillRect(x, y + height, width, (int)Math.round(WidgetNavigatorPanel.this.myDeviceSize.getHeight() * WidgetNavigatorPanel.this.myDeviceScale) * WidgetNavigatorPanel.this.myYScreenNumber - y - height);
        }
    }

    private class MouseInteractionListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private final Point myMouseOrigin = new Point(0, 0);
        private final Point mySurfaceOrigin = new Point(0, 0);
        private double myNewXOffset;
        private double myNewYOffset;
        private Dimension myScreenViewSize = new Dimension();
        private ScreenView myCurrentScreenView;
        private boolean myCanDrag;

        private MouseInteractionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.myCanDrag) {
                this.myNewXOffset = this.mySurfaceOrigin.x + e.getX() - this.myMouseOrigin.x;
                this.myNewYOffset = this.mySurfaceOrigin.y + e.getY() - this.myMouseOrigin.y;
                assert (WidgetNavigatorPanel.this.myDesignSurface != null);
                WidgetNavigatorPanel.this.myDesignSurface.setScrollPosition((int)Math.round(this.myNewXOffset / WidgetNavigatorPanel.this.myScreenViewScale), (int)Math.round(this.myNewYOffset / WidgetNavigatorPanel.this.myScreenViewScale));
            }
        }

        public boolean isInDesignSurfaceRectangle(MouseEvent e) {
            assert (WidgetNavigatorPanel.this.myDesignSurface != null);
            return e.getX() > ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.x + WidgetNavigatorPanel.this.myCenterOffset && (double)e.getX() < (double)(((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.x + WidgetNavigatorPanel.this.myCenterOffset) + (double)WidgetNavigatorPanel.this.myDesignSurface.getWidth() * WidgetNavigatorPanel.this.myScreenViewScale && e.getY() > ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.y && (double)e.getY() < (double)((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.y + (double)WidgetNavigatorPanel.this.myDesignSurface.getHeight() * WidgetNavigatorPanel.this.myScreenViewScale;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (WidgetNavigatorPanel.this.myDesignSurface != null && this.isInDesignSurfaceRectangle(e)) {
                this.myCurrentScreenView = WidgetNavigatorPanel.this.myDesignSurface.getCurrentScreenView();
                if (this.myCurrentScreenView == null) {
                    return;
                }
                this.myScreenViewSize = this.myCurrentScreenView.getSize(this.myScreenViewSize);
                this.myMouseOrigin.setLocation(e.getX(), e.getY());
                this.mySurfaceOrigin.setLocation(((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.x, ((WidgetNavigatorPanel)WidgetNavigatorPanel.this).myDesignSurfaceOffset.y);
                this.myCanDrag = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myCanDrag = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isInDesignSurfaceRectangle(e) && WidgetNavigatorPanel.this.myIsZoomed) {
                WidgetNavigatorPanel.this.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                WidgetNavigatorPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            WidgetNavigatorPanel.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            block4: {
                int wheelRotation;
                block3: {
                    if (WidgetNavigatorPanel.this.myDesignSurface == null) {
                        return;
                    }
                    wheelRotation = e.getWheelRotation();
                    if (wheelRotation >= 0) break block3;
                    for (int i = 0; i > wheelRotation && WidgetNavigatorPanel.this.myDesignSurface.getScale() <= 2.0; --i) {
                        WidgetNavigatorPanel.this.myDesignSurface.zoomIn();
                    }
                    break block4;
                }
                if (wheelRotation <= 0) break block4;
                for (int i = 0; i < wheelRotation && WidgetNavigatorPanel.this.myDesignSurface.getScale() > 0.1; ++i) {
                    WidgetNavigatorPanel.this.myDesignSurface.zoomOut();
                }
            }
        }
    }

    private class MyAncestorListenerAdapter
    extends AncestorListenerAdapter {
        private MyAncestorListenerAdapter() {
        }

        public void ancestorRemoved(AncestorEvent event) {
            super.ancestorRemoved(event);
            if (WidgetNavigatorPanel.this.myContainerPopup != null) {
                WidgetNavigatorPanel.this.myContainerPopup.cancel();
            }
        }
    }
}

