/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.uibuilder.handlers.relative.Match;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.MarginType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidelineHandler {
    private static final int RTL_TARGET_SDK_START = 17;
    protected final DependencyGraph myDependencyGraph;
    protected final NlComponent layout;
    protected Collection<NlComponent> myDraggedNodes;
    protected Rectangle myBounds;
    protected boolean myMoveLeft;
    protected boolean myMoveRight;
    protected boolean myMoveTop;
    protected boolean myMoveBottom;
    protected boolean mySnap;
    protected Set<NlComponent> myHorizontalDeps;
    protected Set<NlComponent> myVerticalDeps;
    protected List<DependencyGraph.Constraint> myHorizontalCycle;
    protected List<DependencyGraph.Constraint> myVerticalCycle;
    protected final List<Segment> myHorizontalEdges;
    protected final List<Segment> myVerticalEdges;
    protected final List<Segment> myCenterVertEdges;
    protected final List<Segment> myCenterHorizEdges;
    protected List<Match> myHorizontalSuggestions;
    protected List<Match> myVerticalSuggestions;
    protected Match myCurrentLeftMatch;
    protected Match myCurrentTopMatch;
    protected Match myCurrentRightMatch;
    protected Match myCurrentBottomMatch;
    protected int myTopMargin;
    protected int myBottomMargin;
    protected int myLeftMargin;
    protected int myRightMargin;
    protected String myErrorMessage;
    protected final TextDirection myTextDirection;
    protected final ViewEditor myViewEditor;

    GuidelineHandler(@NotNull ViewEditor viewEditor, @NotNull NlComponent layout) {
        if (viewEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewEditor", "com/android/tools/idea/uibuilder/handlers/relative/GuidelineHandler", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/relative/GuidelineHandler", "<init>"));
        }
        this.mySnap = true;
        this.layout = layout;
        this.myViewEditor = viewEditor;
        this.myTextDirection = TextDirection.fromConfiguration(viewEditor.getConfiguration());
        this.myHorizontalEdges = new ArrayList<Segment>();
        this.myVerticalEdges = new ArrayList<Segment>();
        this.myCenterVertEdges = new ArrayList<Segment>();
        this.myCenterHorizEdges = new ArrayList<Segment>();
        this.myDependencyGraph = DependencyGraph.get(layout);
    }

    public boolean haveSuggestions() {
        return this.myCurrentLeftMatch != null || this.myCurrentTopMatch != null || this.myCurrentRightMatch != null || this.myCurrentBottomMatch != null;
    }

    @Nullable
    protected Match pickBestMatch(List<Match> matches) {
        int alternatives = matches.size();
        if (alternatives == 0) {
            return null;
        }
        if (alternatives == 1) {
            return matches.get(0);
        }
        assert (alternatives > 1);
        Collections.sort(matches, new MatchComparator());
        return matches.get(0);
    }

    private boolean checkCycle(Match match, boolean vertical) {
        if (match != null && match.cycle) {
            for (NlComponent to : this.myDraggedNodes) {
                NlComponent from = match.edge.component;
                if (from == null) continue;
                assert (match.with.component == null || match.with.component == to);
                List<DependencyGraph.Constraint> path = this.myDependencyGraph.getPathTo(from, to, vertical);
                if (path == null) continue;
                if (vertical) {
                    this.myVerticalCycle = path;
                } else {
                    this.myHorizontalCycle = path;
                }
                String desc = DependencyGraph.Constraint.describePath(path, match.type.name, match.edge.id);
                this.myErrorMessage = "Constraint creates a cycle: " + desc;
                return true;
            }
        }
        return false;
    }

    protected String checkCycles() {
        this.myErrorMessage = null;
        this.myHorizontalCycle = null;
        this.myVerticalCycle = null;
        if (this.checkCycle(this.myCurrentTopMatch, true) || this.checkCycle(this.myCurrentBottomMatch, true)) {
            // empty if block
        }
        if (this.checkCycle(this.myCurrentLeftMatch, false) || this.checkCycle(this.myCurrentRightMatch, false)) {
            // empty if block
        }
        return this.myErrorMessage;
    }

    protected void addBounds(NlComponent node, String id, boolean addHorizontal, boolean addVertical, boolean includePadding) {
        Insets p;
        Rectangle b = new Rectangle(node.x, node.y, node.w, node.h);
        Insets m = node.getMargins();
        Insets insets = p = includePadding ? node.getPadding() : Insets.NONE;
        if (addHorizontal) {
            if (m.top != 0) {
                this.myHorizontalEdges.add(new Segment(b.y + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.WITHOUT_MARGIN));
                this.myHorizontalEdges.add(new Segment(b.y - m.top + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.WITH_MARGIN));
            } else {
                this.myHorizontalEdges.add(new Segment(b.y + p.top, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.TOP, MarginType.NO_MARGIN));
            }
            if (m.bottom != 0) {
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.WITHOUT_MARGIN));
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) + m.bottom - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.WITH_MARGIN));
            } else {
                this.myHorizontalEdges.add(new Segment(GuidelineHandler.y2(b) - p.bottom, b.x + p.left, GuidelineHandler.x2(b) - p.right, node, id, SegmentType.BOTTOM, MarginType.NO_MARGIN));
            }
        }
        if (addVertical) {
            if (m.left != 0) {
                this.myVerticalEdges.add(new Segment(b.x + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.WITHOUT_MARGIN));
                this.myVerticalEdges.add(new Segment(b.x - m.left + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.WITH_MARGIN));
            } else {
                this.myVerticalEdges.add(new Segment(b.x + p.left, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.LEFT, MarginType.NO_MARGIN));
            }
            if (m.right != 0) {
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.WITHOUT_MARGIN));
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) + m.right - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.WITH_MARGIN));
            } else {
                this.myVerticalEdges.add(new Segment(GuidelineHandler.x2(b) - p.right, b.y + p.top, GuidelineHandler.y2(b) - p.bottom, node, id, SegmentType.RIGHT, MarginType.NO_MARGIN));
            }
        }
    }

    protected void addCenter(NlComponent node, String id) {
        Rectangle b = new Rectangle(node.x, node.y, node.w, node.h);
        this.myCenterHorizEdges.add(new Segment(GuidelineHandler.centerY(b), b.x, GuidelineHandler.x2(b), node, id, SegmentType.CENTER_HORIZONTAL, MarginType.NO_MARGIN));
        this.myCenterVertEdges.add(new Segment(GuidelineHandler.centerX(b), b.y, GuidelineHandler.y2(b), node, id, SegmentType.CENTER_VERTICAL, MarginType.NO_MARGIN));
    }

    protected int addBaseLine(NlComponent node, String id) {
        int baselineY = node.getBaseline();
        if (baselineY != -1) {
            Rectangle b = new Rectangle(node.x, node.y, node.w, node.h);
            this.myHorizontalEdges.add(new Segment(b.y + baselineY, b.x, GuidelineHandler.x2(b), node, id, SegmentType.BASELINE, MarginType.NO_MARGIN));
        }
        return baselineY;
    }

    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        newBounds.x = x;
    }

    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        newBounds.y = y;
    }

    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        if (Math.abs(delta) > 20 && (dragged == SegmentType.LEFT || dragged == SegmentType.TOP ? delta > 0 : delta < 0)) {
            return false;
        }
        switch (edge) {
            case BOTTOM: 
            case TOP: {
                return dragged == SegmentType.TOP || dragged == SegmentType.BOTTOM;
            }
            case LEFT: 
            case RIGHT: {
                return dragged == SegmentType.LEFT || dragged == SegmentType.RIGHT || dragged == SegmentType.START || dragged == SegmentType.END;
            }
            case BASELINE: 
            case CENTER_HORIZONTAL: 
            case CENTER_VERTICAL: {
                return dragged == edge && Math.abs(delta) < 20;
            }
        }
        assert (false) : edge;
        return false;
    }

    protected List<Match> findClosest(Segment draggedEdge, List<Segment> edges) {
        ArrayList<Match> closest = new ArrayList<Match>();
        this.addClosest(draggedEdge, edges, closest);
        return closest;
    }

    protected void addClosest(Segment draggedEdge, List<Segment> edges, List<Match> closest) {
        int at = draggedEdge.at;
        int closestDelta = closest.size() > 0 ? closest.get((int)0).delta : Integer.MAX_VALUE;
        int closestDistance = Math.abs(closestDelta);
        for (Segment edge : edges) {
            boolean withParent;
            ConstraintType type;
            assert (draggedEdge.edgeType.isHorizontal() == edge.edgeType.isHorizontal());
            int delta = edge.at - at;
            int distance = Math.abs(delta);
            if (distance > closestDistance || !this.isEdgeTypeCompatible(edge.edgeType, draggedEdge.edgeType, delta) || (type = ConstraintType.forMatch(withParent = edge.component == this.layout, draggedEdge.edgeType, edge.edgeType)) == null || type.relativeToMargin && edge.marginType == MarginType.WITHOUT_MARGIN || !type.relativeToMargin && edge.marginType == MarginType.WITH_MARGIN) continue;
            Match match = new Match(edge, draggedEdge, type, delta);
            if (distance < closestDistance) {
                closest.clear();
                closestDistance = distance;
                closestDelta = delta;
            } else if (delta * closestDelta < 0) continue;
            closest.add(match);
        }
    }

    protected void clearSuggestions() {
        this.myErrorMessage = null;
        this.myVerticalSuggestions = null;
        this.myHorizontalSuggestions = null;
        this.myCurrentRightMatch = null;
        this.myCurrentLeftMatch = null;
        this.myCurrentBottomMatch = null;
        this.myCurrentTopMatch = null;
    }

    public void applyConstraints(NlComponent n) {
        String rtlConstraint;
        String constraint;
        String value;
        String centerBoth = n.getAttribute("http://schemas.android.com/apk/res/android", "layout_centerInParent");
        if (centerBoth != null && "true".equals(centerBoth)) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerInParent", null);
            if (this.myCurrentTopMatch == null && this.myCurrentBottomMatch == null) {
                n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerVertical", "true");
            }
            if (this.myCurrentLeftMatch == null && this.myCurrentRightMatch == null) {
                n.setAttribute("http://schemas.android.com/apk/res/android", "layout_centerHorizontal", "true");
            }
        }
        if ((this.myMoveTop || this.myMoveBottom || this.myMoveLeft || this.myMoveRight) && (value = n.getAttribute("http://schemas.android.com/apk/res/android", "layout_margin")) != null) {
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_margin", null);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", value);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", value);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", value);
            n.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", value);
        }
        if (this.myMoveTop) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentTop");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignTop");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_below");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerVertical");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBaseline");
        }
        if (this.myMoveBottom) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentBottom");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBottom");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_above");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerVertical");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignBaseline");
        }
        if (this.myMoveLeft) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentLeft");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignLeft");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentStart");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignStart");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_toRightOf");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerHorizontal");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", this.myTextDirection.getAttrLeft());
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", this.myTextDirection.getAttrLeftOf());
        }
        if (this.myMoveRight) {
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentRight");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignRight");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignParentEnd");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_alignEnd");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_toLeftOf");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", "layout_centerHorizontal");
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", this.myTextDirection.getAttrRight());
            GuidelineHandler.clearAttribute(n, "http://schemas.android.com/apk/res/android", this.myTextDirection.getAttrRightOf());
        }
        if (this.myMoveTop && this.myCurrentTopMatch != null) {
            GuidelineHandler.applyConstraint(n, this.myCurrentTopMatch.getConstraint(true));
            if (this.myCurrentTopMatch.type == ConstraintType.ALIGN_BASELINE) {
                String c = this.myCurrentTopMatch.getConstraint(true);
                c = c.replace("layout_alignBaseline", "layout_alignBottom");
                GuidelineHandler.applyConstraint(n, c);
            }
        }
        if (this.myMoveBottom && this.myCurrentBottomMatch != null) {
            GuidelineHandler.applyConstraint(n, this.myCurrentBottomMatch.getConstraint(true));
        }
        if (this.myMoveLeft && this.myCurrentLeftMatch != null) {
            constraint = this.myCurrentLeftMatch.getConstraint(true);
            rtlConstraint = this.myCurrentLeftMatch.getRtlConstraint(this.myTextDirection, true);
            if (rtlConstraint != null && this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyConstraint(n, constraint);
                }
                GuidelineHandler.applyConstraint(n, rtlConstraint);
            } else {
                GuidelineHandler.applyConstraint(n, constraint);
            }
        }
        if (this.myMoveRight && this.myCurrentRightMatch != null) {
            constraint = this.myCurrentRightMatch.getConstraint(true);
            rtlConstraint = this.myCurrentRightMatch.getRtlConstraint(this.myTextDirection, true);
            if (rtlConstraint != null && this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyConstraint(n, constraint);
                }
                GuidelineHandler.applyConstraint(n, rtlConstraint);
            } else {
                GuidelineHandler.applyConstraint(n, constraint);
            }
        }
        if (this.myMoveLeft) {
            if (this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyMargin(n, "layout_marginLeft", this.getLeftMarginDp());
                }
                GuidelineHandler.applyMargin(n, this.myTextDirection.getAttrMarginLeft(), this.getLeftMarginDp());
            } else {
                GuidelineHandler.applyMargin(n, "layout_marginLeft", this.getLeftMarginDp());
            }
        }
        if (this.myMoveRight) {
            if (this.supportsStartEnd()) {
                if (this.requiresRightLeft()) {
                    GuidelineHandler.applyMargin(n, "layout_marginRight", this.getRightMarginDp());
                }
                GuidelineHandler.applyMargin(n, this.myTextDirection.getAttrMarginRight(), this.getRightMarginDp());
            } else {
                GuidelineHandler.applyMargin(n, "layout_marginRight", this.getRightMarginDp());
            }
        }
        if (this.myMoveTop) {
            GuidelineHandler.applyMargin(n, "layout_marginTop", this.getTopMarginDp());
        }
        if (this.myMoveBottom) {
            GuidelineHandler.applyMargin(n, "layout_marginBottom", this.getBottomMarginDp());
        }
    }

    private boolean supportsStartEnd() {
        AndroidVersion compileSdkVersion = this.myViewEditor.getCompileSdkVersion();
        return compileSdkVersion == null || compileSdkVersion.isGreaterOrEqualThan(17) && this.myViewEditor.getTargetSdkVersion().isGreaterOrEqualThan(17);
    }

    private boolean requiresRightLeft() {
        return this.myViewEditor.getMinSdkVersion().getApiLevel() < 17;
    }

    private static void clearAttribute(NlComponent view, String uri, String attributeName) {
        view.setAttribute(uri, attributeName, null);
    }

    private static void applyConstraint(NlComponent n, String constraint) {
        assert (constraint.contains("=")) : constraint;
        String name = constraint.substring(0, constraint.indexOf(61));
        String value = constraint.substring(constraint.indexOf(61) + 1);
        n.setAttribute("http://schemas.android.com/apk/res/android", name, value);
    }

    private static void applyMargin(NlComponent n, String marginAttribute, int marginDp) {
        if (marginDp > 0) {
            n.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, String.format("%ddp", marginDp));
        } else {
            n.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, null);
        }
    }

    private static void removeRelativeParams(NlComponent node) {
        for (ConstraintType type : ConstraintType.values()) {
            GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", type.name);
        }
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginStart");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginEnd");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginLeft");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginRight");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginTop");
        GuidelineHandler.clearAttribute(node, "http://schemas.android.com/apk/res/android", "layout_marginBottom");
    }

    public void attachPrevious(NlComponent previous, NlComponent node) {
        GuidelineHandler.removeRelativeParams(node);
        String id = previous.getId();
        if (StringUtil.isEmpty((String)id)) {
            return;
        }
        if (this.myCurrentTopMatch != null || this.myCurrentBottomMatch != null) {
            node.setAttribute("http://schemas.android.com/apk/res/android", this.myCurrentTopMatch != null ? "layout_below" : "layout_above", id);
            if (this.myCurrentLeftMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentLeftMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginLeft", this.myLeftMargin);
            } else if (this.myCurrentRightMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentRightMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginRight", this.myRightMargin);
            }
        } else if (this.myCurrentLeftMatch != null || this.myCurrentRightMatch != null) {
            node.setAttribute("http://schemas.android.com/apk/res/android", this.myCurrentLeftMatch != null ? "layout_toRightOf" : "layout_toLeftOf", id);
            if (this.myCurrentTopMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentTopMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginTop", this.getTopMarginDp());
            } else if (this.myCurrentBottomMatch != null) {
                GuidelineHandler.applyConstraint(node, this.myCurrentBottomMatch.getConstraint(true));
                GuidelineHandler.applyMargin(node, "layout_marginBottom", this.getBottomMarginDp());
            }
        }
    }

    public void removeCycles() {
        if (this.myHorizontalCycle != null) {
            this.removeCycles(this.myHorizontalDeps);
        }
        if (this.myVerticalCycle != null) {
            this.removeCycles(this.myVerticalDeps);
        }
    }

    private void removeCycles(Set<NlComponent> deps) {
        for (NlComponent node : this.myDraggedNodes) {
            DependencyGraph.ViewData view = this.myDependencyGraph.getView(node);
            if (view == null) continue;
            for (DependencyGraph.Constraint constraint : view.dependedOnBy) {
                GuidelineHandler.clearAttribute(constraint.from.node, "http://schemas.android.com/apk/res/android", constraint.type.name);
            }
        }
    }

    public Match getCurrentLeftMatch() {
        return this.myCurrentLeftMatch;
    }

    public Match getCurrentTopMatch() {
        return this.myCurrentTopMatch;
    }

    public Match getCurrentRightMatch() {
        return this.myCurrentRightMatch;
    }

    public Match getCurrentBottomMatch() {
        return this.myCurrentBottomMatch;
    }

    public int getLeftMarginDp() {
        if (this.myLeftMargin != 0) {
            return this.myViewEditor.pxToDp(this.myLeftMargin);
        }
        return this.myLeftMargin;
    }

    public int getRightMarginDp() {
        if (this.myRightMargin != 0) {
            return this.myViewEditor.pxToDp(this.myRightMargin);
        }
        return this.myRightMargin;
    }

    public int getTopMarginDp() {
        if (this.myTopMargin != 0) {
            return this.myViewEditor.pxToDp(this.myTopMargin);
        }
        return this.myTopMargin;
    }

    public int getBottomMarginDp() {
        if (this.myBottomMargin != 0) {
            return this.myViewEditor.pxToDp(this.myBottomMargin);
        }
        return this.myBottomMargin;
    }

    static int centerX(Rectangle rectangle) {
        return rectangle.x + rectangle.width / 2;
    }

    static int centerY(Rectangle rectangle) {
        return rectangle.y + rectangle.height / 2;
    }

    static int x2(Rectangle rectangle) {
        return rectangle.x + rectangle.width;
    }

    static int y2(Rectangle rectangle) {
        return rectangle.y + rectangle.height;
    }

    private final class MatchComparator
    implements Comparator<Match> {
        private MatchComparator() {
        }

        @Override
        public int compare(Match m1, Match m2) {
            int edgeType2;
            int orientation2;
            int baseline2;
            int distance2;
            int distance1;
            int cycle2;
            int cycle1;
            int parent2;
            int parent1 = m1.edge.component == GuidelineHandler.this.layout ? -1 : 1;
            int n = parent2 = m2.edge.component == GuidelineHandler.this.layout ? -1 : 1;
            if (m1.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m1.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent1 = 2;
            }
            if (m2.edge.edgeType == SegmentType.CENTER_HORIZONTAL || m2.edge.edgeType == SegmentType.CENTER_VERTICAL) {
                parent2 = 2;
            }
            if (parent1 != parent2) {
                return parent1 - parent2;
            }
            if (m1.edge.edgeType.isHorizontal()) {
                cycle1 = GuidelineHandler.this.myHorizontalDeps.contains(m1.edge.component) ? 1 : -1;
                int n2 = cycle2 = GuidelineHandler.this.myHorizontalDeps.contains(m2.edge.component) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            } else {
                cycle1 = GuidelineHandler.this.myVerticalDeps.contains(m1.edge.component) ? 1 : -1;
                int n3 = cycle2 = GuidelineHandler.this.myVerticalDeps.contains(m2.edge.component) ? 1 : -1;
                if (cycle1 != cycle2) {
                    return cycle1 - cycle2;
                }
            }
            if ((distance1 = m1.edge.to <= m1.with.from ? m1.with.from - m1.edge.to : (m1.edge.from >= m1.with.to ? m1.edge.from - m1.with.to : 0)) != (distance2 = m2.edge.to <= m2.with.from ? m2.with.from - m2.edge.to : (m2.edge.from >= m2.with.to ? m2.edge.from - m2.with.to : 0))) {
                return distance1 - distance2;
            }
            int baseline1 = m1.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            int n4 = baseline2 = m2.edge.edgeType == SegmentType.BASELINE ? -1 : 1;
            if (baseline1 != baseline2) {
                return baseline1 - baseline2;
            }
            int orientation1 = GuidelineHandler.this.myTextDirection.isLeftSegment(m1.with.edgeType) || m1.with.edgeType == SegmentType.TOP ? -1 : 1;
            int n5 = orientation2 = GuidelineHandler.this.myTextDirection.isLeftSegment(m2.with.edgeType) || m2.with.edgeType == SegmentType.TOP ? -1 : 1;
            if (orientation1 != orientation2) {
                return orientation1 - orientation2;
            }
            int edgeType1 = m1.edge.edgeType != m1.with.edgeType ? -1 : 1;
            int n6 = edgeType2 = m2.edge.edgeType != m2.with.edgeType ? -1 : 1;
            if (edgeType1 != edgeType2) {
                return edgeType1 - edgeType2;
            }
            return 0;
        }
    }
}

