/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.uibuilder.api.PaletteComponentHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="palette")
public class Palette {
    @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
    private final List<BaseItem> myItems = new ArrayList<BaseItem>();
    private final Set<GradleCoordinate> myGradleCoordinates = new HashSet<GradleCoordinate>();

    private Palette() {
    }

    public static Palette parse(@NotNull Reader xmlReader, @NotNull ViewHandlerManager manager) throws JAXBException {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/android/tools/idea/uibuilder/palette/Palette", "parse"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/uibuilder/palette/Palette", "parse"));
        }
        Palette palette = Palette.unMarshal(xmlReader);
        palette.resolve(manager);
        palette.addGradleCoordinates(palette.myItems);
        return palette;
    }

    private void addGradleCoordinates(@NotNull Iterable<BaseItem> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/uibuilder/palette/Palette", "addGradleCoordinates"));
        }
        for (BaseItem item : items) {
            if (item instanceof Item) {
                GradleCoordinate coordinate;
                String coordinateAsString = ((Item)item).getGradleCoordinate();
                if (Strings.isNullOrEmpty((String)coordinateAsString) || (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateAsString + ":+"))) == null) continue;
                this.myGradleCoordinates.add(coordinate);
                continue;
            }
            if (!(item instanceof Group)) continue;
            this.addGradleCoordinates(((Group)item).getItems());
        }
    }

    @NotNull
    public List<BaseItem> getItems() {
        List<BaseItem> list = this.myItems;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette", "getItems"));
        }
        return list;
    }

    @NotNull
    Set<GradleCoordinate> getGradleCoordinates() {
        Set<GradleCoordinate> set = this.myGradleCoordinates;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette", "getGradleCoordinates"));
        }
        return set;
    }

    private static Palette unMarshal(@NotNull Reader xmlReader) throws JAXBException {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/android/tools/idea/uibuilder/palette/Palette", "unMarshal"));
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Palette.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (Palette)unmarshaller.unmarshal(xmlReader);
    }

    private void resolve(@NotNull ViewHandlerManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/uibuilder/palette/Palette", "resolve"));
        }
        for (BaseItem item : this.myItems) {
            item.resolve(manager);
        }
    }

    public static class XmlValuePart {
        @XmlValue
        @Language(value="XML")
        @Nullable
        private String myValue;
        @XmlAttribute(name="reuse")
        private String myReuse;

        @Nullable
        public String getValue() {
            return this.myValue;
        }

        private boolean reuseFor(@NotNull String part) {
            if (part == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "part", "com/android/tools/idea/uibuilder/palette/Palette$XmlValuePart", "reuseFor"));
            }
            return this.myReuse != null && Splitter.on((String)",").trimResults().splitToList((CharSequence)this.myReuse).contains(part);
        }

        public boolean reuseForPreview() {
            return this.reuseFor("preview");
        }

        public boolean reuseForDragPreview() {
            return this.reuseFor("drag-preview");
        }
    }

    public static class Item
    implements BaseItem {
        @XmlAttribute(required=true, name="tag")
        @NotNull
        private String myTagName;
        @XmlAttribute(name="id")
        @Nullable
        private String myId;
        @XmlAttribute(name="title")
        @Nullable
        private String myTitle;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        @XmlAttribute(name="coordinate")
        @Nullable
        private String myGradleCoordinate;
        @XmlAttribute(name="scale")
        @Nullable
        private Double myPreviewScale;
        @XmlAttribute(name="render-separately")
        @Nullable
        private Boolean myPreviewRenderSeparately;
        @XmlElement(name="xml", type=XmlValuePart.class)
        private XmlValuePart myXmlValuePart;
        @Language(value="XML")
        @Nullable
        private String myXml;
        @XmlElement(name="preview")
        @Language(value="XML")
        @Nullable
        private String myPreviewXml;
        @XmlElement(name="drag-preview")
        @Language(value="XML")
        @Nullable
        private String myDragPreviewXml;
        private PaletteComponentHandler myHandler;

        @NotNull
        public String getTagName() {
            String string = this.myTagName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getTagName"));
            }
            return string;
        }

        @NotNull
        public String getId() {
            String string = this.myId != null ? this.myId : this.myTagName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getId"));
            }
            return string;
        }

        @NotNull
        public String getTitle() {
            if (this.myTitle != null) {
                String string = this.myTitle;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getTitle"));
                }
                return string;
            }
            String string = this.myHandler.getTitle(this.myTagName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getTitle"));
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon;
            if (this.myIconName != null && (icon = IconLoader.findIcon((String)this.myIconName, this.getClass())) != null) {
                Icon icon2 = icon;
                if (icon2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getIcon"));
                }
                return icon2;
            }
            Icon icon3 = this.myHandler.getIcon(this.myTagName);
            if (icon3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getIcon"));
            }
            return icon3;
        }

        @Nullable
        public String getGradleCoordinate() {
            if (this.myGradleCoordinate != null) {
                return this.myGradleCoordinate;
            }
            return this.myHandler.getGradleCoordinate(this.myTagName);
        }

        @NotNull
        @Language(value="XML")
        public String getXml() {
            if (this.myXml != null) {
                String string = this.myXml;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getXml"));
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.COMPONENT_CREATION);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getXml"));
            }
            return string;
        }

        @NotNull
        @Language(value="XML")
        public String getPreviewXml() {
            if (this.myPreviewXml != null) {
                String string = this.myPreviewXml;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getPreviewXml"));
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.PREVIEW_ON_PALETTE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getPreviewXml"));
            }
            return string;
        }

        @NotNull
        @Language(value="XML")
        public String getDragPreviewXml() {
            if (this.myDragPreviewXml != null) {
                String string = this.myDragPreviewXml;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getDragPreviewXml"));
                }
                return string;
            }
            String string = this.myHandler.getXml(this.myTagName, XmlType.DRAG_PREVIEW);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "getDragPreviewXml"));
            }
            return string;
        }

        public double getPreviewScale() {
            if (this.myPreviewScale != null) {
                return this.myPreviewScale;
            }
            return this.myHandler.getPreviewScale(this.myTagName);
        }

        public boolean isPreviewRenderedSeparately() {
            if (this.myPreviewRenderSeparately != null) {
                return this.myPreviewRenderSeparately;
            }
            return false;
        }

        @Override
        public void resolve(@NotNull ViewHandlerManager manager) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/uibuilder/palette/Palette$Item", "resolve"));
            }
            this.myHandler = manager.getHandlerOrDefault(this.myTagName);
            if (this.myXmlValuePart != null) {
                this.myXml = this.myXmlValuePart.getValue();
                if (this.myPreviewXml == null && this.myXmlValuePart.reuseForPreview()) {
                    this.myPreviewXml = this.addId(this.myXml);
                }
                if (this.myDragPreviewXml == null && this.myXmlValuePart.reuseForDragPreview()) {
                    this.myDragPreviewXml = this.myXml;
                }
                this.myXmlValuePart = null;
            }
        }

        @Language(value="XML")
        @Nullable
        private String addId(@Nullable @Language(value="XML") String xml) {
            if (xml == null || this.myId == null) {
                return xml;
            }
            int index = xml.indexOf("<" + this.myTagName);
            if (index < 0) {
                return xml;
            }
            return xml.substring(0, index += 1 + this.myTagName.length()) + "\n  android:id=\"@+id/" + this.getId() + "\"\n" + xml.substring(index);
        }

        @NotNull
        public String toString() {
            String string = this.myTagName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Item", "toString"));
            }
            return string;
        }
    }

    public static class Group
    implements BaseItem {
        @XmlAttribute(required=true, name="name")
        @NotNull
        private String myName;
        @XmlElements(value={@XmlElement(name="group", type=Group.class), @XmlElement(name="item", type=Item.class)})
        private List<BaseItem> myItems = Lists.newArrayList();

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Group", "getName"));
            }
            return string;
        }

        @NotNull
        public List<BaseItem> getItems() {
            List<BaseItem> list = this.myItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Group", "getItems"));
            }
            return list;
        }

        @NotNull
        public BaseItem getItem(int index) {
            BaseItem baseItem = this.myItems.get(index);
            if (baseItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Group", "getItem"));
            }
            return baseItem;
        }

        @Override
        public void resolve(@NotNull ViewHandlerManager manager) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/uibuilder/palette/Palette$Group", "resolve"));
            }
            for (BaseItem item : this.myItems) {
                item.resolve(manager);
            }
        }

        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/Palette$Group", "toString"));
            }
            return string;
        }
    }

    static interface BaseItem {
        public void resolve(@NotNull ViewHandlerManager var1);
    }
}

