/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.editor.NlPropertiesWindowManager;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.designer.LightToolWindowContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
implements DesignSurfaceListener,
ModelListener,
LightToolWindowContent {
    public static final int UPDATE_DELAY_MSECS = 250;
    private final Project myProject;
    private final JBLoadingPanel myLoadingPanel;
    private final NlPropertiesPanel myPropertiesPanel;
    private final NlPropertyEditors myEditors;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private ScreenView myScreenView;
    @Nullable
    private List<DesignSurfaceChangedListener> mySurfaceChangedListeners;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad;
    private boolean myLoading;

    public NlPropertiesManager(@NotNull Project project, @Nullable DesignSurface designSurface) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "<init>"));
        }
        this.myFirstLoad = true;
        this.myProject = project;
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project, 20);
        this.myEditors = NlPropertyEditors.getInstance(project);
        this.myPropertiesPanel = new NlPropertiesPanel(project);
        this.myLoadingPanel.add((Component)this.myPropertiesPanel);
        this.setDesignSurface(designSurface);
    }

    @NotNull
    public AnAction[] getActions() {
        AnAction[] anActionArray = new AnAction[]{new ViewAllPropertiesAction(this.myPropertiesPanel)};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getActions"));
        }
        return anActionArray;
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setScreenView(null);
        } else {
            this.mySurface.addListener(this);
            ScreenView screenView = this.mySurface.getCurrentScreenView();
            this.setScreenView(screenView);
            List<NlComponent> selection = screenView != null ? screenView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
        this.notifyDesignSurfaceChanged(this.mySurface);
    }

    private void notifyDesignSurfaceChanged(@Nullable DesignSurface surface) {
        if (this.mySurfaceChangedListeners == null || this.mySurfaceChangedListeners.isEmpty()) {
            return;
        }
        for (DesignSurfaceChangedListener mySurfaceChangedListener : this.mySurfaceChangedListeners) {
            mySurfaceChangedListener.surfaceChanged(surface);
        }
    }

    public void addSurfaceChangedListener(@NotNull DesignSurfaceChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "addSurfaceChangedListener"));
        }
        if (this.mySurfaceChangedListeners == null) {
            this.mySurfaceChangedListeners = new ArrayList<DesignSurfaceChangedListener>(2);
        }
        this.mySurfaceChangedListeners.remove(listener);
        this.mySurfaceChangedListeners.add(listener);
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    private void setScreenView(@Nullable ScreenView screenView) {
        if (screenView == this.myScreenView) {
            return;
        }
        if (this.myScreenView != null) {
            this.myScreenView.getModel().removeListener(this);
        }
        this.myScreenView = screenView;
        if (this.myScreenView != null) {
            this.myScreenView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getProject"));
        }
        return project;
    }

    @NotNull
    public NlPropertyEditors getPropertyEditors() {
        NlPropertyEditors nlPropertyEditors = this.myEditors;
        if (nlPropertyEditors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getPropertyEditors"));
        }
        return nlPropertyEditors;
    }

    @NotNull
    public JComponent getConfigurationPanel() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getConfigurationPanel"));
        }
        return jBLoadingPanel;
    }

    @Nullable
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        return this.myUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "setSelectedComponents"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "lambda$setSelectedComponents$1"));
            }
            Table<String, String, NlPropertyItem> properties = !components.isEmpty() ? NlProperties.getInstance().getProperties(components) : ImmutableTable.of();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (components == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "lambda$null$0"));
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myPropertiesPanel.setItems(components, properties, this);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
        }
        if (components.isEmpty()) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
            }
            return propertiesMap;
        }
        if (this.mySurface == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
            }
            return propertiesMap;
        }
        ScreenView view = this.mySurface.getCurrentScreenView();
        if (view == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
            }
            return propertiesMap;
        }
        Map<Object, PropertiesMap> map = view.getModel().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component : components) {
            PropertiesMap propertiesMap = map.get(component.getSnapshot());
            if (propertiesMap == null) {
                PropertiesMap propertiesMap2 = PropertiesMap.EMPTY_MAP;
                if (propertiesMap2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
                }
                return propertiesMap2;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            PropertiesMap propertiesMap = first;
            if (propertiesMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
            }
            return propertiesMap;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property.getValue()).equals(other.get(property.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property.getKey(), property.getValue());
        }
        PropertiesMap propertiesMap = commonProperties;
        if (propertiesMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "getDefaultProperties"));
        }
        return propertiesMap;
    }

    public void setValue(@NotNull NlProperty property, @Nullable String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "setValue"));
        }
        property.setValue(value);
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "componentSelectionChanged"));
        }
        if (newSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSelection", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "componentSelectionChanged"));
        }
        if (surface != this.mySurface) {
            return;
        }
        MergingUpdateQueue queue = this.getUpdateQueue();
        if (queue == null) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.myLoadingPanel.startLoading();
        }
        this.myLoading = true;
        queue.queue(new Update("updateProperties"){

            public void run() {
                NlPropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)NlPropertiesManager.this.myLoadingPanel).stopLoading());
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "screenChanged"));
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "modelChanged"));
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "activatePreferredEditor"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "activatePreferredEditor"));
        }
        if (!NlPropertiesWindowManager.get(this.myProject).isActivePropertiesManager(this)) {
            return false;
        }
        return this.myPropertiesPanel.activatePreferredEditor(this.myLoading);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "modelChanged"));
        }
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/property/NlPropertiesManager", "modelRendered"));
        }
        this.myPropertiesPanel.modelRendered(this);
    }

    public void dispose() {
        this.setDesignSurface(null);
    }

    public static interface DesignSurfaceChangedListener {
        public void surfaceChanged(@Nullable DesignSurface var1);
    }
}

