/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlIdPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.util.PropertiesMap;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertyItem
extends PTableItem
implements NlProperty {
    private static final Set<String> ATTRS_WITHOUT_DEFINITIONS = ImmutableSet.of((Object)"style", (Object)"class", (Object)"layout");
    @NotNull
    protected final List<NlComponent> myComponents;
    @Nullable
    protected final AttributeDefinition myDefinition;
    @NotNull
    private final String myName;
    @Nullable
    private final String myNamespace;
    @Nullable
    private PropertiesMap.Property myDefaultValue;

    public static NlPropertyItem create(@NotNull List<NlComponent> components, @NotNull XmlAttributeDescriptor descriptor, @Nullable String namespace, @Nullable AttributeDefinition attributeDefinition) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "create"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "create"));
        }
        if (attributeDefinition != null && attributeDefinition.getFormats().contains((Object)AttributeFormat.Flag)) {
            return new NlFlagPropertyItem(components, descriptor, namespace, attributeDefinition);
        }
        if (descriptor.getName().equals("id")) {
            return new NlIdPropertyItem(components, descriptor, attributeDefinition);
        }
        return new NlPropertyItem(components, descriptor, namespace, attributeDefinition);
    }

    protected NlPropertyItem(@NotNull List<NlComponent> components, @NotNull XmlAttributeDescriptor descriptor, @Nullable String namespace, @Nullable AttributeDefinition attributeDefinition) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        assert (!components.isEmpty());
        if (namespace == null) {
            String string = namespace = descriptor instanceof NamespaceAwareXmlAttributeDescriptor ? ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(components.get(0).getTag()) : null;
        }
        if (attributeDefinition == null && !ATTRS_WITHOUT_DEFINITIONS.contains(descriptor.getName()) && !"http://schemas.android.com/tools".equals(namespace)) {
            throw new IllegalArgumentException("Missing attribute definition for " + descriptor.getName());
        }
        this.myComponents = components;
        this.myName = descriptor.getName();
        this.myNamespace = namespace;
        this.myDefinition = attributeDefinition;
    }

    public NlPropertyItem(@NotNull List<NlComponent> components, @NotNull String namespace, @Nullable AttributeDefinition attributeDefinition) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        assert (!components.isEmpty());
        assert (attributeDefinition != null);
        this.myComponents = components;
        this.myName = attributeDefinition.getName();
        this.myNamespace = namespace;
        this.myDefinition = attributeDefinition;
    }

    protected NlPropertyItem(@NotNull NlPropertyItem property, @NotNull String namespace) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "<init>"));
        }
        assert (!property.myComponents.isEmpty());
        this.myComponents = property.myComponents;
        this.myName = property.myName;
        this.myNamespace = namespace;
        this.myDefinition = property.myDefinition;
        if (property.getParent() != null) {
            PTableGroupItem group = (PTableGroupItem)property.getParent();
            group.addChild(this, property);
        }
    }

    public boolean sameDefinition(@Nullable NlPropertyItem other) {
        return other != null && Objects.equal((Object)this.myName, (Object)other.myName) && Objects.equal((Object)this.myNamespace, (Object)other.myNamespace) && this.myDefinition == other.myDefinition;
    }

    @Override
    @NotNull
    public List<NlComponent> getComponents() {
        List<NlComponent> list = this.myComponents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setDefaultValue(@Nullable PropertiesMap.Property defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public boolean isValueUnset() {
        return this.getValue(true) == null;
    }

    @Nullable
    private String getValue(boolean raw) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String prev = null;
        for (NlComponent component : this.myComponents) {
            String value = this.getComponentValue(component, raw);
            if (value == null) {
                return null;
            }
            if (prev == null) {
                prev = value;
                continue;
            }
            if (value.equals(prev)) continue;
            return null;
        }
        return prev;
    }

    private String getComponentValue(@NotNull NlComponent component, boolean raw) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getComponentValue"));
        }
        String value = component.getAttribute(this.myNamespace, this.myName);
        if (raw) {
            return value;
        }
        return value == null && this.myDefaultValue != null ? this.myDefaultValue.resource : value;
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        String value = this.getValue();
        if (value != null) {
            value = this.resolveValue(value);
        }
        return value;
    }

    @Override
    public boolean isDefaultValue(@Nullable String value) {
        if (value == null) {
            return true;
        }
        if (this.myDefaultValue == null) {
            return false;
        }
        return value.equals(this.myDefaultValue.resource);
    }

    @Override
    @NotNull
    public String resolveValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "resolveValue"));
        }
        if (this.myDefaultValue != null && this.myDefaultValue.value != null && this.isDefaultValue(value)) {
            if (this.myDefaultValue.value == null) {
                this.myDefaultValue = new PropertiesMap.Property(this.myDefaultValue.resource, this.resolveValueUsingResolver(this.myDefaultValue.resource));
            }
            String string = this.myDefaultValue.value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "resolveValue"));
            }
            return string;
        }
        String string = this.resolveValueUsingResolver(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "resolveValue"));
        }
        return string;
    }

    public void delete() {
        PTableGroupItem group = (PTableGroupItem)this.getParent();
        if (group != null) {
            group.deleteChild(this);
        }
    }

    @NotNull
    private String resolveValueUsingResolver(@NotNull String value) {
        ResourceResolver resolver;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "resolveValueUsingResolver"));
        }
        if ((value.startsWith("?") || value.startsWith("@") && !NlPropertyItem.isId(value)) && (resolver = this.getResolver()) != null) {
            ResourceValue resource = resolver.findResValue(value, false);
            if (resource == null) {
                resource = resolver.findResValue(value, true);
            }
            if (resource != null) {
                ResourceValue resolved;
                if (resource.getValue() != null) {
                    value = resource.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
                if ((resolved = resolver.resolveResValue(resource)) != null && resolved.getValue() != null) {
                    value = resolved.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
            }
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "resolveValueUsingResolver"));
        }
        return string;
    }

    @NotNull
    private static String addAndroidPrefix(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "addAndroidPrefix"));
        }
        if (value.startsWith("@") && !value.startsWith("@android:")) {
            String string = "@android:" + value.substring(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "addAndroidPrefix"));
            }
            return string;
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "addAndroidPrefix"));
        }
        return string;
    }

    private static boolean isId(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "isId"));
        }
        return value.startsWith("@id/") || value.startsWith("@+id/") || value.startsWith("@android:id/") || value.startsWith("@android:+id/");
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        if (itemName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemName", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getChildProperty"));
        }
        throw new UnsupportedOperationException(itemName);
    }

    @Override
    @NotNull
    public NlPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.myNamespace)) {
            NlPropertyItem nlPropertyItem = this;
            if (nlPropertyItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getDesignTimeProperty"));
            }
            return nlPropertyItem;
        }
        NlPropertyItem nlPropertyItem = new NlPropertyItem(this, "http://schemas.android.com/tools");
        if (nlPropertyItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getDesignTimeProperty"));
        }
        return nlPropertyItem;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myComponents.get(0).getModel();
        if (nlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getModel"));
        }
        return nlModel;
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        return this.myComponents.size() == 1 ? this.myComponents.get(0).getTag() : null;
    }

    @Override
    @Nullable
    public String getTagName() {
        String tagName = null;
        for (NlComponent component : this.myComponents) {
            if (tagName == null) {
                tagName = component.getTagName();
                continue;
            }
            if (tagName.equals(component.getTagName())) continue;
            return null;
        }
        return tagName;
    }

    @Override
    @Nullable
    public ResourceResolver getResolver() {
        Configuration configuration = this.getModel().getConfiguration();
        if (configuration == null) {
            return null;
        }
        return configuration.getResourceResolver();
    }

    @Override
    public void setValue(Object value) {
        String strValue;
        assert (ApplicationManager.getApplication().isDispatchThread());
        if (this.getModel().getProject().isDisposed()) {
            return;
        }
        String string = strValue = value == null ? null : value.toString();
        if (StringUtil.isEmpty((String)strValue) || this.isDefaultValue(strValue)) {
            strValue = null;
        }
        final String attrValue = strValue;
        NlComponent first = this.myComponents.get(0);
        String componentName = this.myComponents.size() == 1 ? first.getTagName() : "Multiple";
        String msg = String.format("Set %1$s.%2$s to %3$s", componentName, this.myName, attrValue);
        new WriteCommandAction.Simple(this.getModel().getProject(), msg, new PsiFile[]{first.getTag().getContainingFile()}){

            protected void run() throws Throwable {
                for (NlComponent component : NlPropertyItem.this.myComponents) {
                    String v = StringUtil.isEmpty((String)attrValue) ? null : attrValue;
                    component.setAttribute(NlPropertyItem.this.myNamespace, NlPropertyItem.this.myName, v);
                }
            }
        }.execute();
        if ("merge".equals(componentName) && "http://schemas.android.com/tools".equals(this.getNamespace()) && "parentTag".equals(this.getName())) {
            this.getModel().getSelectionModel().updateListeners();
        }
    }

    @NotNull
    public List<String> getParentStylables() {
        List<String> list = this.myDefinition == null ? Collections.emptyList() : this.myDefinition.getParentStyleables();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getParentStylables"));
        }
        return list;
    }

    @Override
    @Nullable
    public AttributeDefinition getDefinition() {
        return this.myDefinition;
    }

    @Override
    @NotNull
    public TableCellRenderer getCellRenderer() {
        TableCellRenderer tableCellRenderer = NlPropertyRenderers.get(this);
        if (tableCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "getCellRenderer"));
        }
        return tableCellRenderer;
    }

    @Override
    public boolean isEditable(int col) {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.myName).add("namespace", (Object)NlPropertyItem.namespaceToPrefix(this.myNamespace)).toString();
    }

    @Override
    public String getTooltipText() {
        String value;
        StringBuilder sb = new StringBuilder(100);
        sb.append(NlPropertyItem.namespaceToPrefix(this.myNamespace));
        sb.append(this.myName);
        if (this.myDefinition != null && (value = this.myDefinition.getDocValue(null)) != null) {
            sb.append(": ");
            sb.append(value);
        }
        return sb.toString();
    }

    @NotNull
    private static String namespaceToPrefix(@Nullable String namespace) {
        if (namespace != null && "http://schemas.android.com/apk/res/android".equalsIgnoreCase(namespace)) {
            if ("@android:" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "namespaceToPrefix"));
            }
            return "@android:";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertyItem", "namespaceToPrefix"));
        }
        return "";
    }
}

