/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IdAnalyzer {
    private final NlProperty myProperty;
    private final Set<String> myReservedIds;
    private final PropertyGroup myPropertyGroup;
    private final Set<String> myResult;
    private static final PropertyGroup DEFAULT_GROUP = new PropertyGroup("http://schemas.android.com/apk/res/android", (List<String>)ImmutableList.of());
    private static final PropertyGroup RELATIVE_LAYOUT_GROUP = new SiblingValuePropertyGroup("http://schemas.android.com/apk/res/android", (List<String>)ImmutableList.of((Object)"layout_toRightOf", (Object)"layout_toLeftOf", (Object)"layout_above", (Object)"layout_below", (Object)"layout_alignBaseline", (Object)"layout_alignLeft", (Object)"layout_alignTop", (Object)"layout_alignRight", (Object)"layout_alignBottom", (Object)"layout_alignStart", (Object)"layout_alignEnd", (Object)"layout_toStartOf", (Object[])new String[]{"layout_toEndOf"}));
    private static final PropertyGroup CONSTRAINT_LAYOUT_GROUP = new SiblingValuePropertyGroup("http://schemas.android.com/apk/res-auto", (List<String>)ImmutableList.of((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintLeft_toRightOf", (Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintTop_toBottomOf", (Object)"layout_constraintBottom_toTopOf", (Object)"layout_constraintBottom_toBottomOf", (Object)"layout_constraintBaseline_toBaselineOf"));
    private static final PropertyGroup RADIO_GROUP = new ChildTagPropertyGroup("http://schemas.android.com/apk/res-auto", (List<String>)ImmutableList.of((Object)"checkedButton"), "RadioButton");
    private static final List<PropertyGroup> PROPERTY_GROUPS = ImmutableList.of((Object)RELATIVE_LAYOUT_GROUP, (Object)CONSTRAINT_LAYOUT_GROUP, (Object)RADIO_GROUP);

    @NotNull
    public static List<String> findIdsForProperty(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "findIdsForProperty"));
        }
        List<String> list = new IdAnalyzer(property).findIds();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "findIdsForProperty"));
        }
        return list;
    }

    private IdAnalyzer(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "<init>"));
        }
        this.myProperty = property;
        this.myPropertyGroup = IdAnalyzer.findPropertyGroup(property.getName());
        this.myReservedIds = new HashSet<String>();
        this.myResult = new HashSet<String>();
    }

    private List<String> findIds() {
        this.myPropertyGroup.findIds(this);
        return this.myResult.stream().sorted().collect(Collectors.toList());
    }

    private static PropertyGroup findPropertyGroup(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "findPropertyGroup"));
        }
        for (PropertyGroup group : PROPERTY_GROUPS) {
            if (!group.myAttributes.contains(attributeName)) continue;
            return group;
        }
        return DEFAULT_GROUP;
    }

    private void findIdsAmongSiblings() {
        List parents = this.myProperty.getComponents().stream().map(NlComponent::getParent).distinct().collect(Collectors.toList());
        if (parents.size() == 1) {
            NlComponent parent = (NlComponent)parents.get(0);
            this.reserveAllSelectedIds();
            if (!this.myReservedIds.isEmpty()) {
                this.reserveAllIdsWithTransitiveReferencesToSelectedIds(parent);
            }
            parent.getChildren().stream().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).filter(id -> !this.myReservedIds.contains(id)).forEach(this.myResult::add);
        }
    }

    private void reserveAllSelectedIds() {
        this.myProperty.getComponents().stream().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).forEach(this.myReservedIds::add);
    }

    private void reserveAllIdsWithTransitiveReferencesToSelectedIds(@NotNull NlComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "reserveAllIdsWithTransitiveReferencesToSelectedIds"));
        }
        HashMultimap referenceMap = HashMultimap.create();
        for (NlComponent component : parent.getChildren()) {
            String id2 = component.getId();
            if (StringUtil.isEmpty((String)id2)) continue;
            for (String attribute : this.myPropertyGroup.myAttributes) {
                String referenced = NlComponent.stripId(component.getAttribute(this.myPropertyGroup.myNamespace, attribute));
                if (referenced == null) continue;
                referenceMap.put((Object)referenced, (Object)id2);
            }
        }
        HashSet<String> references = new HashSet<String>(this.myReservedIds);
        while (!references.isEmpty()) {
            String reference = (String)references.iterator().next();
            references.remove(reference);
            this.myReservedIds.add(reference);
            referenceMap.get((Object)reference).stream().filter(id -> !this.myReservedIds.contains(id)).forEach(references::add);
        }
    }

    private void findChildIdsWithTagName(@NotNull String childTagName) {
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "findChildIdsWithTagName"));
        }
        List<NlComponent> components = this.myProperty.getComponents();
        if (components.size() == 1) {
            components.get(0).getChildren().stream().filter(component -> {
                if (childTagName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer", "lambda$findChildIdsWithTagName$4"));
                }
                return component.getTagName().equals(childTagName);
            }).map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).forEach(this.myResult::add);
        }
    }

    private void findAllIds() {
        this.reserveAllSelectedIds();
        this.myProperty.getModel().flattenComponents().map(NlComponent::getId).filter(id -> !StringUtil.isEmpty((String)id)).filter(id -> !this.myReservedIds.contains(id)).forEach(this.myResult::add);
    }

    private static class ChildTagPropertyGroup
    extends PropertyGroup {
        private final String myChildTagName;

        ChildTagPropertyGroup(@NotNull String namespace, @NotNull List<String> attributes, @NotNull String childTagName) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$ChildTagPropertyGroup", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$ChildTagPropertyGroup", "<init>"));
            }
            if (childTagName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$ChildTagPropertyGroup", "<init>"));
            }
            super(namespace, attributes);
            this.myChildTagName = childTagName;
        }

        @Override
        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$ChildTagPropertyGroup", "findIds"));
            }
            analyzer.findChildIdsWithTagName(this.myChildTagName);
        }
    }

    private static class SiblingValuePropertyGroup
    extends PropertyGroup {
        SiblingValuePropertyGroup(@NotNull String namespace, @NotNull List<String> attributes) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$SiblingValuePropertyGroup", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$SiblingValuePropertyGroup", "<init>"));
            }
            super(namespace, attributes);
        }

        @Override
        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$SiblingValuePropertyGroup", "findIds"));
            }
            analyzer.findIdsAmongSiblings();
        }
    }

    private static class PropertyGroup {
        private final String myNamespace;
        private final List<String> myAttributes;

        PropertyGroup(@NotNull String namespace, @NotNull List<String> attributes) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$PropertyGroup", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$PropertyGroup", "<init>"));
            }
            this.myNamespace = namespace;
            this.myAttributes = attributes;
        }

        protected void findIds(@NotNull IdAnalyzer analyzer) {
            if (analyzer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzer", "com/android/tools/idea/uibuilder/property/editors/IdAnalyzer$PropertyGroup", "findIds"));
            }
            analyzer.findAllIds();
        }
    }
}

