/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanvasResizeInteraction
extends Interaction {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final String[] DEVICES_TO_SHOW = new String[]{"Nexus 5", "Nexus 6P", "Nexus 7", "Nexus 9", "Nexus 10"};
    private final DesignSurface myDesignSurface;
    private final boolean isPreviewSurface;
    private final List<FolderConfiguration> myFolderConfigurations;
    private final UnavailableSizesLayer myUnavailableLayer = new UnavailableSizesLayer();
    private final OrientationLayer myOrientationLayer;
    private final List<DeviceLayer> myDeviceLayers = Lists.newArrayList();
    private final Device myOriginalDevice;
    private final State myOriginalDeviceState;
    private final Map<Point, Device> myAndroidCoordinatesToDeviceMap = Maps.newHashMapWithExpectedSize((int)DEVICES_TO_SHOW.length);
    private int myCurrentX;
    private int myCurrentY;

    public CanvasResizeInteraction(DesignSurface designSurface) {
        List<Object> devicesToShow;
        this.myDesignSurface = designSurface;
        this.isPreviewSurface = designSurface.isPreviewSurface();
        this.myOrientationLayer = new OrientationLayer(this.myDesignSurface);
        Configuration config = this.myDesignSurface.getConfiguration();
        assert (config != null);
        this.myOriginalDevice = config.getDevice();
        this.myOriginalDeviceState = config.getDeviceState();
        VirtualFile file = config.getFile();
        assert (file != null);
        String layoutName = file.getNameWithoutExtension();
        ProjectResourceRepository resourceRepository = ProjectResourceRepository.getProjectResources(config.getModule(), true);
        assert (resourceRepository != null);
        List layouts = resourceRepository.getItems().get(ResourceType.LAYOUT).get((Object)layoutName);
        this.myFolderConfigurations = layouts.stream().map(ResourceItem::getConfiguration).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        double currentDpi = config.getDensity().getDpiValue();
        ConfigurationManager configManager = config.getConfigurationManager();
        boolean addSmallScreen = false;
        if (HardwareConfigHelper.isWear((Device)this.myOriginalDevice)) {
            devicesToShow = configManager.getDevices().stream().filter(d -> HardwareConfigHelper.isWear((Device)d) && !"Custom".equals(d.getId())).collect(Collectors.toList());
        } else if (HardwareConfigHelper.isTv((Device)this.myOriginalDevice)) {
            devicesToShow = Collections.singletonList(configManager.getDeviceById("tv_1080p"));
        } else {
            devicesToShow = Lists.newArrayListWithExpectedSize((int)DEVICES_TO_SHOW.length);
            for (String id : DEVICES_TO_SHOW) {
                devicesToShow.add(configManager.getDeviceById(id));
            }
            addSmallScreen = true;
        }
        for (Device device : devicesToShow) {
            assert (device != null);
            Screen screen = device.getDefaultHardware().getScreen();
            double dpiRatio = currentDpi / (double)screen.getPixelDensity().getDpiValue();
            Point p = new Point((int)((double)screen.getXDimension() * dpiRatio), (int)((double)screen.getYDimension() * dpiRatio));
            this.myAndroidCoordinatesToDeviceMap.put(p, device);
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, p.x, p.y, device.getDisplayName()));
        }
        if (addSmallScreen) {
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, (int)(426.0 * currentDpi / 160.0), (int)(320.0 * currentDpi / 160.0), "Small Screen"));
        }
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        super.begin(x, y, startMask);
        this.myCurrentX = x;
        this.myCurrentY = y;
        ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        screenView.getSurface().setResizeMode(true);
        this.updateUnavailableLayer(screenView);
    }

    public void updatePosition(int x, int y) {
        ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        int androidX = Coordinates.getAndroidX(screenView, x);
        int androidY = Coordinates.getAndroidY(screenView, y);
        if (androidX > 0 && androidY > 0) {
            screenView.getModel().overrideConfigurationScreenSize(androidX, androidY);
            if (this.isPreviewSurface) {
                this.updateUnavailableLayer(screenView);
            }
        }
    }

    private void updateUnavailableLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction", "updateUnavailableLayer"));
        }
        Configuration config = screenView.getConfiguration();
        FolderConfiguration currentFolderConfig = FolderConfiguration.getConfigForFolder((String)config.getFile().getParent().getNameWithoutExtension());
        assert (currentFolderConfig != null);
        if (currentFolderConfig.equals((Object)this.myUnavailableLayer.getCurrentFolderConfig())) {
            return;
        }
        ArrayList configAreas = Lists.newArrayList();
        Area totalCoveredArea = new Area();
        for (FolderConfiguration configuration : this.myFolderConfigurations) {
            Area configArea = this.coveredAreaForConfig(configuration, screenView);
            configArea.subtract(totalCoveredArea);
            if (!configuration.equals((Object)currentFolderConfig)) {
                configAreas.add(configArea);
            }
            totalCoveredArea.add(configArea);
        }
        this.myUnavailableLayer.update(configAreas, currentFolderConfig);
    }

    @NotNull
    private Area coveredAreaForConfig(@NotNull FolderConfiguration config, @NotNull ScreenView screenView) {
        ScreenRatioQualifier ratioQualifier;
        ScreenSizeQualifier sizeQualifier;
        ScreenHeightQualifier heightQualifier;
        ScreenWidthQualifier widthQualifier;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction", "coveredAreaForConfig"));
        }
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction", "coveredAreaForConfig"));
        }
        int x0 = screenView.getX();
        int y0 = screenView.getY();
        int width = this.myDesignSurface.getWidth();
        int height = this.myDesignSurface.getHeight();
        int maxDim = Math.max(width, height);
        int minX = 0;
        int maxX = -1;
        int minY = 0;
        int maxY = -1;
        int dpi = screenView.getConfiguration().getDensity().getDpiValue();
        SmallestScreenWidthQualifier smallestWidthQualifier = config.getSmallestScreenWidthQualifier();
        if (smallestWidthQualifier != null) {
            minX = smallestWidthQualifier.getValue() * dpi / 160;
            minY = smallestWidthQualifier.getValue() * dpi / 160;
        }
        if ((widthQualifier = config.getScreenWidthQualifier()) != null) {
            minX = Math.max(minX, widthQualifier.getValue() * dpi / 160);
        }
        if ((heightQualifier = config.getScreenHeightQualifier()) != null) {
            minY = Math.max(minY, heightQualifier.getValue() * dpi / 160);
        }
        if ((sizeQualifier = config.getScreenSizeQualifier()) != null && sizeQualifier.getValue() != null) {
            switch (sizeQualifier.getValue()) {
                case SMALL: {
                    maxX = 320 * dpi / 160;
                    maxY = 470 * dpi / 160;
                    break;
                }
                case NORMAL: {
                    break;
                }
                case LARGE: {
                    minX = 480 * dpi / 160;
                    minY = 640 * dpi / 160;
                    break;
                }
                case XLARGE: {
                    minX = 720 * dpi / 160;
                    minY = 960 * dpi / 160;
                }
            }
        }
        ScreenRatio ratio = (ratioQualifier = config.getScreenRatioQualifier()) != null ? ratioQualifier.getValue() : null;
        ScreenOrientationQualifier orientationQualifier = config.getScreenOrientationQualifier();
        ScreenOrientation orientation = orientationQualifier != null ? orientationQualifier.getValue() : null;
        Polygon portrait = new Polygon();
        Polygon landscape = new Polygon();
        if (orientation == null || orientation.equals((Object)ScreenOrientation.PORTRAIT)) {
            CanvasResizeInteraction.constructPolygon(portrait, ratio, maxDim, true);
            portrait.translate(x0, y0);
        }
        if (orientation == null || orientation.equals((Object)ScreenOrientation.LANDSCAPE)) {
            CanvasResizeInteraction.constructPolygon(landscape, ratio, maxDim, false);
            landscape.translate(x0, y0);
        }
        Area portraitArea = new Area(portrait);
        Area landscapeArea = new Area(landscape);
        Area portraitBounds = new Area(new Rectangle(Coordinates.getSwingX(screenView, minX), Coordinates.getSwingY(screenView, minY), maxX >= 0 ? Coordinates.getSwingDimension(screenView, maxX - minX) : width, maxY >= 0 ? Coordinates.getSwingDimension(screenView, maxY - minY) : height));
        Area landscapeBounds = new Area(new Rectangle(Coordinates.getSwingX(screenView, minY), Coordinates.getSwingY(screenView, minX), maxY >= 0 ? Coordinates.getSwingDimension(screenView, maxY - minY) : width, maxX >= 0 ? Coordinates.getSwingDimension(screenView, maxX - minX) : height));
        portraitArea.intersect(portraitBounds);
        landscapeArea.intersect(landscapeBounds);
        portraitArea.add(landscapeArea);
        Area area = portraitArea;
        if (area == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction", "coveredAreaForConfig"));
        }
        return area;
    }

    private static void constructPolygon(@NotNull Polygon polygon, @Nullable ScreenRatio ratio, int dim, boolean isPortrait) {
        if (polygon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polygon", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction", "constructPolygon"));
        }
        polygon.reset();
        int x1 = isPortrait ? 0 : dim;
        int y1 = isPortrait ? dim : 0;
        int x2 = isPortrait ? dim : 5 * dim / 3;
        int y2 = isPortrait ? 5 * dim / 3 : dim;
        polygon.addPoint(0, 0);
        if (ratio == null) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(dim, dim);
        } else if (ratio == ScreenRatio.LONG) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(x2, y2);
        } else {
            polygon.addPoint(x2, y2);
            polygon.addPoint(dim, dim);
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.myOriginalDevice.isScreenRound()) {
            int deltaX = x - this.myStartX;
            int deltaY = y - this.myStartY;
            if (deltaX > deltaY) {
                y = this.myStartY + deltaX;
            } else {
                x = this.myStartX + deltaY;
            }
        }
        super.update(x, y, modifiers);
        this.myCurrentX = x;
        this.myCurrentY = y;
        if (this.isPreviewSurface || this.myUnavailableLayer.isAvailable(x, y)) {
            this.updatePosition(x, y);
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
        if (screenView == null) {
            return;
        }
        screenView.getSurface().setResizeMode(false);
        screenView.getModel().addListener(new ModelListener(){

            @Override
            public void modelChanged(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$1", "modelChanged"));
                }
            }

            @Override
            public void modelRendered(@NotNull NlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$1", "modelRendered"));
                }
                model.removeListener(this);
            }
        });
        int androidX = Coordinates.getAndroidX(screenView, x);
        int androidY = Coordinates.getAndroidY(screenView, y);
        if (canceled || androidX < 0 || androidY < 0) {
            Configuration configuration = screenView.getConfiguration();
            configuration.setEffectiveDevice(this.myOriginalDevice, this.myOriginalDeviceState);
        } else {
            int snapThreshold = Coordinates.getAndroidDimension(screenView, 20);
            Device deviceToSnap = this.snapToDevice(androidX, androidY, snapThreshold);
            if (deviceToSnap != null) {
                State deviceState = deviceToSnap.getState(androidX < androidY ? "Portrait" : "Landscape");
                this.myDesignSurface.getConfiguration().setEffectiveDevice(deviceToSnap, deviceState);
            } else {
                screenView.getModel().overrideConfigurationScreenSize(androidX, androidY);
            }
        }
    }

    @Nullable(value="null if no device is close enough to snap to")
    private Device snapToDevice(int x, int y, int threshold) {
        for (Point p : this.myAndroidCoordinatesToDeviceMap.keySet()) {
            if ((Math.abs(x - p.x) >= threshold || Math.abs(y - p.y) >= threshold) && (Math.abs(y - p.x) >= threshold || Math.abs(x - p.y) >= threshold)) continue;
            return this.myAndroidCoordinatesToDeviceMap.get(p);
        }
        return null;
    }

    @Override
    public List<Layer> createOverlays() {
        ImmutableList.Builder layers = ImmutableList.builder();
        if (HardwareConfigHelper.isMobile((Device)this.myOriginalDevice)) {
            layers.add((Object)new SizeBucketLayer());
        }
        layers.add((Object)this.myUnavailableLayer);
        layers.addAll(this.myDeviceLayers);
        layers.add((Object)this.myOrientationLayer);
        layers.add((Object)new ResizeLayer());
        return layers.build();
    }

    private class SizeBucketLayer
    extends Layer {
        private final Polygon myClip = new Polygon();
        private final int myTotalHeight;
        private final int myTotalWidth;
        private final FontMetrics myFontMetrics;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myPortraitBuckets;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myLandscapeBuckets;

        public SizeBucketLayer() {
            JScrollPane scrollPane = CanvasResizeInteraction.this.myDesignSurface.getScrollPane();
            this.myTotalHeight = scrollPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
            this.myTotalWidth = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            this.myFontMetrics = CanvasResizeInteraction.this.myDesignSurface.getFontMetrics(CanvasResizeInteraction.this.myDesignSurface.getFont());
            int screenSizeNumbers = ScreenSize.values().length;
            this.myPortraitBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
            this.myLandscapeBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            BufferedImage bucket;
            int height;
            if (g2d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "paint"));
            }
            ScreenView screenView = CanvasResizeInteraction.this.myDesignSurface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            State deviceState = screenView.getConfiguration().getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int width = Coordinates.getAndroidX(screenView, CanvasResizeInteraction.this.myCurrentX);
            if (width > (height = Coordinates.getAndroidY(screenView, CanvasResizeInteraction.this.myCurrentY)) && isDevicePortrait || width < height && !isDevicePortrait) {
                return;
            }
            int dpi = screenView.getConfiguration().getDensity().getDpiValue();
            int small = Math.min(width, height) * 160 / dpi;
            int big = Math.max(width, height) * 160 / dpi;
            ScreenSize screenSizeBucket = this.getScreenSizeBucket(small, big);
            Map<ScreenSize, SoftReference<BufferedImage>> buckets = isDevicePortrait ? this.myPortraitBuckets : this.myLandscapeBuckets;
            SoftReference<BufferedImage> bucketRef = buckets.get(screenSizeBucket);
            BufferedImage bufferedImage = bucket = bucketRef != null ? (BufferedImage)bucketRef.get() : null;
            if (bucket == null) {
                bucket = UIUtil.createImage((int)this.myTotalWidth, (int)this.myTotalHeight, (int)2);
                CanvasResizeInteraction.constructPolygon(this.myClip, null, Math.max(this.myTotalHeight, this.myTotalWidth), isDevicePortrait);
                this.myClip.translate(screenView.getX(), screenView.getY());
                Graphics2D graphics = bucket.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.clip(this.myClip);
                graphics.setColor(NlConstants.RESIZING_BUCKET_COLOR);
                Area coveredArea = this.getAreaForScreenSize(screenSizeBucket, screenView, isDevicePortrait);
                graphics.fill(coveredArea);
                graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.draw(coveredArea);
                graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
                Rectangle bounds = coveredArea.getBounds();
                if (isDevicePortrait) {
                    int left = bounds.x + 5;
                    int bottom = Math.min(bounds.y + bounds.height, this.myTotalHeight) - 5;
                    graphics.drawString(screenSizeBucket.getShortDisplayValue() + " size range", left, bottom);
                } else {
                    String text = screenSizeBucket.getShortDisplayValue() + " size range";
                    Rectangle2D textBounds = this.myFontMetrics.getStringBounds(text, null);
                    int left = (int)((double)Math.min(bounds.x + bounds.width, this.myTotalWidth) - textBounds.getWidth() - 5.0);
                    int bottom = (int)((double)bounds.y + textBounds.getHeight());
                    graphics.drawString(text, left, bottom);
                }
                graphics.dispose();
                buckets.put(screenSizeBucket, (SoftReference<BufferedImage>)new SoftReference((Object)bucket));
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)bucket, null, (int)0, (int)0);
        }

        @NotNull
        private ScreenSize getScreenSizeBucket(int small, int big) {
            if (big < 470) {
                ScreenSize screenSize = ScreenSize.SMALL;
                if (screenSize == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getScreenSizeBucket"));
                }
                return screenSize;
            }
            if (big >= 960 && small >= 720) {
                ScreenSize screenSize = ScreenSize.XLARGE;
                if (screenSize == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getScreenSizeBucket"));
                }
                return screenSize;
            }
            if (big >= 640 && small >= 480) {
                ScreenSize screenSize = ScreenSize.LARGE;
                if (screenSize == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getScreenSizeBucket"));
                }
                return screenSize;
            }
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getScreenSizeBucket"));
            }
            return screenSize;
        }

        @NotNull
        private Area getAreaForScreenSize(@NotNull ScreenSize screenSize, @NotNull ScreenView screenView, boolean isDevicePortrait) {
            if (screenSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenSize", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
            }
            if (screenView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
            }
            int x0 = screenView.getX();
            int y0 = screenView.getY();
            int dpi = screenView.getConfiguration().getDensity().getDpiValue();
            int smallX = Coordinates.getSwingX(screenView, 470 * dpi / 160);
            int smallY = Coordinates.getSwingY(screenView, 470 * dpi / 160);
            Area smallArea = new Area(new Rectangle(x0 - 2, y0 - 2, smallX - x0 + 2, smallY - y0 + 2));
            if (screenSize == ScreenSize.SMALL) {
                Area area = smallArea;
                if (area == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
                }
                return area;
            }
            int xlargeX = Coordinates.getSwingX(screenView, (isDevicePortrait ? 720 : 960) * dpi / 160);
            int xlargeY = Coordinates.getSwingY(screenView, (isDevicePortrait ? 960 : 720) * dpi / 160);
            Area xlargeArea = new Area(new Rectangle(xlargeX, xlargeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.XLARGE) {
                Area area = xlargeArea;
                if (area == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
                }
                return area;
            }
            int largeX = Coordinates.getSwingX(screenView, (isDevicePortrait ? 480 : 640) * dpi / 160);
            int largeY = Coordinates.getSwingY(screenView, (isDevicePortrait ? 640 : 480) * dpi / 160);
            Area largeArea = new Area(new Rectangle(largeX, largeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.LARGE) {
                largeArea.subtract(xlargeArea);
                Area area = largeArea;
                if (area == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
                }
                return area;
            }
            Area normalArea = new Area(new Rectangle(x0 - 2, y0 - 2, this.myTotalWidth, this.myTotalHeight));
            normalArea.subtract(smallArea);
            normalArea.subtract(largeArea);
            Area area = normalArea;
            if (area == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer", "getAreaForScreenSize"));
            }
            return area;
        }
    }

    private static class OrientationLayer
    extends Layer {
        private final Polygon myOrientationPolygon;
        private final double myPortraitWidth;
        private final double myLandscapeWidth;
        private final DesignSurface myDesignSurface;
        private BufferedImage myOrientationImage;
        private ScreenOrientation myLastOrientation;

        public OrientationLayer(@NotNull DesignSurface designSurface) {
            if (designSurface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$OrientationLayer", "<init>"));
            }
            this.myOrientationPolygon = new Polygon();
            this.myDesignSurface = designSurface;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myPortraitWidth = fontMetrics.getStringBounds("Portrait", null).getWidth();
            this.myLandscapeWidth = fontMetrics.getStringBounds("Landscape", null).getWidth();
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            BufferedImage image;
            if (g2d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$OrientationLayer", "paint"));
            }
            ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            State deviceState = screenView.getConfiguration().getDeviceState();
            assert (deviceState != null);
            ScreenOrientation currentOrientation = deviceState.getOrientation();
            boolean isDevicePortrait = currentOrientation == ScreenOrientation.PORTRAIT;
            BufferedImage bufferedImage = image = currentOrientation == this.myLastOrientation ? this.myOrientationImage : null;
            if (image == null) {
                int yL;
                int xL;
                int yP;
                int xP;
                this.myLastOrientation = currentOrientation;
                JScrollPane scrollPane = this.myDesignSurface.getScrollPane();
                int height = scrollPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
                int width = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
                int x0 = screenView.getX();
                int y0 = screenView.getY();
                int maxDim = Math.max(width, height);
                image = UIUtil.createImage((int)maxDim, (int)maxDim, (int)2);
                CanvasResizeInteraction.constructPolygon(this.myOrientationPolygon, null, maxDim, !isDevicePortrait);
                this.myOrientationPolygon.translate(x0, y0);
                Graphics2D graphics = image.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(NlConstants.UNAVAILABLE_ZONE_COLOR);
                graphics.fill(this.myOrientationPolygon);
                if ((double)(height - width) < this.myPortraitWidth / SQRT_2) {
                    xP = height - y0 + x0 - (int)(this.myPortraitWidth * SQRT_2) - 5;
                    yP = height;
                } else {
                    xP = width - (int)(this.myPortraitWidth / SQRT_2) - 5;
                    yP = width - x0 + y0 + (int)(this.myPortraitWidth / SQRT_2);
                }
                if ((double)(height - width) < (double)(y0 - x0) - this.myLandscapeWidth / SQRT_2) {
                    xL = height - y0 + x0 + 5;
                    yL = height;
                } else {
                    xL = width - (int)(this.myLandscapeWidth / SQRT_2);
                    yL = width - x0 + y0 - (int)(this.myLandscapeWidth / SQRT_2) - 5;
                }
                graphics.setColor(Color.DARK_GRAY);
                graphics.rotate(-0.7853981633974483, xL, yL);
                graphics.drawString("Landscape", xL, yL);
                graphics.rotate(0.7853981633974483, xL, yL);
                graphics.rotate(-0.7853981633974483, xP, yP);
                graphics.drawString("Portrait", xP, yP);
                graphics.dispose();
                this.myOrientationImage = image;
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)image, null, (int)0, (int)0);
        }
    }

    private static class DeviceLayer
    extends Layer {
        private final String myName;
        private final DesignSurface myDesignSurface;
        private final int myNameWidth;
        private int myBigDimension;
        private int mySmallDimension;

        public DeviceLayer(@NotNull DesignSurface designSurface, int pxWidth, int pxHeight, @NotNull String name) {
            if (designSurface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designSurface", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$DeviceLayer", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$DeviceLayer", "<init>"));
            }
            this.myDesignSurface = designSurface;
            this.myBigDimension = Math.max(pxWidth, pxHeight);
            this.mySmallDimension = Math.min(pxWidth, pxHeight);
            this.myName = name;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myNameWidth = (int)fontMetrics.getStringBounds(this.myName, null).getWidth();
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$DeviceLayer", "paint"));
            }
            ScreenView screenView = this.myDesignSurface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            State deviceState = screenView.getConfiguration().getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int x = Coordinates.getSwingX(screenView, isDevicePortrait ? this.mySmallDimension : this.myBigDimension);
            int y = Coordinates.getSwingY(screenView, isDevicePortrait ? this.myBigDimension : this.mySmallDimension);
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
            graphics.drawLine(x, y, x - 32, y);
            graphics.drawLine(x, y, x, y - 32);
            graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
            graphics.drawString(this.myName, x - this.myNameWidth - 5, y - 5);
            graphics.dispose();
        }
    }

    private class UnavailableSizesLayer
    extends Layer {
        private Polygon myClip = new Polygon();
        private List<Area> myConfigAreas;
        private FolderConfiguration myCurrentFolderConfig;

        private UnavailableSizesLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$UnavailableSizesLayer", "paint"));
            }
            ScreenView screenView = CanvasResizeInteraction.this.myDesignSurface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            State deviceState = screenView.getConfiguration().getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            CanvasResizeInteraction.constructPolygon(this.myClip, null, Math.max(CanvasResizeInteraction.this.myDesignSurface.getWidth(), CanvasResizeInteraction.this.myDesignSurface.getHeight()), isDevicePortrait);
            this.myClip.translate(screenView.getX() + 1, screenView.getY() + 1);
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.clip(this.myClip);
            int n = 0;
            for (Area configArea : this.myConfigAreas) {
                graphics.setColor(NlConstants.RESIZING_OTHER_CONFIG_COLOR_ARRAY[n++ % NlConstants.RESIZING_OTHER_CONFIG_COLOR_ARRAY.length]);
                graphics.fill(configArea);
            }
            graphics.dispose();
        }

        private boolean isAvailable(int x, int y) {
            for (Area configArea : this.myConfigAreas) {
                if (!configArea.contains(x, y)) continue;
                return false;
            }
            return true;
        }

        private void update(@NotNull List<Area> configAreas, @NotNull FolderConfiguration currentFolderConfig) {
            if (configAreas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configAreas", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$UnavailableSizesLayer", "update"));
            }
            if (currentFolderConfig == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFolderConfig", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$UnavailableSizesLayer", "update"));
            }
            this.myConfigAreas = configAreas;
            this.myCurrentFolderConfig = currentFolderConfig;
        }

        @Nullable
        private FolderConfiguration getCurrentFolderConfig() {
            return this.myCurrentFolderConfig;
        }
    }

    private class ResizeLayer
    extends Layer {
        private ResizeLayer() {
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$ResizeLayer", "paint"));
            }
            ScreenView screenView = CanvasResizeInteraction.this.myDesignSurface.getCurrentScreenView();
            if (screenView == null) {
                return;
            }
            int x = screenView.getX();
            int y = screenView.getY();
            if (CanvasResizeInteraction.this.myCurrentX > x && CanvasResizeInteraction.this.myCurrentY > y) {
                Graphics2D graphics = (Graphics2D)g2d.create();
                graphics.setColor(NlConstants.RESIZING_CONTOUR_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.drawRect(x - 1, y - 1, CanvasResizeInteraction.this.myCurrentX - x, CanvasResizeInteraction.this.myCurrentY - y);
                graphics.dispose();
            }
        }
    }
}

