/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class ConstraintsLayer
extends Layer {
    private final ScreenView myScreenView;
    private final DesignSurface myDesignSurface;
    private Dimension myScreenViewSize;
    private Rectangle mySizeRectangle;
    private final boolean showOnSelection;
    private boolean myShowOnHover;

    public ConstraintsLayer(DesignSurface designSurface, @NotNull ScreenView screenView, boolean showOnSelection) {
        if (screenView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/ConstraintsLayer", "<init>"));
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.myShowOnHover = false;
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
        this.showOnSelection = showOnSelection;
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value) {
        this.myShowOnHover = value;
    }

    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/ConstraintsLayer", "paint"));
        }
        this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, gc.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        NlModel myModel = this.myScreenView.getModel();
        if (!this.myShowOnHover && this.showOnSelection) {
            return;
        }
        if (myModel.getComponents().size() == 0) {
            return;
        }
        NlComponent component = myModel.getComponents().get(0);
        component = component.getRoot();
        Graphics2D g = (Graphics2D)gc.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.drawComponent(g, component, false)) {
            Dimension size = this.myScreenView.getSize();
            if (size.width != 0 && size.height != 0) {
                this.myDesignSurface.repaint(this.myScreenView.getX(), this.myScreenView.getY(), size.width, size.height);
            } else {
                this.myDesignSurface.repaint();
            }
        }
        g.dispose();
    }

    private boolean drawComponent(@NotNull Graphics2D gc, @NotNull NlComponent component, boolean parentHandlesPainting) {
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/ConstraintsLayer", "drawComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/surface/ConstraintsLayer", "drawComponent"));
        }
        if (component.viewInfo != null) {
            ViewGroupHandler viewGroupHandler;
            ViewHandler handler = component.getViewHandler();
            boolean handlesPainting = false;
            if (handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting()) {
                viewGroupHandler.drawGroup(gc, this.myScreenView, component);
                handlesPainting = true;
            }
            if (handler != null) {
                handler.paintConstraints(this.myScreenView, gc, component);
            }
        }
        boolean needsRepaint = false;
        for (NlComponent child : component.getChildren()) {
            needsRepaint |= this.drawComponent(gc, child, parentHandlesPainting);
        }
        return needsRepaint;
    }
}

