/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdk
extends InstallableComponent {
    public AndroidSdk(@NotNull ScopedStateStore store, boolean installUpdates) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/AndroidSdk", "<init>"));
        }
        super(store, "Android SDK", "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.", installUpdates, FileOpUtils.create());
    }

    @Nullable
    private String getLatestCompatibleBuildToolsPath() {
        ProgressIndicatorAdapter progress = new ProgressIndicatorAdapter(){};
        RemotePackage latest = this.mySdkHandler.getLatestRemotePackageForPrefix("build-tools", false, (ProgressIndicator)progress);
        return latest != null ? latest.getPath() : null;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList result = Lists.newArrayList();
        result.add("tools");
        result.add("platform-tools");
        String buildToolsPath = this.getLatestCompatibleBuildToolsPath();
        if (buildToolsPath != null) {
            result.add(buildToolsPath);
        }
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            result.add(repository.getRepositoryLocation(new File(""), false).getPath().substring(1).replace(File.separatorChar, ';'));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidSdk", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
    }

    @Override
    protected boolean isOptionalForSdkLocation() {
        return false;
    }
}

