/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpressions;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelWizardStep<M extends WizardModel>
implements Disposable {
    @NotNull
    private final String myTitle;
    @NotNull
    private M myModel;

    protected ModelWizardStep(@NotNull M model, @NotNull String title) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/wizard/model/ModelWizardStep", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/model/ModelWizardStep", "<init>"));
        }
        this.myModel = model;
        this.myTitle = title;
    }

    @NotNull
    public final String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardStep", "getTitle"));
        }
        return string;
    }

    @NotNull
    protected abstract JComponent getComponent();

    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return null;
    }

    @NotNull
    protected final M getModel() {
        M m = this.myModel;
        if (m == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardStep", "getModel"));
        }
        return m;
    }

    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardStep", "createDependentSteps"));
        }
        return immutableList;
    }

    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/wizard/model/ModelWizardStep", "onWizardStarting"));
        }
    }

    protected boolean shouldShow() {
        return true;
    }

    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = BooleanExpressions.alwaysTrue();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardStep", "canGoForward"));
        }
        return observableBool;
    }

    protected boolean canGoBack() {
        return true;
    }

    protected void onEntering() {
    }

    protected void onProceeding() {
    }

    public void dispose() {
    }

    @Nullable
    protected Action getExtraAction() {
        return null;
    }

    public static abstract class WithoutModel
    extends ModelWizardStep<BlankModel> {
        protected WithoutModel(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/model/ModelWizardStep$WithoutModel", "<init>"));
            }
            super(new BlankModel(), title);
        }
    }

    private static final class BlankModel
    extends WizardModel {
        private BlankModel() {
        }

        @Override
        protected void handleFinished() {
        }
    }
}

