/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.ddms.actions.HierarchyViewAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidRunLayoutInspectorAction
extends AnAction {
    public AndroidRunLayoutInspectorAction() {
        super(AndroidBundle.message("android.ddms.actions.hierarchyview", new Object[0]), AndroidBundle.message("android.ddms.actions.hierarchyview.description", new Object[0]), AndroidIcons.Ddms.HierarchyView);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        if (!AndroidSdkUtils.activateDdmsIfNecessary(project)) {
            return;
        }
        AndroidProcessChooserDialog dialog = new AndroidProcessChooserDialog(project, false);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            Client client = dialog.getClient();
            if (client != null) {
                new HierarchyViewAction.GetClientWindowsTask(project, client).queue();
            } else {
                Logger.getInstance(AndroidRunLayoutInspectorAction.class).warn("Not launching layout inspector - no client selected");
            }
        }
    }
}

