/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.io.File;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceDirectoryDialogBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDirectoryAction
extends CreateResourceActionBase {
    private final ResourceFolderType myResourceFolderType;

    public CreateResourceDirectoryAction() {
        this(null);
    }

    public CreateResourceDirectoryAction(@Nullable ResourceFolderType resourceFolderType) {
        super(AndroidBundle.message("new.resource.dir.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), PlatformIcons.DIRECTORY_CLOSED_ICON);
        this.myResourceFolderType = resourceFolderType;
    }

    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog = newResourceHandler.createNewResourceDirectoryDialog(project, AndroidPsiUtils.getModuleSafely((PsiElement)directory), this.myResourceFolderType, directory, null, resDirectory -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "lambda$invokeDialog$0"));
            }
            return new CreateResourceActionBase.MyInputValidator(project, resDirectory);
        });
        dialog.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        ResourceFolderType folderType = this.myResourceFolderType;
        if (folderType == null) {
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            folderType = CreateResourceFileAction.getUniqueFolderType(files);
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog = newResourceHandler.createNewResourceDirectoryDialog(project, (Module)LangDataKeys.MODULE.getData(dataContext), folderType, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, resDirectory -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "lambda$invokeDialog$1"));
            }
            return new CreateResourceActionBase.MyInputValidator(project, resDirectory);
        });
        dialog.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray = new PsiElement[]{directory.createSubdirectory(newName)};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceDirectoryAction", "create"));
        }
        return psiElementArray;
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.dir.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return AndroidBundle.message("new.resource.dir.action.name", directory.getName() + File.separator + newName);
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }
}

