/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusAdapter;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPrecompileTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidPrecompileTask");

    public boolean execute(CompileContext context) {
        Project project = context.getProject();
        if (!AndroidFacet.hasAndroid(project)) {
            return true;
        }
        BuildManager.forceModelLoading((CompileContext)context);
        AndroidPrecompileTask.createGenModulesAndSourceRoots(project);
        return true;
    }

    private static boolean prepareForCompilation(CompileContext context) {
        Project project = context.getProject();
        if (!AndroidPrecompileTask.checkArtifacts(context)) {
            return false;
        }
        AndroidPrecompileTask.checkAndroidDependencies(context);
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        HashSet addedEntries = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidPlatform platform;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            if (context.isRebuild()) {
                AndroidPrecompileTask.clearResCache(facet, context);
            }
            int platformToolsRevision = (platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform()) != null ? platform.getSdkData().getPlatformToolsRevision() : -1;
            LOG.debug("Platform-tools revision for module " + module.getName() + " is " + platformToolsRevision);
            if (!facet.isLibraryProject()) continue;
            if (platformToolsRevision >= 0 && platformToolsRevision <= 7) {
                LOG.debug("Excluded sources of module " + module.getName());
                AndroidPrecompileTask.excludeAllSourceRoots(module, configuration, (Collection<ExcludeEntryDescription>)addedEntries);
                continue;
            }
            AndroidPrecompileTask.unexcludeAllSourceRoots(facet, configuration);
        }
        if (addedEntries.size() > 0) {
            LOG.debug("Files excluded by Android: " + addedEntries.size());
            CompilerManager.getInstance((Project)project).addCompilationStatusListener((CompilationStatusListener)new MyCompilationStatusListener(project, (Set<ExcludeEntryDescription>)addedEntries), (Disposable)project);
        }
        return true;
    }

    private static void createGenModulesAndSourceRoots(final Project project) {
        final ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facets.add(facet);
        }
        if (facets.size() > 0) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AndroidCompileUtil.createGenModulesAndSourceRoots(project, facets);
                }
            });
        }
    }

    private static boolean checkArtifacts(@NotNull CompileContext context) {
        String message;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidPrecompileTask", "checkArtifacts"));
        }
        final Project project = context.getProject();
        final CompileScope scope = context.getCompileScope();
        Set artifacts = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<Artifact>>(){

            public Set<Artifact> compute() {
                return ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)scope, (boolean)false);
            }
        });
        if (artifacts == null) {
            return true;
        }
        HashSet debugArtifacts = new HashSet();
        HashSet releaseArtifacts = new HashSet();
        HashMap facet2artifacts = new HashMap();
        for (final Artifact artifact : artifacts) {
            AndroidFacet facet;
            ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
            if (properties instanceof AndroidApplicationArtifactProperties) {
                AndroidArtifactSigningMode mode = ((AndroidApplicationArtifactProperties)properties).getSigningMode();
                if (mode == AndroidArtifactSigningMode.DEBUG || mode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
                    debugArtifacts.add(artifact);
                } else {
                    releaseArtifacts.add(artifact);
                }
            }
            if ((facet = (AndroidFacet)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AndroidFacet>(){

                @Nullable
                public AndroidFacet compute() {
                    return AndroidArtifactUtil.getPackagedFacet(project, artifact);
                }
            }))) == null) continue;
            ArrayList<Artifact> list = (ArrayList<Artifact>)facet2artifacts.get((Object)facet);
            if (list == null) {
                list = new ArrayList<Artifact>();
                facet2artifacts.put(facet, list);
            }
            list.add(artifact);
        }
        boolean success = true;
        if (debugArtifacts.size() > 0 && releaseArtifacts.size() > 0) {
            message = "Cannot build debug and release Android artifacts in the same session\nDebug artifacts: " + AndroidPrecompileTask.toString((Collection<Artifact>)debugArtifacts) + "\nRelease artifacts: " + AndroidPrecompileTask.toString((Collection<Artifact>)releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            success = false;
        }
        if (releaseArtifacts.size() > 0 && CompileStepBeforeRun.getRunConfiguration((CompileContext)context) != null) {
            message = "Cannot build release Android artifacts in the 'make before run' session\nRelease artifacts: " + AndroidPrecompileTask.toString((Collection<Artifact>)releaseArtifacts);
            context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            success = false;
        }
        block1: for (Map.Entry entry : facet2artifacts.entrySet()) {
            List list = (List)entry.getValue();
            String moduleName = ((AndroidFacet)((Object)entry.getKey())).getModule().getName();
            if (list.size() <= 1) continue;
            Artifact firstArtifact = (Artifact)list.get(0);
            Object[] firstArtifactProGuardOptions = AndroidPrecompileTask.getProGuardOptions(firstArtifact);
            for (int i = 1; i < list.size(); ++i) {
                Artifact artifact = (Artifact)list.get(i);
                if (Arrays.equals(AndroidPrecompileTask.getProGuardOptions(artifact), firstArtifactProGuardOptions)) continue;
                context.addMessage(CompilerMessageCategory.ERROR, "Artifacts related to the same module '" + moduleName + "' have different ProGuard options: " + firstArtifact.getName() + ", " + artifact.getName(), null, -1, -1);
                success = false;
                continue block1;
            }
        }
        return success;
    }

    @NotNull
    private static Object[] getProGuardOptions(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/compiler/AndroidPrecompileTask", "getProGuardOptions"));
        }
        ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
        if (properties instanceof AndroidApplicationArtifactProperties) {
            AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties;
            Object[] objectArray = new Object[]{p.isRunProGuard(), p.getProGuardCfgFiles()};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPrecompileTask", "getProGuardOptions"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidPrecompileTask", "getProGuardOptions"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static String toString(Collection<Artifact> artifacts) {
        StringBuilder result = new StringBuilder();
        for (Artifact artifact : artifacts) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(artifact.getName());
        }
        return result.toString();
    }

    private static void checkAndroidDependencies(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidPrecompileTask", "checkAndroidDependencies"));
        }
        for (Module module : context.getCompileScope().getAffectedModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            Pair<String, VirtualFile> manifestMergerProp = AndroidRootUtil.getProjectPropertyValue(module, "manifestmerger.enabled");
            if (manifestMergerProp != null && Boolean.parseBoolean((String)manifestMergerProp.getFirst())) {
                context.addMessage(CompilerMessageCategory.WARNING, "[" + module.getName() + "] " + AndroidBundle.message("android.manifest.merger.not.supported.error", new Object[0]), ((VirtualFile)manifestMergerProp.getSecond()).getUrl(), -1, -1);
            }
            if (facet.isLibraryProject()) continue;
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                AndroidFacet depFacet;
                Module depModule;
                ModuleOrderEntry moduleOrderEntry;
                if (!(entry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)entry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || depFacet.isLibraryProject()) continue;
                String message = "Suspicious module dependency " + module.getName() + " -> " + depModule.getName() + ": Android application module depends on other application module. Possibly, you should ";
                if (AndroidMavenUtil.isMavenizedModule(depModule)) {
                    message = message + "change packaging type of module " + depModule.getName() + " to 'apklib' in pom.xml file or ";
                }
                message = message + "change dependency scope to 'Provided'.";
                context.addMessage(CompilerMessageCategory.WARNING, message, null, -1, -1);
            }
        }
    }

    private static void clearResCache(@NotNull AndroidFacet facet, @NotNull CompileContext context) {
        File dir;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidPrecompileTask", "clearResCache"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidPrecompileTask", "clearResCache"));
        }
        Module module = facet.getModule();
        String dirPath = AndroidCompileUtil.findResourcesCacheDirectory(module, false, null);
        if (dirPath != null && (dir = new File(dirPath)).exists()) {
            FileUtil.delete((File)dir);
        }
    }

    private static void unexcludeAllSourceRoots(AndroidFacet facet, ExcludesConfiguration configuration) {
        VirtualFile buildconfigGenDir;
        VirtualFile rsGenRoot;
        VirtualFile aptGenSourceRoot;
        String aptGenSourceRootPath;
        VirtualFile aidlGenSourceRoot;
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)facet.getModule()).getSourceRoots();
        HashSet sourceRootSet = new HashSet();
        sourceRootSet.addAll(Arrays.asList(sourceRoots));
        String aidlGenSourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
        if (aidlGenSourceRootPath != null && (aidlGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aidlGenSourceRootPath)) != null) {
            sourceRootSet.remove(aidlGenSourceRoot);
        }
        if ((aptGenSourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet)) != null && (aptGenSourceRoot = LocalFileSystem.getInstance().findFileByPath(aptGenSourceRootPath)) != null) {
            sourceRootSet.remove(aptGenSourceRoot);
        }
        if ((rsGenRoot = AndroidRootUtil.getRenderscriptGenDir(facet)) != null) {
            sourceRootSet.remove(rsGenRoot);
        }
        if ((buildconfigGenDir = AndroidRootUtil.getBuildconfigGenDir(facet)) != null) {
            sourceRootSet.remove(buildconfigGenDir);
        }
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            VirtualFile file = description.getVirtualFile();
            if (file != null && sourceRootSet.contains(file)) continue;
            configuration.addExcludeEntryDescription(description);
        }
    }

    private static void excludeAllSourceRoots(Module module, ExcludesConfiguration configuration, Collection<ExcludeEntryDescription> addedEntries) {
        VirtualFile[] sourceRoots;
        Project project = module.getProject();
        for (VirtualFile sourceRoot : sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            ExcludeEntryDescription description = new ExcludeEntryDescription(sourceRoot, true, false, (Disposable)project);
            if (configuration.containsExcludeEntryDescription(description)) continue;
            configuration.addExcludeEntryDescription(description);
            addedEntries.add(description);
        }
    }

    private static class MyCompilationStatusListener
    extends CompilationStatusAdapter {
        private final Project myProject;
        private final Set<ExcludeEntryDescription> myEntriesToRemove;

        public MyCompilationStatusListener(Project project, Set<ExcludeEntryDescription> entriesToRemove) {
            this.myProject = project;
            this.myEntriesToRemove = entriesToRemove;
        }

        public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            CompilerManager.getInstance((Project)this.myProject).removeCompilationStatusListener((CompilationStatusListener)this);
            ExcludesConfiguration configuration = ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject)).getExcludedEntriesConfiguration();
            ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
            configuration.removeAllExcludeEntryDescriptions();
            for (ExcludeEntryDescription description : descriptions) {
                if (this.myEntriesToRemove.contains(description)) continue;
                configuration.addExcludeEntryDescription(description);
            }
        }
    }
}

