/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.layout;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<LayoutViewElement> myElement;

    public LayoutStructureViewBuilder(@NotNull DomFileElement<LayoutViewElement> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder", "<init>"));
        }
        this.myElement = element;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        StructureViewModelBase structureViewModelBase = new StructureViewModelBase((PsiFile)this.myElement.getFile(), (StructureViewTreeElement)new LayoutNode((LayoutViewElement)this.myElement.getRootElement()));
        if (structureViewModelBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder", "createStructureViewModel"));
        }
        return structureViewModelBase;
    }

    private static class LayoutNode
    extends PsiTreeElementBase<XmlTag> {
        private final LayoutViewElement myElement;

        public LayoutNode(@NotNull LayoutViewElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode", "<init>"));
            }
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList result = Lists.newArrayList();
            DomElementVisitor visitor = new DomElementVisitor(){

                public void visitLayoutViewElement(LayoutViewElement element) {
                    result.add(new LayoutNode(element));
                }

                public void visitFragment(Fragment element) {
                    result.add(new FragmentNode(element));
                }

                public void visitInclude(Include element) {
                    result.add(new IncludeNode(element));
                }

                public void visitDomElement(DomElement element) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode", "getChildrenBase"));
            }
            return arrayList;
        }

        public Icon getIcon(boolean open) {
            return AndroidDomElementDescriptorProvider.getIconForViewTag(this.myElement.getXmlTag().getName());
        }

        public String getLocationString() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            XmlAttribute idAttribute = xmlTag.getAttribute("id", "http://schemas.android.com/apk/res/android");
            return idAttribute == null ? null : idAttribute.getValue();
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        @NotNull
        public String getPresentableText() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            String className = xmlTag.getName();
            String string = className.substring(className.lastIndexOf(46) + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode", "getPresentableText"));
            }
            return string;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.dumpIndented(builder, 0);
            return builder.toString();
        }

        private void dumpIndented(@NotNull StringBuilder builder, int indentLevel) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$LayoutNode", "dumpIndented"));
            }
            for (int i = 0; i < indentLevel; ++i) {
                builder.append("  ");
            }
            builder.append(this.getPresentableText());
            String locationString = this.getLocationString();
            if (locationString != null) {
                builder.append(" (").append(locationString).append(")");
            }
            builder.append('\n');
            for (StructureViewTreeElement element : this.getChildrenBase()) {
                if (element instanceof LayoutNode) {
                    ((LayoutNode)element).dumpIndented(builder, indentLevel + 1);
                    continue;
                }
                for (int i = 0; i < indentLevel + 1; ++i) {
                    builder.append("  ");
                }
                builder.append(element.toString()).append("\n");
            }
        }
    }

    private static class IncludeNode
    extends PsiTreeElementBase<XmlTag> {
        private final Include myElement;

        private IncludeNode(@NotNull Include element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$IncludeNode", "<init>"));
            }
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$IncludeNode", "getChildrenBase"));
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            String result = "Include";
            String text = this.myElement.getLayout().getRawText();
            if (text != null) {
                result = result + " " + text;
            }
            return result;
        }

        public Icon getIcon(boolean open) {
            return AndroidIcons.Views.Include;
        }

        public String toString() {
            return this.getPresentableText();
        }
    }

    private static class FragmentNode
    extends PsiTreeElementBase<XmlTag> {
        private final Fragment myElement;

        public FragmentNode(@NotNull Fragment element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$FragmentNode", "<init>"));
            }
            super((PsiElement)element.getXmlTag());
            this.myElement = element;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/layout/LayoutStructureViewBuilder$FragmentNode", "getChildrenBase"));
            }
            return list;
        }

        public Icon getIcon(boolean open) {
            return AndroidIcons.Views.Fragment;
        }

        @Nullable
        public String getPresentableText() {
            return Joiner.on((String)" ").skipNulls().join((Object)"Fragment", (Object)this.myElement.getFragmentName().getRawText(), new Object[0]);
        }

        public String toString() {
            return this.getPresentableText();
        }
    }
}

