/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.resources;

import com.android.resources.ResourceType;
import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<Resources> myResources;

    public ResourceStructureViewBuilder(@NotNull DomFileElement<Resources> resources) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder", "<init>"));
        }
        this.myResources = resources;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        StructureViewModelBase structureViewModelBase = new StructureViewModelBase((PsiFile)this.myResources.getFile(), (StructureViewTreeElement)new Root(this.myResources));
        if (structureViewModelBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder", "createStructureViewModel"));
        }
        return structureViewModelBase;
    }

    private static class Leaf
    extends PsiTreeElementBase<PsiElement> {
        private final String myName;
        private final ResourceType myResourceType;

        protected Leaf(@NotNull PsiElement psiElement, @NotNull String name, @NotNull ResourceType resourceType) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf", "<init>"));
            }
            if (resourceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf", "<init>"));
            }
            super(psiElement);
            this.myName = name;
            this.myResourceType = resourceType;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Leaf", "getChildrenBase"));
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            return this.myResourceType.getDisplayName() + " - " + this.myName;
        }

        public String toString() {
            return this.getPresentableText();
        }
    }

    private static class Root
    extends PsiTreeElementBase<PsiElement> {
        private final DomFileElement<Resources> myResources;

        Root(@NotNull DomFileElement<Resources> resources) {
            if (resources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Root", "<init>"));
            }
            super((PsiElement)resources.getXmlElement());
            this.myResources = resources;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList result = Lists.newArrayList();
            DomElementVisitor visitor = new DomElementVisitor(){

                public void visitResourceElement(ResourceElement element) {
                    ResourceType type = AndroidResourceUtil.getType(element.getXmlTag());
                    String name = (String)element.getName().getValue();
                    XmlElement xmlElement = element.getXmlElement();
                    if (name != null && type != null && xmlElement != null) {
                        result.add(new Leaf((PsiElement)xmlElement, name, type));
                    }
                }

                public void visitDomElement(DomElement element) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myResources.getRootElement(), visitor);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Root", "getChildrenBase"));
            }
            return arrayList;
        }

        @NotNull
        public String getPresentableText() {
            String string = String.format("Resources file '%s'", this.myResources.getFile().getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/structure/resources/ResourceStructureViewBuilder$Root", "getPresentableText"));
            }
            return string;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getPresentableText());
            builder.append('\n');
            for (StructureViewTreeElement child : this.getChildrenBase()) {
                builder.append("  ").append(child.toString()).append('\n');
            }
            return builder.toString();
        }
    }
}

