/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaSourceProvider {
    public static Function<IdeaSourceProvider, List<VirtualFile>> MANIFEST_PROVIDER = provider -> {
        VirtualFile manifestFile = provider.getManifestFile();
        return manifestFile == null ? Collections.emptyList() : Collections.singletonList(manifestFile);
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RES_PROVIDER = provider -> Lists.newArrayList(provider.getResDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JAVA_PROVIDER = provider -> Lists.newArrayList(provider.getJavaDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RESOURCES_PROVIDER = provider -> Lists.newArrayList(provider.getResourcesDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> AIDL_PROVIDER = provider -> Lists.newArrayList(provider.getAidlDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_PROVIDER = provider -> Lists.newArrayList(provider.getJniDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_LIBS_PROVIDER = provider -> Lists.newArrayList(provider.getJniLibsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> ASSETS_PROVIDER = provider -> Lists.newArrayList(provider.getAssetsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RENDERSCRIPT_PROVIDER = provider -> Lists.newArrayList(provider.getRenderscriptDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> SHADERS_PROVIDER = provider -> Lists.newArrayList(provider.getShadersDirectories());

    private IdeaSourceProvider() {
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull SourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        Gradle gradle = new Gradle(provider);
        if (gradle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        return gradle;
    }

    @NotNull
    private static List<IdeaSourceProvider> createAll(@NotNull List<SourceProvider> providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "org/jetbrains/android/facet/IdeaSourceProvider", "createAll"));
        }
        ArrayList ideaProviders = Lists.newArrayList();
        for (SourceProvider provider : providers) {
            ideaProviders.add(IdeaSourceProvider.create(provider));
        }
        ArrayList arrayList = ideaProviders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "createAll"));
        }
        return arrayList;
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull NativeAndroidGradleFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        Native native_ = new Native(facet);
        if (native_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        return native_;
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        Legacy legacy = new Legacy(facet);
        if (legacy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "create"));
        }
        return legacy;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract VirtualFile getManifestFile();

    @NotNull
    public abstract Collection<VirtualFile> getJavaDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResourcesDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAidlDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getRenderscriptDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniLibsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAssetsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getShadersDirectories();

    @NotNull
    public static List<IdeaSourceProvider> getCurrentSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
        }
        if (!facet.requiresAndroidModel()) {
            List<IdeaSourceProvider> list = Collections.singletonList(facet.getMainIdeaSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
            }
            return list;
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(androidModel.getActiveSourceProviders());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
            }
            return list;
        }
        List<IdeaSourceProvider> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentSourceProviders"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getCurrentTestSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
        }
        if (!facet.requiresAndroidModel()) {
            List<IdeaSourceProvider> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
            }
            return list;
        }
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(androidModel.getTestSourceProviders());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
            }
            return list;
        }
        List<IdeaSourceProvider> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getCurrentTestSourceProviders"));
        }
        return list;
    }

    @NotNull
    private Collection<VirtualFile> getAllSourceFolders() {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(this.getJavaDirectories());
        srcDirectories.addAll(this.getResDirectories());
        srcDirectories.addAll(this.getAidlDirectories());
        srcDirectories.addAll(this.getRenderscriptDirectories());
        srcDirectories.addAll(this.getAssetsDirectories());
        srcDirectories.addAll(this.getJniDirectories());
        srcDirectories.addAll(this.getJniLibsDirectories());
        ArrayList arrayList = srcDirectories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceFolders"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<File> getAllSourceFolders(@NotNull SourceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceFolders"));
        }
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(provider.getJavaDirectories());
        srcDirectories.addAll(provider.getResDirectories());
        srcDirectories.addAll(provider.getAidlDirectories());
        srcDirectories.addAll(provider.getRenderscriptDirectories());
        srcDirectories.addAll(provider.getAssetsDirectories());
        srcDirectories.addAll(provider.getCDirectories());
        srcDirectories.addAll(provider.getCppDirectories());
        srcDirectories.addAll(provider.getJniLibsDirectories());
        ArrayList arrayList = srcDirectories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceFolders"));
        }
        return arrayList;
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        if (file.equals(this.getManifestFile())) {
            return true;
        }
        for (VirtualFile container : srcDirectories) {
            if (!container.exists()) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (!file.equals(container.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(@NotNull SourceProvider provider, @NotNull File targetFolder) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFolder", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        for (File container : srcDirectories) {
            if (VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(@NotNull SourceProvider provider, @NotNull File file) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/IdeaSourceProvider", "containsFile"));
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        if (FileUtil.filesEqual((File)provider.getManifestFile(), (File)file)) {
            return true;
        }
        for (File container : srcDirectories) {
            File parent = container.getParentFile();
            if (parent != null && parent.isDirectory() && FileUtil.filesEqual((File)parent, (File)file)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)container, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedBy(@NotNull VirtualFile targetFolder) {
        if (targetFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFolder", "org/jetbrains/android/facet/IdeaSourceProvider", "isContainedBy"));
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        for (VirtualFile container : srcDirectories) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)targetFolder, (VirtualFile)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SourceProvider> getAllSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
        }
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            List<SourceProvider> list = Collections.singletonList(facet.getMainSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
            }
            return list;
        }
        List<SourceProvider> list = facet.getAndroidModel().getAllSourceProviders();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllSourceProviders"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getAllIdeaSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllIdeaSourceProviders"));
        }
        if (!facet.requiresAndroidModel() || facet.getAndroidModel() == null) {
            List<IdeaSourceProvider> list = Collections.singletonList(facet.getMainIdeaSourceProvider());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllIdeaSourceProviders"));
            }
            return list;
        }
        List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(IdeaSourceProvider.getAllSourceProviders(facet));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getAllIdeaSourceProviders"));
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getIdeaSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable IdeaSourceProvider defaultIdeaSourceProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getIdeaSourceProvidersForFile"));
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(facet)) {
                if (!provider.containsFile(targetFolder) && !provider.isContainedBy(targetFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultIdeaSourceProvider != null) {
            sourceProviderList.add(defaultIdeaSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getIdeaSourceProvidersForFile"));
        }
        return arrayList;
    }

    @NotNull
    public static List<SourceProvider> getSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable SourceProvider defaultSourceProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getSourceProvidersForFile"));
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            File targetIoFolder = VfsUtilCore.virtualToIoFile((VirtualFile)targetFolder);
            for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                if (!IdeaSourceProvider.containsFile(provider, targetIoFolder) && !IdeaSourceProvider.isContainedBy(provider, targetIoFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultSourceProvider != null) {
            sourceProviderList.add(defaultSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getSourceProvidersForFile"));
        }
        return arrayList;
    }

    public static boolean isManifestFile(@NotNull AndroidFacet facet, @Nullable VirtualFile candidate) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "isManifestFile"));
        }
        if (candidate == null) {
            return false;
        }
        if (facet.requiresAndroidModel()) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                if (!candidate.equals(provider.getManifestFile())) continue;
                return true;
            }
            return false;
        }
        return candidate.equals(facet.getMainIdeaSourceProvider().getManifestFile());
    }

    @NotNull
    public static List<VirtualFile> getManifestFiles(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
        }
        VirtualFile main = facet.getMainIdeaSourceProvider().getManifestFile();
        if (!facet.requiresAndroidModel()) {
            List<Object> list = main != null ? Collections.singletonList(main) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
            }
            return list;
        }
        ArrayList files = Lists.newArrayList();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            VirtualFile manifest = provider.getManifestFile();
            if (manifest == null) continue;
            files.add(manifest);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider", "getManifestFiles"));
        }
        return arrayList;
    }

    private static class Legacy
    extends IdeaSourceProvider {
        @NotNull
        private final AndroidFacet myFacet;

        private Legacy(@NotNull AndroidFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "<init>"));
            }
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getName"));
            }
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            Module module = this.myFacet.getModule();
            VirtualFile file = AndroidRootUtil.getFileByRelativeModulePath(module, this.myFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (file != null) {
                return file;
            }
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 1) {
                return contentRoots[0].findChild("AndroidManifest.xml");
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Module module = this.myFacet.getModule();
            HashSet dirs = new HashSet();
            Collections.addAll(dirs, ModuleRootManager.getInstance((Module)module).getContentRoots());
            HashSet hashSet = dirs;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJavaDirectories"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResourcesDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getAidlDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getRenderscriptDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJniDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getJniLibsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            String resRelPath = this.myFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), resRelPath, true);
            if (dir != null) {
                Set<VirtualFile> set = Collections.singleton(dir);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResDirectories"));
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getResDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getAssetsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Legacy", "getShadersDirectories"));
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Legacy that = (Legacy)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Native
    extends IdeaSourceProvider {
        @NotNull
        private final NativeAndroidGradleFacet myFacet;

        private Native(@NotNull NativeAndroidGradleFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "<init>"));
            }
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getName"));
            }
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getJavaDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getResourcesDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getAidlDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getRenderscriptDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            NativeAndroidGradleModel nativeAndroidGradleModel = this.myFacet.getNativeAndroidGradleModel();
            if (nativeAndroidGradleModel == null) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getJniDirectories"));
                }
                return list;
            }
            Collection<File> sourceFolders = nativeAndroidGradleModel.getSelectedVariant().getSourceFolders();
            LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)sourceFolders.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : sourceFolders) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getJniDirectories"));
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getJniLibsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getResDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getAssetsDirectories"));
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Native", "getShadersDirectories"));
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Native that = (Native)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }
    }

    private static class Gradle
    extends IdeaSourceProvider {
        private final SourceProvider myProvider;
        private VirtualFile myManifestFile;
        private File myManifestIoFile;

        private Gradle(@NotNull SourceProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "<init>"));
            }
            this.myProvider = provider;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myProvider.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            File manifestFile = this.myProvider.getManifestFile();
            if (this.myManifestFile == null || !FileUtil.filesEqual((File)manifestFile, (File)this.myManifestIoFile)) {
                this.myManifestIoFile = manifestFile;
                this.myManifestFile = VfsUtil.findFileByIoFile((File)manifestFile, (boolean)false);
            }
            return this.myManifestFile;
        }

        private static Collection<VirtualFile> convertFileSet(@NotNull Collection<File> fileSet) {
            if (fileSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "convertFileSet"));
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)fileSet.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : fileSet) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
            return result;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getJavaDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJavaDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getResourcesDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getResourcesDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getAidlDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getAidlDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getRenderscriptDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getRenderscriptDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            java.util.HashSet jniDirectories = Sets.newHashSet();
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCDirectories()));
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCppDirectories()));
            java.util.HashSet hashSet = jniDirectories;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJniDirectories"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getJniLibsDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getJniLibsDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getResDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getResDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getAssetsDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getAssetsDirectories"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getShadersDirectories());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/IdeaSourceProvider$Gradle", "getShadersDirectories"));
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gradle that = (Gradle)o;
            if (!this.myProvider.getName().equals(that.getName())) {
                return false;
            }
            return this.myProvider.getManifestFile().getPath().equals(that.myProvider.getManifestFile().getPath());
        }

        public int hashCode() {
            return this.myProvider.getManifestFile().getPath().hashCode();
        }
    }
}

