/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface AndroidLintQuickFix {
    public static final AndroidLintQuickFix[] EMPTY_ARRAY = new AndroidLintQuickFix[0];

    public void apply(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.Context var3);

    public boolean isApplicable(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull AndroidQuickfixContexts.ContextType var3);

    @NotNull
    public String getName();

    public static class LocalFixWrapper
    implements LocalQuickFix {
        private final AndroidLintQuickFix myFix;
        private final PsiElement myStart;
        private final PsiElement myEnd;

        public LocalFixWrapper(@NotNull AndroidLintQuickFix fix, @NotNull PsiElement start, @NotNull PsiElement end) {
            if (fix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            if (start == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            if (end == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "<init>"));
            }
            this.myFix = fix;
            this.myStart = start;
            this.myEnd = end;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myFix.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/android/inspections/lint/AndroidLintQuickFix$LocalFixWrapper", "applyFix"));
            }
            this.myFix.apply(this.myStart, this.myEnd, AndroidQuickfixContexts.BatchContext.getInstance());
        }
    }
}

