/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddActivityToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        if ("Add activity to manifest" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/intentions/AddActivityToManifest", "getText"));
        }
        return "Add activity to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddActivityToManifest", "isAvailable"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddActivityToManifest", "isAvailable"));
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.app.Activity")) {
            return false;
        }
        return !AddActivityToManifest.isRegisteredActivity(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/intentions/AddActivityToManifest", "invoke"));
        }
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/android/intentions/AddActivityToManifest", "invoke"));
        }
        Application application = manifest.getApplication();
        application.addActivity().getActivityClass().setValue(psiClass);
    }

    private static boolean isRegisteredActivity(PsiClass psiClass, Application application) {
        for (Activity activity : application.getActivities()) {
            if (!psiClass.isEquivalentTo((PsiElement)activity.getActivityClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

